/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jpedal.PdfDecoder;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.objects.StoryData;
import org.jpedal.objects.TextState;
import org.jpedal.utils.Fonts;
import org.jpedal.utils.LineBreaker;
import org.jpedal.utils.repositories.Vector_Int;

public class PdfData
extends StoryData {
    Vector_Int itemsOnEachPage = new Vector_Int(5);
    Vector_Int displacementForEachPage = new Vector_Int(5);
    public static final int TEXT = 0;
    public static final int IMAGE = 1;
    public static final int HORIZONTAL_LEFT_TO_RIGHT = 0;
    public static final int HORIZONTAL_RIGHT_TO_LEFT = 1;
    public static final int VERTICAL_TOP_TO_BOTTOM = 2;
    public static final int VERTICAL_BOTTOM_TO_TOP = 3;
    private List text_objects;
    Map extractedTextFields = new HashMap();
    Map extractedXMLFields = new HashMap();
    private int pointer = 0;
    private int additionalPageCount = 0;
    private int originalSize = -1;
    public String[] fragments = new String[this.max];
    public int[] parent = new int[this.max];
    private boolean widthIsEmbedded = false;
    public float maxY = 0.0f;
    public float maxX = 0.0f;
    public int[] fontSize;
    private Map globalValues = new HashMap();
    private Map globalSettings = new HashMap();

    public PdfData() {
        this.text_objects = new Vector();
        for (int i = 0; i < this.max; ++i) {
            this.parent[i] = -1;
        }
    }

    public final Map getTextElementAt(int n) {
        return (Map)this.text_objects.get(n);
    }

    public final int getRawTextElementCount() {
        return this.pointer;
    }

    public final void resetTextList(List list) {
        this.text_objects = list;
    }

    public final void flushTextList(boolean bl) {
        this.text_objects = new Vector();
        if (!bl) {
            this.pointer = 0;
            this.contents = new String[this.max];
            this.f_writingMode = new int[this.max];
            this.f_font_used = new String[this.max];
            this.font_data = new String[this.max];
            this.text_length = new int[this.max];
            this.lineCount = new int[this.max];
            this.move_command = new int[this.max];
            this.f_character_spacing = new float[this.max];
            this.token_counter = new int[this.max];
            this.f_end_font_size = new int[this.max];
            this.space_width = new float[this.max];
            this.f_x1 = new float[this.max];
            this.colorTag = new String[this.max];
            this.f_x2 = new float[this.max];
            this.f_y1 = new float[this.max];
            this.f_y2 = new float[this.max];
        }
        this.itemsOnEachPage.clear();
        this.displacementForEachPage.clear();
        this.additionalPageCount = 0;
    }

    public final int getTextElementCount() {
        return this.text_objects.size();
    }

    public final void addImageElement(float f, float f2, float f3, float f4, String string) {
        this.f_x1[this.pointer] = f;
        this.objectType[this.pointer] = 1;
        this.f_x2[this.pointer] = f + f3;
        this.f_y1[this.pointer] = f2 + f4;
        this.f_y2[this.pointer] = f2;
        this.fragments[this.pointer] = "" + this.pointer;
        this.contents[this.pointer] = string;
        this.unformattedContent[this.pointer] = string;
        ++this.pointer;
        if (this.pointer == this.max) {
            this.resizeArrays(0);
        }
    }

    public final void breakLineInHalf(int n, float f, float f2, float f3, float f4, boolean bl) {
        if (bl) {
            System.out.println("id=" + n + " x1,y1=" + f + " " + f2 + " x2,y2=" + f3 + " " + f4 + "\n" + this.contents[n]);
        }
        this.f_writingMode[this.pointer] = this.f_writingMode[n];
        this.font_data[this.pointer] = this.font_data[n];
        this.move_command[this.pointer] = this.move_command[n];
        this.f_character_spacing[this.pointer] = this.f_character_spacing[n];
        this.colorTag[this.pointer] = this.colorTag[n];
        this.objectType[this.pointer] = 0;
        this.token_counter[this.pointer] = this.token_counter[n];
        this.f_end_font_size[this.pointer] = this.f_end_font_size[n];
        this.f_font_used[this.pointer] = this.f_font_used[n];
        this.space_width[this.pointer] = this.space_width[n];
        LineBreaker lineBreaker = new LineBreaker();
        lineBreaker.breakLine(this.contents[n], f, f2, f3, f4, bl);
        this.f_x1[this.pointer] = lineBreaker.endX;
        this.f_x2[this.pointer] = this.f_x2[n];
        this.f_x1[n] = this.f_x1[n];
        this.f_x2[n] = lineBreaker.startX;
        this.f_y1[this.pointer] = this.f_y1[n];
        this.f_y2[this.pointer] = this.f_y2[n];
        this.text_length[this.pointer] = lineBreaker.charsCounted;
        this.text_length[n] = this.text_length[n] - lineBreaker.charsCounted;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.contents[n].substring(0, lineBreaker.brk).trim());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.contents[n].substring(lineBreaker.brk, this.contents[n].length()).trim());
        if (PdfDecoder.isXMLExtraction()) {
            stringBuffer2.insert(0, this.font_data[this.pointer]);
            stringBuffer.append(Fonts.fe);
        }
        if (this.isColorExtracted()) {
            stringBuffer2.insert(0, this.colorTag[this.pointer]);
            stringBuffer.append("</color>");
        }
        this.contents[n] = stringBuffer.toString();
        this.contents[this.pointer] = stringBuffer2.toString();
        this.lineCount[this.pointer] = this.lineCount[n];
        if (bl) {
            System.out.println("orig=" + PdfGroupingAlgorithms.removeHiddenMarkers(stringBuffer.toString()) + "<");
            System.out.println("original at " + this.f_x1[n] + " " + this.f_y1[n] + " " + this.f_x2[n] + " " + this.f_y2[n]);
            System.out.println("removed=" + PdfGroupingAlgorithms.removeHiddenMarkers(stringBuffer2.toString()) + "<");
            System.out.println("removed at " + this.f_x1[this.pointer] + " " + this.f_y1[this.pointer] + " " + this.f_x2[this.pointer] + " " + this.f_y2[this.pointer]);
        }
        ++this.pointer;
        if (this.pointer == this.max) {
            this.resizeArrays(0);
        }
    }

    public final void addRawTextElement(float f, int n, String string, float f2, TextState textState, float f3, float f4, float f5, float f6, int n2, StringBuffer stringBuffer, int n3, int n4, String string2) {
        if (stringBuffer.length() > 0) {
            int n5;
            if (PdfDecoder.isXMLExtraction()) {
                stringBuffer.insert(0, string);
                stringBuffer.append(Fonts.fe);
            }
            if (this.isColorExtracted()) {
                stringBuffer.insert(0, string2);
                stringBuffer.append("</color>");
            }
            this.f_writingMode[this.pointer] = n;
            this.font_data[this.pointer] = string;
            this.text_length[this.pointer] = n4;
            this.move_command[this.pointer] = n2;
            this.f_character_spacing[this.pointer] = f;
            this.f_x1[this.pointer] = f3;
            this.colorTag[this.pointer] = string2;
            this.f_x2[this.pointer] = f5;
            this.f_y1[this.pointer] = f4;
            this.f_y2[this.pointer] = f6;
            this.objectType[this.pointer] = 0;
            this.lineCount[this.pointer] = 1;
            this.contents[this.pointer] = stringBuffer.toString();
            this.token_counter[this.pointer] = n3;
            this.f_end_font_size[this.pointer] = n5 = textState.getCurrentFontSize();
            this.f_font_used[this.pointer] = textState.getFontName();
            this.space_width[this.pointer] = f2 * 1000.0f;
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays(0);
            }
        }
    }

    public final void addRawBrokenFragment(int n, StringBuffer stringBuffer, float f, float f2, float f3, float f4, String string, String string2) {
        if (f > 0.0f & f3 > 0.0f & f2 > 0.0f & f4 > 0.0f) {
            if (PdfDecoder.isXMLExtraction() && !stringBuffer.toString().endsWith(Fonts.fe) && !stringBuffer.toString().endsWith("</color>")) {
                stringBuffer.append(Fonts.fe);
            }
            this.f_writingMode[this.pointer] = this.f_writingMode[n];
            this.font_data[this.pointer] = this.font_data[n];
            this.text_length[this.pointer] = this.text_length[n];
            this.lineCount[this.pointer] = this.lineCount[n];
            this.move_command[this.pointer] = this.move_command[n];
            this.f_character_spacing[this.pointer] = this.f_character_spacing[n];
            this.f_x1[this.pointer] = f;
            this.f_x2[this.pointer] = f2;
            this.f_y1[this.pointer] = f3;
            this.f_y2[this.pointer] = f4;
            this.colorTag[this.pointer] = string2;
            this.contents[this.pointer] = stringBuffer.toString();
            this.token_counter[this.pointer] = this.token_counter[n];
            this.f_end_font_size[this.pointer] = this.f_end_font_size[n];
            this.f_font_used[this.pointer] = this.f_font_used[n];
            this.space_width[this.pointer] = this.space_width[n];
            ++this.pointer;
            if (this.pointer == this.max) {
                this.resizeArrays(0);
            }
        }
    }

    public PdfData cloneData() {
        int n = this.contents.length;
        PdfData pdfData = new PdfData();
        pdfData.resizeArrays(-n);
        System.arraycopy(this.contents, 0, pdfData.contents, 0, n);
        System.arraycopy(this.rawData, 0, pdfData.rawData, 0, n);
        System.arraycopy(this.unformattedContent, 0, pdfData.unformattedContent, 0, n);
        System.arraycopy(this.f_writingMode, 0, pdfData.f_writingMode, 0, n);
        System.arraycopy(this.f_font_used, 0, pdfData.f_font_used, 0, n);
        System.arraycopy(this.colorTag, 0, pdfData.colorTag, 0, n);
        System.arraycopy(this.font_data, 0, pdfData.font_data, 0, n);
        System.arraycopy(this.fragments, 0, pdfData.fragments, 0, n);
        System.arraycopy(this.text_length, 0, pdfData.text_length, 0, n);
        System.arraycopy(this.lineCount, 0, pdfData.lineCount, 0, n);
        System.arraycopy(this.move_command, 0, pdfData.move_command, 0, n);
        System.arraycopy(this.f_character_spacing, 0, pdfData.f_character_spacing, 0, n);
        System.arraycopy(this.parent, 0, pdfData.parent, 0, n);
        System.arraycopy(this.prefix, 0, pdfData.prefix, 0, n);
        System.arraycopy(this.token_counter, 0, pdfData.token_counter, 0, n);
        System.arraycopy(this.links, 0, pdfData.links, 0, n);
        System.arraycopy(this.category, 0, pdfData.category, 0, n);
        System.arraycopy(this.objectType, 0, pdfData.objectType, 0, n);
        System.arraycopy(this.f_end_font_size, 0, pdfData.f_end_font_size, 0, n);
        System.arraycopy(this.space_width, 0, pdfData.space_width, 0, n);
        System.arraycopy(this.f_x1, 0, pdfData.f_x1, 0, n);
        System.arraycopy(this.f_x2, 0, pdfData.f_x2, 0, n);
        System.arraycopy(this.f_y1, 0, pdfData.f_y1, 0, n);
        System.arraycopy(this.f_y2, 0, pdfData.f_y2, 0, n);
        pdfData.pointer = this.pointer;
        pdfData.additionalPageCount = this.additionalPageCount;
        pdfData.originalSize = this.originalSize;
        pdfData.widthIsEmbedded = this.widthIsEmbedded;
        pdfData.maxY = this.maxY;
        pdfData.maxX = this.maxX;
        pdfData.max = this.max;
        return pdfData;
    }

    public void merge(PdfData pdfData, int n, int n2, boolean bl) {
        Object object;
        StringTokenizer stringTokenizer;
        int n3;
        int n4;
        int n5;
        int n6;
        ++this.additionalPageCount;
        if (this.originalSize == -1) {
            this.originalSize = this.f_x1.length;
        }
        if ((n6 = this.getRawTextElementCount()) > this.f_x1.length) {
            n6 = this.f_x1.length;
        }
        if ((n5 = pdfData.getRawTextElementCount()) > pdfData.f_x1.length) {
            n5 = pdfData.f_x1.length;
        }
        this.pointer = n4 = n6 + n5;
        for (int i = 0; i < n5; ++i) {
            pdfData.f_x1[i] = (float)n + pdfData.f_x1[i];
            pdfData.f_x2[i] = (float)n + pdfData.f_x2[i];
        }
        if (bl) {
            this.itemsOnEachPage.addElement(n6);
            this.displacementForEachPage.addElement(n);
        }
        String[] stringArray = this.contents;
        this.contents = new String[n4];
        System.arraycopy(stringArray, 0, this.contents, 0, n6);
        System.arraycopy(pdfData.contents, 0, this.contents, n6, n5);
        stringArray = this.rawData;
        this.rawData = new String[n4];
        System.arraycopy(stringArray, 0, this.rawData, 0, n6);
        System.arraycopy(pdfData.rawData, 0, this.rawData, n6, n5);
        for (n3 = n6; n3 < n6 + n5; ++n3) {
            if (this.rawData[n3] == null) continue;
            stringTokenizer = new StringTokenizer(this.rawData[n3], hiddenMarker);
            object = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
                float f = Float.parseFloat(stringTokenizer2.nextToken()) + (float)n;
                float f2 = Float.parseFloat(stringTokenizer2.nextToken());
                float f3 = Float.parseFloat(stringTokenizer2.nextToken()) + (float)n;
                float f4 = Float.parseFloat(stringTokenizer2.nextToken());
                int n7 = Integer.parseInt(stringTokenizer2.nextToken()) + n2;
                ((StringBuffer)object).append(hiddenMarker + f + " " + f2 + " " + f3 + " " + f4 + " " + n7 + hiddenMarker + string2);
            }
            this.rawData[n3] = ((StringBuffer)object).toString();
        }
        stringArray = this.unformattedContent;
        this.unformattedContent = new String[n4];
        System.arraycopy(stringArray, 0, this.unformattedContent, 0, n6);
        System.arraycopy(pdfData.unformattedContent, 0, this.unformattedContent, n6, n5);
        int[] nArray = this.f_writingMode;
        this.f_writingMode = new int[n4];
        this.f_writingMode = new int[n4];
        System.arraycopy(nArray, 0, this.f_writingMode, 0, n6);
        System.arraycopy(pdfData.f_writingMode, 0, this.f_writingMode, n6, n5);
        stringArray = this.f_font_used;
        this.f_font_used = new String[n4];
        System.arraycopy(stringArray, 0, this.f_font_used, 0, n6);
        System.arraycopy(pdfData.f_font_used, 0, this.f_font_used, n6, n5);
        stringArray = this.colorTag;
        this.colorTag = new String[n4];
        System.arraycopy(stringArray, 0, this.colorTag, 0, n6);
        System.arraycopy(pdfData.colorTag, 0, this.colorTag, n6, n5);
        stringArray = this.font_data;
        this.font_data = new String[n4];
        System.arraycopy(stringArray, 0, this.font_data, 0, n6);
        System.arraycopy(pdfData.font_data, 0, this.font_data, n6, n5);
        stringArray = this.fragments;
        this.fragments = new String[n4];
        System.arraycopy(stringArray, 0, this.fragments, 0, n6);
        System.arraycopy(pdfData.fragments, 0, this.fragments, n6, n5);
        for (n3 = n6; n3 < n6 + n5; ++n3) {
            if (this.fragments[n3] == null) continue;
            stringTokenizer = new StringTokenizer(this.fragments[n3]);
            object = new StringBuffer();
            int n8 = stringTokenizer.countTokens();
            for (int i = 0; i < n8; ++i) {
                int n9 = Integer.parseInt(stringTokenizer.nextToken()) + n2;
                ((StringBuffer)object).append(n9);
                ((StringBuffer)object).append(' ');
            }
            this.fragments[n3] = ((StringBuffer)object).toString();
        }
        nArray = this.text_length;
        this.text_length = new int[n4];
        System.arraycopy(nArray, 0, this.text_length, 0, n6);
        System.arraycopy(pdfData.text_length, 0, this.text_length, n6, n5);
        nArray = this.lineCount;
        this.lineCount = new int[n4];
        System.arraycopy(nArray, 0, this.lineCount, 0, n6);
        System.arraycopy(pdfData.lineCount, 0, this.lineCount, n6, n5);
        nArray = this.move_command;
        this.move_command = new int[n4];
        System.arraycopy(nArray, 0, this.move_command, 0, n6);
        System.arraycopy(pdfData.move_command, 0, this.move_command, n6, n5);
        float[] fArray = this.f_character_spacing;
        this.f_character_spacing = new float[n4];
        System.arraycopy(fArray, 0, this.f_character_spacing, 0, n6);
        System.arraycopy(pdfData.f_character_spacing, 0, this.f_character_spacing, n6, n5);
        nArray = this.parent;
        this.parent = new int[n4];
        for (n3 = n6; n3 < n4; ++n3) {
            this.parent[n3] = -1;
        }
        System.arraycopy(nArray, 0, this.parent, 0, n6);
        System.arraycopy(pdfData.parent, 0, this.parent, n6, n5);
        for (n3 = n6; n3 < n4; ++n3) {
            if (this.parent[n3] == -1) continue;
            this.parent[n3] = this.parent[n3] + n6;
        }
        stringArray = this.prefix;
        this.prefix = new String[n4];
        for (n3 = n6; n3 < n4; ++n3) {
            this.prefix[n3] = null;
        }
        System.arraycopy(stringArray, 0, this.prefix, 0, n6);
        System.arraycopy(pdfData.prefix, 0, this.prefix, n6, n5);
        nArray = this.token_counter;
        this.token_counter = new int[n4];
        System.arraycopy(nArray, 0, this.token_counter, 0, n6);
        System.arraycopy(pdfData.token_counter, 0, this.token_counter, n6, n5);
        Object[] objectArray = this.links;
        this.links = new Object[n4];
        System.arraycopy(objectArray, 0, this.links, 0, n6);
        System.arraycopy(pdfData.links, 0, this.links, n6, n5);
        for (int i = n6; i < n4; ++i) {
            if (this.links[i] == null) continue;
            object = (int[])this.links[i];
            int n10 = ((Object)object).length;
            for (int j = 0; j < n10; ++j) {
                if (object[j] == -1) continue;
                object[j] = object[j] + n6;
            }
            this.links[i] = object;
        }
        stringArray = this.category;
        this.category = new String[n4];
        System.arraycopy(stringArray, 0, this.category, 0, n6);
        System.arraycopy(pdfData.category, 0, this.category, n6, n5);
        nArray = this.objectType;
        this.objectType = new int[n4];
        System.arraycopy(nArray, 0, this.objectType, 0, n6);
        System.arraycopy(pdfData.objectType, 0, this.objectType, n6, n5);
        nArray = this.f_end_font_size;
        this.f_end_font_size = new int[n4];
        System.arraycopy(nArray, 0, this.f_end_font_size, 0, n6);
        System.arraycopy(pdfData.f_end_font_size, 0, this.f_end_font_size, n6, n5);
        fArray = this.space_width;
        this.space_width = new float[n4];
        System.arraycopy(fArray, 0, this.space_width, 0, n6);
        System.arraycopy(pdfData.space_width, 0, this.space_width, n6, n5);
        fArray = this.f_x1;
        this.f_x1 = new float[n4];
        System.arraycopy(fArray, 0, this.f_x1, 0, n6);
        System.arraycopy(pdfData.f_x1, 0, this.f_x1, n6, n5);
        fArray = this.f_x2;
        this.f_x2 = new float[n4];
        System.arraycopy(fArray, 0, this.f_x2, 0, n6);
        System.arraycopy(pdfData.f_x2, 0, this.f_x2, n6, n5);
        fArray = this.f_y1;
        this.f_y1 = new float[n4];
        System.arraycopy(fArray, 0, this.f_y1, 0, n6);
        System.arraycopy(pdfData.f_y1, 0, this.f_y1, n6, n5);
        fArray = this.f_y2;
        this.f_y2 = new float[n4];
        System.arraycopy(fArray, 0, this.f_y2, 0, n6);
        System.arraycopy(pdfData.f_y2, 0, this.f_y2, n6, n5);
        System.out.println("Merge done");
    }

    public void resizeArrays(int n) {
        int n2;
        if (n < 0) {
            this.pointer = this.max = -n;
        } else if (n == 0) {
            this.max = this.max < 5000 ? (this.max *= 5) : (this.max < 10000 ? (this.max *= 2) : (this.max += 1000));
        } else {
            this.max = this.contents.length + n - 1;
            this.pointer = this.contents.length;
        }
        String[] stringArray = this.contents;
        this.contents = new String[this.max];
        System.arraycopy(stringArray, 0, this.contents, 0, this.pointer);
        stringArray = this.rawData;
        this.rawData = new String[this.max];
        System.arraycopy(stringArray, 0, this.rawData, 0, this.pointer);
        stringArray = this.unformattedContent;
        this.unformattedContent = new String[this.max];
        System.arraycopy(stringArray, 0, this.unformattedContent, 0, this.pointer);
        int[] nArray = this.f_writingMode;
        this.f_writingMode = new int[this.max];
        this.f_writingMode = new int[this.max];
        System.arraycopy(nArray, 0, this.f_writingMode, 0, this.pointer);
        stringArray = this.f_font_used;
        this.f_font_used = new String[this.max];
        System.arraycopy(stringArray, 0, this.f_font_used, 0, this.pointer);
        stringArray = this.colorTag;
        this.colorTag = new String[this.max];
        System.arraycopy(stringArray, 0, this.colorTag, 0, this.pointer);
        stringArray = this.font_data;
        this.font_data = new String[this.max];
        System.arraycopy(stringArray, 0, this.font_data, 0, this.pointer);
        stringArray = this.fragments;
        this.fragments = new String[this.max];
        System.arraycopy(stringArray, 0, this.fragments, 0, this.pointer);
        nArray = this.text_length;
        this.text_length = new int[this.max];
        System.arraycopy(nArray, 0, this.text_length, 0, this.pointer);
        nArray = this.lineCount;
        this.lineCount = new int[this.max];
        System.arraycopy(nArray, 0, this.lineCount, 0, this.pointer);
        nArray = this.move_command;
        this.move_command = new int[this.max];
        System.arraycopy(nArray, 0, this.move_command, 0, this.pointer);
        float[] fArray = this.f_character_spacing;
        this.f_character_spacing = new float[this.max];
        System.arraycopy(fArray, 0, this.f_character_spacing, 0, this.pointer);
        nArray = this.parent;
        this.parent = new int[this.max];
        for (n2 = this.pointer; n2 < this.max; ++n2) {
            this.parent[n2] = -1;
        }
        System.arraycopy(nArray, 0, this.parent, 0, this.pointer);
        stringArray = this.prefix;
        this.prefix = new String[this.max];
        for (n2 = this.pointer; n2 < this.max; ++n2) {
            this.prefix[n2] = null;
        }
        System.arraycopy(stringArray, 0, this.prefix, 0, this.pointer);
        nArray = this.token_counter;
        this.token_counter = new int[this.max];
        System.arraycopy(nArray, 0, this.token_counter, 0, this.pointer);
        Object[] objectArray = this.links;
        this.links = new Object[this.max];
        System.arraycopy(objectArray, 0, this.links, 0, this.pointer);
        stringArray = this.category;
        this.category = new String[this.max];
        System.arraycopy(stringArray, 0, this.category, 0, this.pointer);
        nArray = this.objectType;
        this.objectType = new int[this.max];
        System.arraycopy(nArray, 0, this.objectType, 0, this.pointer);
        nArray = this.f_end_font_size;
        this.f_end_font_size = new int[this.max];
        System.arraycopy(nArray, 0, this.f_end_font_size, 0, this.pointer);
        fArray = this.space_width;
        this.space_width = new float[this.max];
        System.arraycopy(fArray, 0, this.space_width, 0, this.pointer);
        fArray = this.f_x1;
        this.f_x1 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_x1, 0, this.pointer);
        fArray = this.f_x2;
        this.f_x2 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_x2, 0, this.pointer);
        fArray = this.f_y1;
        this.f_y1 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_y1, 0, this.pointer);
        fArray = this.f_y2;
        this.f_y2 = new float[this.max];
        System.arraycopy(fArray, 0, this.f_y2, 0, this.pointer);
    }

    public final void removeTextElementAt(int n) {
        this.text_objects.remove(new Integer(n));
    }

    public String getFragments(int n) {
        return this.fragments[n];
    }

    public int getParent(int n) {
        return this.parent[n];
    }

    public String getPrefix(int n) {
        return this.prefix[n];
    }

    public void setPrefix(int n, String string) {
        int n2 = this.prefix.length;
        if (n >= n2) {
            this.max = this.prefix.length + 100;
            String[] stringArray = this.prefix;
            this.prefix = new String[this.max];
            System.arraycopy(stringArray, 0, this.prefix, 0, n2);
            for (int i = n2; i < this.max; ++i) {
                this.prefix[i] = null;
            }
        }
        this.prefix[n] = string;
    }

    public void setParent(int n, int n2) {
        int n3 = this.parent.length;
        if (n >= n3) {
            this.max = this.parent.length + 100;
            int[] nArray = this.parent;
            this.parent = new int[this.max];
            System.arraycopy(nArray, 0, this.parent, 0, n3);
            for (int i = n3; i < this.max; ++i) {
                this.parent[i] = -1;
            }
        }
        this.parent[n] = n2;
    }

    public void widthIsEmbedded() {
        this.widthIsEmbedded = true;
    }

    public boolean IsEmbedded() {
        return this.widthIsEmbedded;
    }

    public int getFontSize(int n) {
        return this.fontSize[n];
    }

    public String getFontTag(int n) {
        return this.f_font_used[n];
    }

    public String getGlobalField(String string) {
        return (String)this.globalValues.get(string);
    }

    public void setGlobalField(String string, String string2) {
        this.globalValues.put(string, string2);
    }

    public void setMetaFieldUserDefinable(String string) {
        this.globalSettings.put("editable-" + string, "x");
    }

    public boolean isMetaFieldUserDefinable(String string) {
        return this.globalSettings.get("editable-" + string) != null;
    }

    public void setMetaFieldValues(String string, String string2) {
        this.globalSettings.put("values-" + string, string2);
    }

    public String getMetaFieldValues(String string) {
        return (String)this.globalSettings.get("values-" + string);
    }

    public Object[] getGlobalFields() {
        return this.globalValues.keySet().toArray();
    }

    public int getGlobalCategoryCount() {
        return this.globalValues.size();
    }

    public int getRegExpStatus(int n) {
        return this.regExpStatus[n];
    }

    public void setRegExpStatus(int n, int n2) {
        int n3 = this.regExpStatus.length;
        if (n >= n3) {
            this.max = this.regExpStatus.length + 100;
            if (n > this.max) {
                this.max = n + 20;
            }
            int[] nArray = this.regExpStatus;
            this.regExpStatus = new int[this.max];
            System.arraycopy(nArray, 0, this.regExpStatus, 0, n3);
            for (int i = n3; i < this.max; ++i) {
                this.regExpStatus[i] = -1;
            }
        }
        this.regExpStatus[n] = n2;
    }

    public void addExtractedXMLField(String string, String string2, int n) {
        String string3;
        Integer n2 = new Integer(n);
        HashMap<String, String> hashMap = (HashMap<String, String>)this.extractedXMLFields.get(n2);
        if (hashMap == null) {
            hashMap = new HashMap<String, String>();
        }
        if ((string3 = (String)hashMap.get(string)) != null) {
            string2 = string3 + string2;
        }
        hashMap.put(string, string2);
        this.extractedXMLFields.put(n2, hashMap);
    }

    public Map getExtractedTextFields(int n) {
        return (Map)this.extractedTextFields.get(new Integer(n));
    }

    public Map getExtractedXMLFields(int n) {
        return (Map)this.extractedXMLFields.get(new Integer(n));
    }

    public void resetExtractedTextFields(int n, Map map) {
        this.extractedTextFields.put(new Integer(n), map);
    }

    public void flushExtractedFields() {
        this.extractedTextFields.clear();
        this.extractedXMLFields.clear();
    }

    public int getPageCount() {
        return 1 + this.additionalPageCount;
    }

    public void serialiseAsObject(String string) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(string)));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PdfData deserialiseAsObject(String string) {
        PdfData pdfData = new PdfData();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(new FileInputStream(string)));
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            pdfData = (PdfData)objectInputStream.readObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pdfData;
    }

    public void serialise(String string) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new DataOutputStream(new FileOutputStream(string)));
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            objectOutputStream.writeInt(this.additionalPageCount);
            objectOutputStream.writeInt(this.originalSize);
            objectOutputStream.writeBoolean(this.widthIsEmbedded);
            objectOutputStream.writeBoolean(this.isColorExtracted);
            objectOutputStream.writeInt(this.pointer);
            objectOutputStream.writeInt(this.max);
            objectOutputStream.writeFloat(this.maxX);
            objectOutputStream.writeFloat(this.maxY);
            objectOutputStream.writeObject(this.f_x1);
            objectOutputStream.writeObject(this.f_y1);
            objectOutputStream.writeObject(this.f_x2);
            objectOutputStream.writeObject(this.f_y2);
            objectOutputStream.writeObject(this.lx1);
            objectOutputStream.writeObject(this.ly1);
            objectOutputStream.writeObject(this.lx2);
            objectOutputStream.writeObject(this.ly2);
            objectOutputStream.writeObject(this.contents);
            objectOutputStream.writeObject(this.rawData);
            objectOutputStream.writeObject(this.unformattedContent);
            objectOutputStream.writeObject(this.f_writingMode);
            objectOutputStream.writeObject(this.f_font_used);
            objectOutputStream.writeObject(this.colorTag);
            objectOutputStream.writeObject(this.font_data);
            objectOutputStream.writeObject(this.fragments);
            objectOutputStream.writeObject(this.text_length);
            objectOutputStream.writeObject(this.lineCount);
            objectOutputStream.writeObject(this.move_command);
            objectOutputStream.writeObject(this.f_character_spacing);
            objectOutputStream.writeObject(this.parent);
            objectOutputStream.writeObject(this.prefix);
            objectOutputStream.writeObject(this.token_counter);
            objectOutputStream.writeObject(this.links);
            objectOutputStream.writeObject(this.category);
            objectOutputStream.writeObject(this.objectType);
            objectOutputStream.writeObject(this.f_end_font_size);
            objectOutputStream.writeObject(this.space_width);
            objectOutputStream.writeObject(this.fontSize);
            objectOutputStream.writeObject(this.regExpStatus);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public PdfData deserialise(String string) {
        PdfData pdfData = new PdfData();
        this.extractedTextFields.clear();
        this.extractedXMLFields.clear();
        this.text_objects.clear();
        this.globalValues.clear();
        this.globalSettings.clear();
        this.newShapes.clear();
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new DataInputStream(new FileInputStream(string)));
            ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
            pdfData.additionalPageCount = objectInputStream.readInt();
            pdfData.originalSize = objectInputStream.readInt();
            pdfData.widthIsEmbedded = objectInputStream.readBoolean();
            pdfData.isColorExtracted = objectInputStream.readBoolean();
            pdfData.pointer = objectInputStream.readInt();
            pdfData.max = objectInputStream.readInt();
            pdfData.maxX = objectInputStream.readInt();
            pdfData.maxY = objectInputStream.readInt();
            pdfData.f_x1 = (float[])objectInputStream.readObject();
            pdfData.f_y1 = (float[])objectInputStream.readObject();
            pdfData.f_x2 = (float[])objectInputStream.readObject();
            pdfData.f_y2 = (float[])objectInputStream.readObject();
            pdfData.lx1 = (float[])objectInputStream.readObject();
            pdfData.ly1 = (float[])objectInputStream.readObject();
            pdfData.lx2 = (float[])objectInputStream.readObject();
            pdfData.ly2 = (float[])objectInputStream.readObject();
            pdfData.contents = (String[])objectInputStream.readObject();
            pdfData.rawData = (String[])objectInputStream.readObject();
            pdfData.unformattedContent = (String[])objectInputStream.readObject();
            pdfData.f_writingMode = (int[])objectInputStream.readObject();
            pdfData.f_font_used = (String[])objectInputStream.readObject();
            pdfData.colorTag = (String[])objectInputStream.readObject();
            pdfData.font_data = (String[])objectInputStream.readObject();
            pdfData.fragments = (String[])objectInputStream.readObject();
            pdfData.text_length = (int[])objectInputStream.readObject();
            pdfData.lineCount = (int[])objectInputStream.readObject();
            pdfData.move_command = (int[])objectInputStream.readObject();
            pdfData.f_character_spacing = (float[])objectInputStream.readObject();
            pdfData.parent = (int[])objectInputStream.readObject();
            pdfData.prefix = (String[])objectInputStream.readObject();
            pdfData.token_counter = (int[])objectInputStream.readObject();
            pdfData.links = (Object[])objectInputStream.readObject();
            pdfData.category = (String[])objectInputStream.readObject();
            pdfData.objectType = (int[])objectInputStream.readObject();
            pdfData.f_end_font_size = (int[])objectInputStream.readObject();
            pdfData.space_width = (float[])objectInputStream.readObject();
            pdfData.fontSize = (int[])objectInputStream.readObject();
            pdfData.regExpStatus = (int[])objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return pdfData;
    }

    public int getDisplacementForObject(int n) {
        int n2 = 0;
        int n3 = this.itemsOnEachPage.size();
        int n4 = 0;
        if (n >= this.itemsOnEachPage.elementAt(0)) {
            int n5;
            for (n5 = 0; n5 < n3 && n <= (n4 += this.itemsOnEachPage.elementAt(n5)); ++n5) {
            }
            n2 = this.displacementForEachPage.elementAt(n5);
        }
        return n2;
    }
}

