/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Type;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.Converter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=Converter.class, priority=999999.0)
public class CastingConverter
extends AbstractConverter<Object, Object> {
    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        return Types.isInstance(src, dest);
    }

    @Override
    public boolean canConvert(Class<?> src, Type dest) {
        return dest != null && Types.raws(dest).stream().allMatch(c -> c.isAssignableFrom(src));
    }

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return dest != null && dest.isAssignableFrom(src);
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        return Types.cast(src, dest);
    }

    @Override
    public Class<Object> getOutputType() {
        return Object.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }
}

