/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.log.LogListener;
import org.scijava.log.LogMessage;
import org.scijava.log.LogSource;

@IgnoreAsCallingClass
public interface Logger {
    default public void debug(Object msg) {
        this.log(4, msg);
    }

    default public void debug(Throwable t) {
        this.log(4, t);
    }

    default public void debug(Object msg, Throwable t) {
        this.log(4, msg, t);
    }

    default public void error(Object msg) {
        this.log(1, msg);
    }

    default public void error(Throwable t) {
        this.log(1, t);
    }

    default public void error(Object msg, Throwable t) {
        this.log(1, msg, t);
    }

    default public void info(Object msg) {
        this.log(3, msg);
    }

    default public void info(Throwable t) {
        this.log(3, t);
    }

    default public void info(Object msg, Throwable t) {
        this.log(3, msg, t);
    }

    default public void trace(Object msg) {
        this.log(5, msg);
    }

    default public void trace(Throwable t) {
        this.log(5, t);
    }

    default public void trace(Object msg, Throwable t) {
        this.log(5, msg, t);
    }

    default public void warn(Object msg) {
        this.log(2, msg);
    }

    default public void warn(Throwable t) {
        this.log(2, t);
    }

    default public void warn(Object msg, Throwable t) {
        this.log(2, msg, t);
    }

    default public boolean isDebug() {
        return this.isLevel(4);
    }

    default public boolean isError() {
        return this.isLevel(1);
    }

    default public boolean isInfo() {
        return this.isLevel(3);
    }

    default public boolean isTrace() {
        return this.isLevel(5);
    }

    default public boolean isWarn() {
        return this.isLevel(2);
    }

    default public boolean isLevel(int level) {
        return this.getLevel() >= level;
    }

    default public void log(int level, Object msg) {
        this.log(level, msg, null);
    }

    default public void log(int level, Throwable t) {
        this.log(level, null, t);
    }

    default public void log(int level, Object msg, Throwable t) {
        if (this.isLevel(level)) {
            this.alwaysLog(level, msg, t);
        }
    }

    public void alwaysLog(int var1, Object var2, Throwable var3);

    default public String getName() {
        return this.getSource().name();
    }

    public LogSource getSource();

    public int getLevel();

    default public Logger subLogger(String name) {
        return this.subLogger(name, this.getLevel());
    }

    public Logger subLogger(String var1, int var2);

    public void addLogListener(LogListener var1);

    public void removeLogListener(LogListener var1);

    public void notifyListeners(LogMessage var1);
}

