/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import org.scijava.display.Display;
import org.scijava.plugin.AbstractHandlerPlugin;
import org.scijava.ui.dnd.DragAndDropData;
import org.scijava.ui.dnd.DragAndDropHandler;

public abstract class AbstractDragAndDropHandler<D>
extends AbstractHandlerPlugin<D>
implements DragAndDropHandler<D> {
    @Override
    public boolean supports(D dataObject, Display<?> display) {
        return this.supportsDisplay(display) && this.supports(dataObject);
    }

    @Override
    public boolean supportsData(DragAndDropData data) {
        return data.isSupported(this.getType()) && this.supports(this.convertDataUnchecked(data));
    }

    @Override
    public boolean supportsData(DragAndDropData data, Display<?> display) {
        return this.supportsDisplay(display) && this.supportsData(data);
    }

    @Override
    public boolean supportsObject(Object object) {
        return object != null && this.getType().isAssignableFrom(object.getClass()) && this.supports(this.convertObjectUnchecked(object));
    }

    @Override
    public boolean supportsObject(Object object, Display<?> display) {
        return this.supportsDisplay(display) && this.supportsObject(object);
    }

    @Override
    public boolean supportsDisplay(Display<?> display) {
        return true;
    }

    @Override
    public D convertData(DragAndDropData data) {
        if (!this.supportsData(data)) {
            throw new IllegalArgumentException("Incompatible data object");
        }
        return this.convertDataUnchecked(data);
    }

    @Override
    public D convertObject(Object object) {
        if (!this.supportsObject(object)) {
            throw new IllegalArgumentException("Incompatible data object");
        }
        return this.convertObjectUnchecked(object);
    }

    @Override
    public boolean dropData(DragAndDropData data, Display<?> display) {
        return this.drop(this.convertData(data), display);
    }

    @Override
    public boolean dropObject(Object object, Display<?> display) {
        return this.drop(this.convertObject(object), display);
    }

    protected void check(D dataObject, Display<?> display) {
        if (!this.supports(dataObject)) {
            throw new IllegalArgumentException("Incompatible data object");
        }
        if (!this.supportsDisplay(display)) {
            throw new IllegalArgumentException("Incompatible display");
        }
        if (!this.supports(dataObject, display)) {
            throw new IllegalArgumentException("Data object and display are incompatible");
        }
    }

    protected D convertDataUnchecked(DragAndDropData data) {
        return (D)data.getData(this.getType());
    }

    protected D convertObjectUnchecked(Object object) {
        Object dataObject = object;
        return (D)dataObject;
    }
}

