/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.action;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.app.View;
import org.jhotdraw.app.action.AbstractViewAction;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.samples.svg.SVGView;
import org.jhotdraw.samples.svg.io.SVGOutputFormat;
import org.jhotdraw.util.ResourceBundleUtil;
import org.jhotdraw.util.prefs.PreferencesUtil;

public class ViewSourceAction
extends AbstractViewAction {
    public static final String ID = "view.viewSource";
    private static final String DIALOG_CLIENT_PROPERTY = "view.viewSource.dialog";

    public ViewSourceAction(Application app, @Nullable View view) {
        super(app, view);
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        labels.configureAction(this, ID);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextArea ta;
        JDialog dialog;
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        final SVGView v = (SVGView)this.getActiveView();
        Drawing drawing = v.getDrawing();
        if (v.getClientProperty(DIALOG_CLIENT_PROPERTY) == null) {
            dialog = new JDialog((Frame)SwingUtilities.getWindowAncestor(v.getComponent()));
            v.putClientProperty(DIALOG_CLIENT_PROPERTY, dialog);
            dialog.setTitle(labels.getFormatted("view.viewSource.titleText", v.getTitle()));
            dialog.setResizable(true);
            dialog.setDefaultCloseOperation(2);
            ta = new JTextArea();
            ta.setWrapStyleWord(true);
            ta.setLineWrap(true);
            JScrollPane sp = new JScrollPane(ta);
            dialog.getContentPane().add(sp);
            dialog.setSize(400, 400);
            dialog.setLocationByPlatform(true);
            this.updateSource(drawing, ta);
            final UndoableEditListener undoableEditHandler = new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent e) {
                    ViewSourceAction.this.updateSource(v.getDrawing(), ta);
                }
            };
            v.getDrawing().addUndoableEditListener(undoableEditHandler);
            final PropertyChangeListener propertyChangeHandler = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName() == "drawing") {
                        Drawing newDrawing;
                        Drawing oldDrawing = (Drawing)evt.getOldValue();
                        if (oldDrawing != null) {
                            oldDrawing.removeUndoableEditListener(undoableEditHandler);
                        }
                        if ((newDrawing = (Drawing)evt.getNewValue()) != null) {
                            newDrawing.addUndoableEditListener(undoableEditHandler);
                        }
                        if (newDrawing != null) {
                            ViewSourceAction.this.updateSource(newDrawing, ta);
                        }
                    } else if (evt.getPropertyName() == "title") {
                        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                        dialog.setTitle(labels.getFormatted("view.viewSource.titleText", v.getTitle()));
                    }
                }
            };
            v.addPropertyChangeListener(propertyChangeHandler);
            final Disposable disposable = new Disposable(){

                @Override
                public void dispose() {
                    if (v.getDrawing() != null) {
                        v.getDrawing().removeUndoableEditListener(undoableEditHandler);
                    }
                    v.removePropertyChangeListener(propertyChangeHandler);
                    ViewSourceAction.this.getApplication().removeWindow(dialog);
                    v.putClientProperty(ViewSourceAction.DIALOG_CLIENT_PROPERTY, null);
                    v.removeDisposable(this);
                }
            };
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent evt) {
                    disposable.dispose();
                }
            });
            v.addDisposable(disposable);
        } else {
            dialog = (JDialog)v.getClientProperty(DIALOG_CLIENT_PROPERTY);
            ta = (JTextArea)((JScrollPane)dialog.getContentPane().getComponent(0)).getViewport().getView();
            this.updateSource(drawing, ta);
        }
        Preferences prefs = PreferencesUtil.userNodeForPackage(this.getClass());
        PreferencesUtil.installFramePrefsHandler(prefs, "viewSource", dialog);
        this.getApplication().addWindow(dialog, v);
        dialog.setVisible(true);
    }

    private void updateSource(Drawing drawing, JTextArea textArea) {
        SVGOutputFormat format = new SVGOutputFormat();
        format.setPrettyPrint(true);
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try {
            format.write(buf, drawing);
            String source = buf.toString("UTF-8");
            textArea.setText(source);
        }
        catch (IOException ex) {
            textArea.setText(ex.toString());
        }
    }
}

