/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import ij.WindowManager;
import ij.macro.Interpreter;
import ij.text.TextWindow;
import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Properties;

public class AmiraTable
extends TextWindow {
    Properties properties = new Properties();
    private boolean show = true;

    public AmiraTable(String title, String headings, String data) {
        this(title, headings, data, false);
    }

    public AmiraTable(String title, String headings, String data, boolean initParameters) {
        super(title, headings, data, 500, 400);
        if (initParameters) {
            int rowCount = this.getTextPanel().getLineCount();
            String p = "Parameters { " + AmiraTable.getParameterString(rowCount, headings.split("\t")) + " }";
            AmiraParameters parameters = new AmiraParameters(p);
            parameters.setParameters(this.properties);
        }
        WindowManager.removeWindow((Frame)((Object)this));
    }

    public static String getParameterString(int rows, String[] headings) {
        String p = "\tContentType \"HxSpreadSheet\",\n";
        DecimalFormat format = new DecimalFormat("0000");
        for (int i = 0; i < headings.length; ++i) {
            p = p + "\t__ColumnName" + format.format(i) + "\"" + headings[i] + "\",\n";
        }
        p = p + "\tnumRows " + rows + ",\n";
        return p;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Hashtable getParameters() {
        return (Hashtable)this.properties.get("Parameters");
    }

    public String get(String key) {
        Hashtable p = this.getParameters();
        if (p == null) {
            return null;
        }
        return (String)p.get(key);
    }

    public void put(String key, String value) {
        Hashtable p = this.getParameters();
        if (p == null) {
            return;
        }
        p.put(key, value);
    }

    public void show() {
        if (!Interpreter.isBatchMode() && this.show) {
            super.show();
            WindowManager.removeWindow((Frame)((Object)this));
        }
    }
}

