/*
 * Decompiled with CFR 0.152.
 */
package vib;

import amira.AmiraParameters;
import ij.ImageListener;
import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Vector;

public class SegmentationViewerCanvas
extends ImageCanvas {
    static final int OUTLINE = 1;
    static final int FILL = 2;
    int mode = 2;
    int alpha = 128;
    protected ImagePlus labels;
    int w;
    int h;
    int d;
    Color[] label_colors = new Color[256];
    Vector[] contours;
    Vector[] colors;
    Vector[] indices;
    private final boolean debug = false;
    private int backBufferWidth;
    private int backBufferHeight;
    private Graphics backBufferGraphics;
    private Image backBufferImage;

    public SegmentationViewerCanvas(ImagePlus imp) {
        super(imp);
        this.w = imp.getWidth();
        this.h = imp.getHeight();
        this.d = imp.getStack().getSize();
        this.contours = new Vector[this.d];
        this.colors = new Vector[this.d];
        this.indices = new Vector[this.d];
        ImagePlus.addImageListener((ImageListener)new ImageListener(){

            public void imageOpened(ImagePlus imp) {
            }

            public void imageClosed(ImagePlus imp) {
            }

            public void imageUpdated(ImagePlus imp) {
                if (imp == SegmentationViewerCanvas.this.labels) {
                    SegmentationViewerCanvas.this.setLabels(SegmentationViewerCanvas.this.labels);
                }
            }
        });
    }

    public SegmentationViewerCanvas(ImagePlus imp, ImagePlus labels) {
        this(imp);
        this.setLabels(labels);
    }

    public ImagePlus getLabels() {
        return this.labels;
    }

    public void setLabels(ImagePlus labels) {
        this.labels = labels;
        this.contours = new Vector[this.d];
        this.colors = new Vector[this.d];
        this.indices = new Vector[this.d];
        if (labels == null) {
            return;
        }
        AmiraParameters parameters = new AmiraParameters(labels);
        int count = parameters.getMaterialCount();
        for (int i = 0; i < this.label_colors.length; ++i) {
            if (i >= count) {
                this.label_colors[i] = Color.RED;
                continue;
            }
            double[] c = parameters.getMaterialColor(i);
            int red = (int)(255.0 * c[0]);
            int green = (int)(255.0 * c[1]);
            int blue = (int)(255.0 * c[2]);
            this.label_colors[i] = new Color(red, green, blue);
        }
        if (this.backBufferGraphics != null) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSlice(int slice) {
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.colors[slice - 1] = null;
            this.contours[slice - 1] = null;
            this.indices[slice - 1] = null;
            this.createContoursIfNotExist(slice);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralPath getOutline(int slice, int materialId) {
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.createContoursIfNotExist(slice);
            for (int i = 0; i < this.indices[slice - 1].size(); ++i) {
                if ((Integer)this.indices[slice - 1].get(i) != materialId) continue;
                return (GeneralPath)this.contours[slice - 1].get(i);
            }
            return null;
        }
    }

    public void createContoursIfNotExist(int slice) {
        if (this.labels == null || this.contours[slice - 1] != null) {
            return;
        }
        ContourFinder finder = new ContourFinder(slice - 1);
        finder.initContours();
    }

    private void resetBackBuffer() {
        if (this.backBufferGraphics != null) {
            this.backBufferGraphics.dispose();
            this.backBufferGraphics = null;
        }
        if (this.backBufferImage != null) {
            this.backBufferImage.flush();
            this.backBufferImage = null;
        }
        this.backBufferWidth = this.getSize().width;
        this.backBufferHeight = this.getSize().height;
        this.backBufferImage = this.createImage(this.backBufferWidth, this.backBufferHeight);
        this.backBufferGraphics = this.backBufferImage.getGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.backBufferWidth != this.getSize().width || this.backBufferHeight != this.getSize().height || this.backBufferImage == null || this.backBufferGraphics == null) {
            this.resetBackBuffer();
        }
        int slice = this.imp.getCurrentSlice();
        SegmentationViewerCanvas segmentationViewerCanvas = this;
        synchronized (segmentationViewerCanvas) {
            this.createContoursIfNotExist(slice);
            super.paint(this.backBufferGraphics);
            this.drawOverlay(this.backBufferGraphics, slice);
        }
        g.drawImage(this.backBufferImage, 0, 0, (ImageObserver)((Object)this));
    }

    void drawOverlay(Graphics g, int slice) {
        if (this.labels == null) {
            return;
        }
        double magnification = this.getMagnification();
        for (int i = 0; i < this.contours[slice - 1].size(); ++i) {
            g.setColor((Color)this.colors[slice - 1].get(i));
            Shape poly = (Shape)this.contours[slice - 1].get(i);
            if (magnification != 1.0) {
                AffineTransform trans = ((Graphics2D)g).getDeviceConfiguration().getDefaultTransform();
                trans.setTransform(magnification, 0.0, 0.0, magnification, (double)(-this.srcRect.x) * magnification, (double)(-this.srcRect.y) * magnification);
                poly = trans.createTransformedShape(poly);
            }
            ((Graphics2D)g).draw(poly);
            if (this.mode != 2) continue;
            Color c = (Color)this.colors[slice - 1].get(i);
            Color c1 = new Color(c.getRed(), c.getGreen(), c.getBlue(), this.alpha);
            g.setColor(c1);
            ((Graphics2D)g).fill(poly);
        }
    }

    class ContourFinder {
        int slice;
        byte[] pixels;
        GeneralPath[] paths;
        Outline[] outline;

        public ContourFinder(int slice) {
            this.slice = slice;
            this.pixels = (byte[])SegmentationViewerCanvas.this.labels.getStack().getProcessor(slice + 1).getPixels();
            this.paths = new GeneralPath[255];
        }

        final byte get(int x, int y) {
            return this.pixels[y * SegmentationViewerCanvas.this.w + x];
        }

        public void initContours() {
            SegmentationViewerCanvas.this.contours[this.slice] = new Vector();
            SegmentationViewerCanvas.this.colors[this.slice] = new Vector();
            SegmentationViewerCanvas.this.indices[this.slice] = new Vector();
            ArrayList polygons = new ArrayList();
            this.outline = new Outline[2 * SegmentationViewerCanvas.this.w + 2];
            for (int y = 0; y <= SegmentationViewerCanvas.this.h; ++y) {
                for (int x = 0; x < SegmentationViewerCanvas.this.w; ++x) {
                    this.handle(x, y);
                }
            }
            for (int i = 1; i < this.paths.length; ++i) {
                if (this.paths[i] == null) continue;
                SegmentationViewerCanvas.this.contours[this.slice].add(this.paths[i]);
                SegmentationViewerCanvas.this.colors[this.slice].add(SegmentationViewerCanvas.this.label_colors[i]);
                SegmentationViewerCanvas.this.indices[this.slice].add(new Integer(i));
            }
        }

        private final Outline newOutline(int left, int right, int x1, int x2, int y) {
            this.outline[left] = this.outline[right] = new Outline();
            this.outline[left].push(x1, y);
            this.outline[left].push(x2, y);
            return this.outline[left];
        }

        private final Outline mergeOutlines(Outline left, Outline right) {
            left.push(right);
            for (int k = 0; k < this.outline.length; ++k) {
                if (this.outline[k] != right) continue;
                this.outline[k] = left;
                return this.outline[k];
            }
            throw new RuntimeException("assertion failed!");
        }

        private final Outline moveOutline(int from, int to) {
            this.outline[to] = this.outline[from];
            this.outline[from] = null;
            return this.outline[to];
        }

        private void closeOutline(byte material, Outline outline) {
            int m = material & 0xFF;
            if (material == -1) {
                m = 0;
            }
            if (this.paths[m] == null) {
                this.paths[m] = new GeneralPath(0);
            }
            this.paths[m].append(outline.getPolygon(), false);
        }

        private void handle(int x, int y) {
            int r;
            int l;
            byte m = y < SegmentationViewerCanvas.this.h ? this.get(x, y) : (byte)0;
            byte mPrev = y > 0 ? this.get(x, y - 1) : (byte)0;
            byte mLeft = x > 0 && y < SegmentationViewerCanvas.this.h ? this.get(x - 1, y) : (byte)0;
            byte mRight = x < SegmentationViewerCanvas.this.w - 1 && y < SegmentationViewerCanvas.this.h ? this.get(x + 1, y) : (byte)0;
            byte mPrevLeft = x > 0 && y > 0 ? this.get(x - 1, y - 1) : (byte)0;
            byte mPrevRight = x < SegmentationViewerCanvas.this.w - 1 && y > 0 ? this.get(x + 1, y - 1) : (byte)0;
            Outline left1 = this.outline[2 * x];
            Outline left2 = this.outline[2 * x + 1];
            Outline right2 = this.outline[2 * x + 2];
            Outline right1 = this.outline[2 * x + 3];
            this.outline[2 * x + 3] = null;
            this.outline[2 * x] = null;
            this.outline[2 * x + 2] = null;
            this.outline[2 * x + 1] = null;
            if (mPrev != 0 && mPrev != m) {
                l = 2 * x;
                r = 2 * x + 3;
                if (left2 == null && right2 == null) {
                    this.newOutline(l, r, x, x + 1, y);
                } else if (left2 == null) {
                    this.outline[l] = right2.shift(x, y);
                } else if (right2 == null) {
                    this.outline[r] = left2.push(x + 1, y);
                } else if (left2 == right2) {
                    this.closeOutline(mPrev, left2);
                } else {
                    this.mergeOutlines(left2, right2);
                }
                right2 = null;
                left2 = null;
            }
            if (m != 0 && mPrev != m) {
                l = 2 * x + 1;
                r = 2 * x + 2;
                if (left1 != null && mLeft != m) {
                    this.outline[2 * x] = left1;
                    left1 = null;
                }
                if (right1 != null && (mRight != m || mPrevRight != m)) {
                    this.outline[2 * x + 3] = right1;
                    right1 = null;
                }
                if (left1 == null && right1 == null) {
                    this.newOutline(l, r, x + 1, x, y);
                } else if (left1 == null) {
                    this.outline[l] = right1.push(x, y);
                } else if (right1 == null) {
                    this.outline[r] = left1.shift(x + 1, y);
                } else if (left1 == right1) {
                    this.closeOutline(m, left1);
                } else {
                    this.mergeOutlines(right1, left1);
                }
                right1 = null;
                left1 = null;
            }
            if (left1 != null) {
                this.outline[2 * x] = left1;
            }
            if (left2 != null) {
                this.outline[2 * x + 1] = left2;
            }
            if (right1 != null) {
                this.outline[2 * x + 3] = right1;
            }
            if (right2 != null) {
                this.outline[2 * x + 2] = right2;
            }
            if (m != 0 && mLeft != m) {
                l = 2 * x + 1;
                if (this.outline[l] == null) {
                    this.outline[l] = left2;
                }
                this.outline[l].push(x, y + 1);
            }
            if (mLeft != 0 && mLeft != m) {
                l = 2 * x + 0;
                if (this.outline[l] == null) {
                    this.outline[l] = left1;
                }
                this.outline[l].shift(x, y + 1);
            }
        }
    }

    static class Outline {
        int[] x = new int[this.reserved];
        int[] y = new int[this.reserved];
        int first = 5;
        int last = 5;
        int reserved = 10;
        final int GROW = 10;

        private void needs(int newCount, int offset) {
            if (newCount > this.reserved || offset > this.first) {
                if (newCount < this.reserved + 10 + 1) {
                    newCount = this.reserved + 10 + 1;
                }
                int[] newX = new int[newCount];
                int[] newY = new int[newCount];
                System.arraycopy(this.x, 0, newX, offset, this.last);
                System.arraycopy(this.y, 0, newY, offset, this.last);
                this.x = newX;
                this.y = newY;
                this.first += offset;
                this.last += offset;
                this.reserved = newCount;
            }
        }

        public Outline push(int x, int y) {
            this.needs(this.last + 1, 0);
            this.x[this.last] = x;
            this.y[this.last] = y;
            ++this.last;
            return this;
        }

        public Outline shift(int x, int y) {
            this.needs(this.last + 1, 10);
            --this.first;
            this.x[this.first] = x;
            this.y[this.first] = y;
            return this;
        }

        public Outline push(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count, 0);
            System.arraycopy(o.x, o.first, this.x, this.last, count);
            System.arraycopy(o.y, o.first, this.y, this.last, count);
            this.last += count;
            return this;
        }

        public Outline shift(Outline o) {
            int count = o.last - o.first;
            this.needs(this.last + count + 10, count + 10);
            this.first -= count;
            System.arraycopy(o.x, o.first, this.x, this.first, count);
            System.arraycopy(o.y, o.first, this.y, this.first, count);
            return this;
        }

        public Polygon getPolygon() {
            int count = this.last - this.first;
            int[] x1 = new int[count];
            int[] y1 = new int[count];
            System.arraycopy(this.x, this.first, x1, 0, count);
            System.arraycopy(this.y, this.first, y1, 0, count);
            return new Polygon(x1, y1, count);
        }

        public String toString() {
            String res = "(first:" + this.first + ",last:" + this.last + ",reserved:" + this.reserved + ":";
            if (this.last > this.x.length) {
                System.err.println("ERROR!");
            }
            for (int i = this.first; i < this.last && i < this.x.length; ++i) {
                res = res + "(" + this.x[i] + "," + this.y[i] + ")";
            }
            return res + ")";
        }
    }
}

