/*
 * Decompiled with CFR 0.152.
 */
package vib.app.module;

import ij.ImagePlus;
import ij.io.FileInfo;
import ij.measure.Calibration;
import ij.plugin.filter.RGBStackSplitter;
import ij.process.StackConverter;
import java.io.File;
import util.BatchOpener;
import vib.app.module.Module;
import vib.app.module.State;

public class SplitChannels
extends Module {
    @Override
    public String getName() {
        return "SplitChannels";
    }

    @Override
    protected String getMessage() {
        return "Splitting channels";
    }

    @Override
    protected void run(State state, int index) {
        this.prereqsDone(state, index);
        int numChannels = state.options.numChannels;
        if (numChannels < 2) {
            return;
        }
        int refChannel = state.options.refChannel - 1;
        File file = index < 0 ? new File(state.options.templatePath) : (File)state.options.fileGroup.get(index);
        String path = file.getAbsolutePath();
        boolean upToDate = true;
        for (int i = 0; i < numChannels; ++i) {
            if (State.upToDate(path, state.getImagePath(i, index))) continue;
            upToDate = false;
        }
        if (upToDate) {
            return;
        }
        ImagePlus[] allChannels = BatchOpener.open(path);
        if (allChannels.length == 1 && allChannels[0].getType() == 4) {
            allChannels = this.splitRGBStack(allChannels[0]);
        }
        for (int i = 0; i < allChannels.length; ++i) {
            new StackConverter(allChannels[i]).convertToGray8();
        }
        int channelsInFile = allChannels.length;
        if (channelsInFile < numChannels) {
            if (index < 0 && channelsInFile == 1) {
                path = state.getImagePath(refChannel, index);
                if (!state.save(allChannels[0], path)) {
                    throw new RuntimeException("Could not save " + path);
                }
                return;
            }
            throw new RuntimeException("Found unexpectedly " + channelsInFile + " channels  in " + path);
        }
        for (int i = 0; i < numChannels; ++i) {
            if (i == refChannel) continue;
            ImagePlus img = allChannels[i];
            path = state.getImagePath(i, index);
            if (!state.save(img, path)) {
                throw new RuntimeException("Could not save " + path);
            }
            new File(path).setLastModified(file.lastModified());
        }
        path = state.getImagePath(refChannel, index);
        if (!state.save(allChannels[refChannel], path)) {
            throw new RuntimeException("Could not save " + path);
        }
        new File(path).setLastModified(file.lastModified());
    }

    private ImagePlus[] splitRGBStack(ImagePlus rgb) {
        Calibration cal = rgb.getCalibration();
        FileInfo fi = rgb.getOriginalFileInfo();
        RGBStackSplitter splitter = new RGBStackSplitter();
        splitter.split(rgb.getStack(), false);
        rgb.close();
        ImagePlus[] ret = new ImagePlus[3];
        ret[0] = new ImagePlus(rgb.getTitle(), splitter.red);
        ret[0].setCalibration(cal);
        ret[0].setFileInfo(fi);
        ret[1] = new ImagePlus(rgb.getTitle(), splitter.green);
        ret[1].setCalibration(cal);
        ret[1].setFileInfo(fi);
        ret[2] = new ImagePlus(rgb.getTitle(), splitter.blue);
        ret[2].setCalibration(cal);
        ret[2].setFileInfo(fi);
        return ret;
    }
}

