/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.transform;

import mpicbg.trakem2.transform.InvertibleCoordinateTransform;

public class AffineModel2D
extends mpicbg.models.AffineModel2D
implements InvertibleCoordinateTransform {
    private static final long serialVersionUID = 7177056267150312600L;

    @Override
    public final void init(String data) {
        String[] fields = data.split("\\s+");
        if (fields.length != 6) {
            throw new NumberFormatException("Inappropriate parameters for " + this.getClass().getCanonicalName());
        }
        double m00 = Double.parseDouble(fields[0]);
        double m10 = Double.parseDouble(fields[1]);
        double m01 = Double.parseDouble(fields[2]);
        double m11 = Double.parseDouble(fields[3]);
        double m02 = Double.parseDouble(fields[4]);
        double m12 = Double.parseDouble(fields[5]);
        this.set(m00, m10, m01, m11, m02, m12);
    }

    @Override
    public final String toXML(String indent) {
        StringBuilder xml = new StringBuilder(128);
        xml.append(indent).append("<iict_transform class=\"").append(this.getClass().getCanonicalName()).append("\" data=\"");
        this.toDataString(xml);
        return xml.append("\" />").toString();
    }

    @Override
    public final String toDataString() {
        StringBuilder data = new StringBuilder();
        this.toDataString(data);
        return data.toString();
    }

    private final void toDataString(StringBuilder data) {
        data.append(this.m00).append(' ').append(this.m10).append(' ').append(this.m01).append(' ').append(this.m11).append(' ').append(this.m02).append(' ').append(this.m12);
    }

    @Override
    public AffineModel2D copy() {
        AffineModel2D m = new AffineModel2D();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    public AffineModel2D createInverse() {
        AffineModel2D ict = new AffineModel2D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.cost = this.cost;
        return ict;
    }
}

