/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferBench {
    public static void main(String[] args) {
        BufferBench.testOutOfMemory();
    }

    public static void testOutOfMemory() {
        int capacity = 100000000;
        int nbuf = 100;
        byte data = 31;
        for (int ibuf = 0; ibuf < nbuf; ++ibuf) {
            ByteBuffer bb = BufferBench.newByteBuffer(capacity);
            bb.put(capacity / 2, data);
            bb.put(capacity - 1, data);
        }
    }

    private static ByteBuffer newByteBuffer(int capacity) {
        ByteBuffer bb = null;
        try {
            System.out.println("allocating " + capacity + " bytes");
            bb = ByteBuffer.allocateDirect(capacity).order(ByteOrder.nativeOrder());
        }
        catch (OutOfMemoryError e1) {
            System.gc();
            System.out.println("attempted gc after exception: " + e1);
            System.out.println("now attempting to allocate again");
            try {
                bb = ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError e2) {
                System.out.println("failed allocate after gc" + e2.getMessage());
            }
        }
        return bb;
    }
}

