/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bigwarp.BigWarpData;
import bigwarp.source.GridRealRandomAccessibleRealInterval;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class GridSource<T extends RealType<T>>
implements Source<T> {
    protected final String name;
    protected BigWarpData<?> sourceData;
    protected AffineTransform3D sourceTransform;
    protected final Interval interval;
    protected final GridRealRandomAccessibleRealInterval<T> gridImg;
    protected T type;

    public GridSource(String name, BigWarpData<?> data, T t, RealTransform warp) {
        this(name, t, GridSource.getInterval(data), GridSource.getSourceTransform(data), warp);
    }

    public GridSource(String name, T t, Interval interval, AffineTransform3D sourceTransform, RealTransform warp) {
        this.name = name;
        this.type = (RealType)t.copy();
        this.interval = interval;
        this.sourceTransform = new AffineTransform3D();
        this.gridImg = new GridRealRandomAccessibleRealInterval<T>(interval, t, warp);
    }

    private static AffineTransform3D getSourceTransform(BigWarpData<?> data) {
        AffineTransform3D sourceTransform = new AffineTransform3D();
        data.sources.get(0).getSpimSource().getSourceTransform(0, 0, sourceTransform);
        return sourceTransform;
    }

    private static Interval getInterval(BigWarpData<?> data) {
        BoundingBoxEstimation bbe = new BoundingBoxEstimation();
        AffineTransform3D affine = new AffineTransform3D();
        data.getTargetSource(0).getSpimSource().getSourceTransform(0, 0, affine);
        return bbe.estimatePixelInterval((RealTransform)affine, (Interval)data.getTargetSource(0).getSpimSource().getSource(0, 0));
    }

    public void setGridSpacing(double spacing) {
        this.gridImg.ra.setGridSpacing(spacing);
    }

    public void setGridWidth(double width) {
        this.gridImg.ra.setGridWidth(width);
    }

    public void setWarp(RealTransform warp) {
        this.gridImg.ra.warp = warp;
    }

    public boolean isPresent(int t) {
        return t == 0;
    }

    public void setMethod(GRID_TYPE method) {
        this.gridImg.ra.setMethod(method);
    }

    public RandomAccessibleInterval<T> getSource(int t, int level) {
        return Views.interval((RandomAccessible)Views.raster(this.getInterpolatedSource(t, level, Interpolation.NEARESTNEIGHBOR)), (Interval)this.interval);
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return this.gridImg;
    }

    public void getSourceTransform(int t, int level, AffineTransform3D transform) {
        transform.set(this.sourceTransform);
    }

    public T getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.sourceData.getTargetSource(0).getSpimSource().getVoxelDimensions();
    }

    public int getNumMipmapLevels() {
        return 1;
    }

    public static enum GRID_TYPE {
        MOD,
        LINE;

    }
}

