/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.io;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.OpenDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import sc.fiji.io.GifDecoder;

public class Animated_Gif_Reader
implements PlugIn {
    public void run(String arg) {
        String name;
        if (arg == null || arg.equals("")) {
            OpenDialog od = new OpenDialog("Animated Gif Reader", null);
            name = od.getFileName();
            if (name == null) {
                return;
            }
            arg = od.getDirectory() + name;
        } else {
            name = arg.substring(arg.lastIndexOf(47) + 1);
        }
        GifDecoder d = new GifDecoder();
        int status = d.read(arg);
        int n = d.getFrameCount();
        if (n == 0) {
            IJ.error((String)("It appears that " + arg + " does not contain any frames"));
            return;
        }
        ImageStack stack = null;
        for (int i = 0; i < n; ++i) {
            ImageProcessor frame = d.getFrame(i);
            if (i == 0) {
                stack = new ImageStack(frame.getWidth(), frame.getHeight());
            }
            int t = d.getDelay(i);
            stack.addSlice(null, frame);
        }
        if (stack != null) {
            new ImagePlus(name, stack).show();
        }
    }
}

