/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilterRunner;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.AWTEvent;
import mpicbg.ij.plugin.AbstractBlockFilter;

public class NormalizeLocalContrast
extends AbstractBlockFilter {
    protected static double standardDeviations = 3.0;
    protected double stds;
    protected static boolean center = true;
    protected boolean cent = true;
    protected static boolean stretch = true;
    protected boolean stret = true;
    protected mpicbg.ij.integral.NormalizeLocalContrast[] nlcs;

    @Override
    protected String dialogTitle() {
        return "Normalize Local Contrast";
    }

    @Override
    protected void init(ImagePlus imp) {
        super.init(imp);
        this.nlcs = imp.getType() == 4 ? new mpicbg.ij.integral.NormalizeLocalContrast[]{new mpicbg.ij.integral.NormalizeLocalContrast(this.fps[0]), new mpicbg.ij.integral.NormalizeLocalContrast(this.fps[1]), new mpicbg.ij.integral.NormalizeLocalContrast(this.fps[2])} : new mpicbg.ij.integral.NormalizeLocalContrast[]{new mpicbg.ij.integral.NormalizeLocalContrast(this.fps[0])};
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        GenericDialog gd = new GenericDialog(this.dialogTitle());
        gd.addNumericField("Block_radius_x : ", (double)blockRadiusX, 0, 6, "pixels");
        gd.addNumericField("Block_radius_y : ", (double)blockRadiusY, 0, 6, "pixels");
        gd.addNumericField("Standard_deviations : ", standardDeviations, 2);
        gd.addCheckbox("center", center);
        gd.addCheckbox("stretch", stretch);
        gd.addPreviewCheckbox(pfr);
        gd.addDialogListener((DialogListener)this);
        this.init(imp);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return 4096;
        }
        IJ.register(this.getClass());
        return IJ.setupDialog((ImagePlus)imp, (int)29);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        blockRadiusX = (int)gd.getNextNumber();
        blockRadiusY = (int)gd.getNextNumber();
        standardDeviations = gd.getNextNumber();
        center = gd.getNextBoolean();
        stretch = gd.getNextBoolean();
        return !gd.invalidNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyParameters() {
        NormalizeLocalContrast normalizeLocalContrast = this;
        synchronized (normalizeLocalContrast) {
            this.brx = blockRadiusX;
            this.bry = blockRadiusY;
            this.stds = standardDeviations;
            this.cent = center;
            this.stret = stretch;
        }
    }

    @Override
    protected void process(int i) {
        this.nlcs[i].run(this.brx, this.bry, (float)this.stds, this.cent, this.stret);
    }

    public static void run(ImageProcessor ip, int brx, int bry, float stds, boolean cent, boolean stret) {
        NormalizeLocalContrast nlc = new NormalizeLocalContrast();
        nlc.init(new ImagePlus("", ip));
        for (int i = 0; i < nlc.nlcs.length; ++i) {
            nlc.nlcs[i].run(brx, bry, stds, cent, stret);
        }
        if (FloatProcessor.class.isInstance(ip)) {
            return;
        }
        if (ColorProcessor.class.isInstance(ip)) {
            int[] rgbs = (int[])ip.getPixels();
            nlc.toRGB(rgbs);
        } else if (ByteProcessor.class.isInstance(ip)) {
            byte[] bytes = (byte[])ip.getPixels();
            nlc.toByte(bytes);
        } else if (ShortProcessor.class.isInstance(ip)) {
            short[] shorts = (short[])ip.getPixels();
            nlc.toShort(shorts);
        }
    }
}

