/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class RemoveSaturated
implements PlugIn {
    public static void run(ImageProcessor ip, float v) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        int wh = w * h;
        ImageProcessor ipTarget = ip.duplicate();
        int numSaturatedPixels = 0;
        do {
            numSaturatedPixels = 0;
            for (int i = 0; i < wh; ++i) {
                float r;
                float l;
                if (ip.getf(i) != v) continue;
                ++numSaturatedPixels;
                int y = i / w;
                int x = i % w;
                float s = 0.0f;
                float n = 0.0f;
                if (y > 0) {
                    float tr;
                    float t;
                    float tl;
                    if (x > 0 && (tl = ip.getf(x - 1, y - 1)) != v) {
                        s += 0.5f * tl;
                        n += 0.5f;
                    }
                    if ((t = ip.getf(x, y - 1)) != v) {
                        s += t;
                        n += 1.0f;
                    }
                    if (x < w - 1 && (tr = ip.getf(x + 1, y - 1)) != v) {
                        s += 0.5f * tr;
                        n += 0.5f;
                    }
                }
                if (x > 0 && (l = ip.getf(x - 1, y)) != v) {
                    s += l;
                    n += 1.0f;
                }
                if (x < w - 1 && (r = ip.getf(x + 1, y)) != v) {
                    s += r;
                    n += 1.0f;
                }
                if (y < h - 1) {
                    float br;
                    float b;
                    float bl;
                    if (x > 0 && (bl = ip.getf(x - 1, y + 1)) != v) {
                        s += 0.5f * bl;
                        n += 0.5f;
                    }
                    if ((b = ip.getf(x, y + 1)) != v) {
                        s += b;
                        n += 1.0f;
                    }
                    if (x < w - 1 && (br = ip.getf(x + 1, y + 1)) != v) {
                        s += 0.5f * br;
                        n += 0.5f;
                    }
                }
                if (!(n > 0.0f)) continue;
                ipTarget.setf(i, s / n);
            }
            ip.setPixels(ipTarget.getPixelsCopy());
        } while (numSaturatedPixels > 0);
    }

    public void run(String arg) {
        ImagePlus imp = IJ.getImage();
        RemoveSaturated.run(IJ.getImage().getProcessor(), 0.0f);
        imp.updateAndDraw();
    }
}

