/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.CTCExporter;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import java.awt.Frame;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import org.scijava.plugin.Plugin;

public class CTCExporterAction
extends AbstractTMAction {
    public static final String NAME = "Export to CTC format";
    public static final String KEY = "CTC_EXPORTER";
    public static final String INFO_TEXT = "<html>Export the current TrackMate session to the Cell-Tracking-Challenge file format.<p>See the <a url=\"http://celltrackingchallenge.net/\">challenge webpage</a> for details: http://celltrackingchallenge.net</html>";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        GenericDialog dialog = new GenericDialog("CTC exporter", parent);
        ImagePlus imp = trackmate.getSettings().imp;
        String defaultPath = imp == null || imp.getOriginalFileInfo() == null ? System.getProperty("user.home") : imp.getOriginalFileInfo().directory;
        dialog.addDirectoryField("Export to", defaultPath);
        String[] valuesStr = Arrays.stream(CTCExporter.ExportType.values()).map(CTCExporter.ExportType::toString).collect(Collectors.toList()).toArray(new String[0]);
        dialog.addChoice("Data is", valuesStr, CTCExporter.ExportType.RESULTS.toString());
        dialog.showDialog();
        if (dialog.wasCanceled()) {
            return;
        }
        String exportRootFolder = dialog.getNextString();
        int choiceIndex = dialog.getNextChoiceIndex();
        try {
            CTCExporter.exportAll(exportRootFolder, trackmate, CTCExporter.ExportType.values()[choiceIndex], this.logger);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
    }

    @Plugin(type=TrackMateActionFactory.class)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return CTCExporterAction.INFO_TEXT;
        }

        @Override
        public String getKey() {
            return CTCExporterAction.KEY;
        }

        @Override
        public TrackMateAction create() {
            return new CTCExporterAction();
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.ISBI_ICON;
        }

        @Override
        public String getName() {
            return CTCExporterAction.NAME;
        }

        @Override
        public String getUrl() {
            return "https://imagej.net/plugins/trackmate/actions/trackmate-ctc-exporter";
        }
    }
}

