/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.FeatureFilter;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.components.FilterPanel;
import fiji.plugin.trackmate.util.OnRequestUpdater;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class InitFilterPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String EXPLANATION_TEXT = "<html><p align=\"justify\">Set here a threshold on the quality feature to restrict the number of spots before calculating other features and rendering. This step can help save time in the case of a very large number of spots. <br/> Warning: the spot filtered here will be discarded: they will not be saved and cannot be retrieved by any other means than re-doing the detection step.</html>";
    private static final String SELECTED_SPOT_STRING = "Selected spots: %d out of %d";
    private final OnRequestUpdater updater;
    private final Function<String, double[]> valueCollector;
    private final FilterPanel filterPanel;
    private final JLabel lblSelectedSpots;
    private double[] values;

    public InitFilterPanel(FeatureFilter filter, Function<String, double[]> valueCollector) {
        this.valueCollector = valueCollector;
        this.updater = new OnRequestUpdater(() -> this.thresholdChanged());
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.setPreferredSize(new Dimension(300, 500));
        JPanel panelFields = new JPanel();
        this.add((Component)panelFields, "South");
        panelFields.setPreferredSize(new Dimension(300, 100));
        panelFields.setLayout(null);
        this.lblSelectedSpots = new JLabel("Please wait...");
        panelFields.add(this.lblSelectedSpots);
        this.lblSelectedSpots.setBounds(12, 12, 276, 15);
        this.lblSelectedSpots.setFont(Fonts.FONT);
        JPanel panelText = new JPanel();
        this.add((Component)panelText, "North");
        panelText.setPreferredSize(new Dimension(300, 200));
        SpringLayout slPanelText = new SpringLayout();
        panelText.setLayout(slPanelText);
        JLabel lblInitialThreshold = new JLabel();
        slPanelText.putConstraint("North", (Component)lblInitialThreshold, 12, "North", (Component)panelText);
        slPanelText.putConstraint("West", (Component)lblInitialThreshold, 12, "West", (Component)panelText);
        slPanelText.putConstraint("South", (Component)lblInitialThreshold, 27, "North", (Component)panelText);
        slPanelText.putConstraint("East", (Component)lblInitialThreshold, -12, "East", (Component)panelText);
        panelText.add(lblInitialThreshold);
        lblInitialThreshold.setText("Initial thresholding");
        lblInitialThreshold.setFont(Fonts.BIG_FONT);
        JLabel lblExplanation = new JLabel();
        slPanelText.putConstraint("North", (Component)lblExplanation, 39, "North", (Component)panelText);
        slPanelText.putConstraint("West", (Component)lblExplanation, 12, "West", (Component)panelText);
        slPanelText.putConstraint("South", (Component)lblExplanation, -39, "South", (Component)panelText);
        slPanelText.putConstraint("East", (Component)lblExplanation, -12, "East", (Component)panelText);
        panelText.add(lblExplanation);
        lblExplanation.setText(EXPLANATION_TEXT);
        lblExplanation.setFont(Fonts.FONT.deriveFont(2));
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add("QUALITY");
        HashMap<String, String> keyNames = new HashMap<String, String>(1);
        keyNames.put("QUALITY", Spot.FEATURE_NAMES.get("QUALITY"));
        this.filterPanel = new FilterPanel(keyNames, valueCollector, filter);
        this.filterPanel.cmbboxFeatureKeys.setEnabled(false);
        this.filterPanel.rdbtnAbove.setEnabled(false);
        this.filterPanel.rdbtnBelow.setEnabled(false);
        this.add((Component)this.filterPanel, "Center");
        this.filterPanel.setPreferredSize(new Dimension(300, 200));
        this.filterPanel.addChangeListener(e -> this.updater.doUpdate());
        this.refresh();
    }

    public void refresh() {
        this.values = this.valueCollector.apply("QUALITY");
        this.filterPanel.refresh();
        this.updater.doUpdate();
    }

    public FeatureFilter getFeatureThreshold() {
        return this.filterPanel.getFilter();
    }

    private void thresholdChanged() {
        FeatureFilter filter = this.filterPanel.getFilter();
        double threshold = filter.value;
        boolean isAbove = filter.isAbove;
        if (null == this.values) {
            return;
        }
        int nspots = this.values.length;
        int nselected = 0;
        if (isAbove) {
            for (double val : this.values) {
                if (!(val > threshold)) continue;
                ++nselected;
            }
        } else {
            for (double val : this.values) {
                if (!(val < threshold)) continue;
                ++nselected;
            }
        }
        this.lblSelectedSpots.setText(String.format(SELECTED_SPOT_STRING, nselected, nspots));
    }
}

