/*
 * Decompiled with CFR 0.152.
 */
package FlowJ;

import FlowJ.FlowJDisplay;
import ij.IJ;
import ij.ImageStack;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import volume.VolumeFloat;

public class FlowJFlow {
    public VolumeFloat v;
    public boolean[][] full;
    private float[] avg = new float[2];
    private Calibration c;

    public FlowJFlow() {
    }

    public FlowJFlow(int width, int height) {
        this.v = new VolumeFloat(2, width, height, 1.0, 1.0, 1.0);
        this.full = new boolean[height][width];
    }

    public ImageStack toStack() {
        int x;
        int offset;
        int y;
        ImageStack is = new ImageStack(this.getWidth(), this.getHeight());
        FloatProcessor fp = new FloatProcessor(this.getWidth(), this.getHeight());
        float[] im = (float[])fp.getPixels();
        for (y = 0; y < this.getHeight(); ++y) {
            offset = y * this.getWidth();
            for (x = 0; x < this.getWidth(); ++x) {
                im[offset + x] = this.v.v[y][x][0];
            }
        }
        is.addSlice("x", (ImageProcessor)fp);
        fp = new FloatProcessor(this.getWidth(), this.getHeight());
        im = (float[])fp.getPixels();
        for (y = 0; y < this.getHeight(); ++y) {
            offset = y * this.getWidth();
            for (x = 0; x < this.getWidth(); ++x) {
                im[offset + x] = this.v.v[y][x][1];
            }
        }
        is.addSlice("y", (ImageProcessor)fp);
        return is;
    }

    public void setCalibration(Calibration c) {
        this.c = c;
    }

    public boolean valid(int x, int y) {
        return this.v.valid(x, y);
    }

    public void set(int x, int y, float vx, float vy) {
        this.set(x, y, vx, vy, true);
    }

    public void set(int x, int y, float vx, float vy, boolean fullFlow) {
        this.v.v[y][x][0] = vx;
        this.v.v[y][x][1] = vy;
        this.full[y][x] = fullFlow;
    }

    public float[] get(int x, int y) {
        float[] vv = new float[]{this.v.v[y][x][0], this.v.v[y][x][1]};
        return vv;
    }

    public int getWidth() {
        return this.v.getHeight();
    }

    public int getHeight() {
        return this.v.getDepth();
    }

    public float getX(int x, int y) {
        return this.v.v[y][x][0];
    }

    public float getY(int x, int y) {
        return this.v.v[y][x][1];
    }

    public boolean full(int x, int y) {
        return this.full[y][x];
    }

    public String getTitle(int mappingChoice, float scale, float rho) {
        return FlowJDisplay.toString(mappingChoice, scale, rho);
    }

    public ImageProcessor mapImage(ImageProcessor background, int mappingChoice, int axis, float scale, float rho) {
        return FlowJDisplay.mapImage(this.v.v, this.full, background, mappingChoice, axis, scale, scale, rho);
    }

    public float getMagnitude(int x, int y) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            float[] p = new float[2];
            FlowJFlow.polar(p, this.get(x, y));
            if (this.full[y][x]) {
                return p[0];
            }
            return 0.0f;
        }
        return -1.0f;
    }

    public float getAlphaDeg(int x, int y) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            float[] p = new float[2];
            FlowJFlow.polar(p, this.get(x, y));
            float a = p[1] * 360.0f / ((float)Math.PI * 2);
            if (a >= 360.0f) {
                return a - 360.0f;
            }
            return a;
        }
        return -1.0f;
    }

    public String calibratedMagnitudeString(float magnitude, int significance) {
        return IJ.d2s((double)(this.c.pixelWidth * (double)magnitude), (int)significance) + this.c.getUnits() + "/frame";
    }

    public int average(Roi roi) {
        Rectangle r = roi.getBoundingRect();
        float xSum = 0.0f;
        float ySum = 0.0f;
        int s = 0;
        for (int y = 0; y < r.height; ++y) {
            for (int x = 0; x < r.width; ++x) {
                if (!this.full[r.y + y][r.x + x] || !roi.contains(r.x + x, r.y + y)) continue;
                xSum += this.v.v[r.y + y][r.x + x][0];
                ySum += this.v.v[r.y + y][r.x + x][1];
                ++s;
            }
        }
        this.avg[0] = xSum / (float)s;
        this.avg[1] = ySum / (float)s;
        return s;
    }

    public float averageAlpha() {
        float[] p = new float[2];
        FlowJFlow.polar(p, this.avg[0], this.avg[1]);
        return p[1] * 360.0f / ((float)Math.PI * 2);
    }

    public float averageMagnitude() {
        float[] p = new float[2];
        FlowJFlow.polar(p, this.avg[0], this.avg[1]);
        return p[0];
    }

    private float readfloat(InputStream s) {
        byte[] buffer = new byte[4];
        try {
            s.read(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            IJ.log((String)("error reading float" + e));
            return 0.0f;
        }
        int tmp = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        return Float.intBitsToFloat(tmp);
    }

    private void writefloat(float d, OutputStream s) {
        byte[] buffer = new byte[4];
        int tmp = Float.floatToIntBits(d);
        buffer[0] = (byte)(tmp >> 24 & 0xFF);
        buffer[1] = (byte)(tmp >> 16 & 0xFF);
        buffer[2] = (byte)(tmp >> 8 & 0xFF);
        buffer[3] = (byte)(tmp & 0xFF);
        try {
            s.write(buffer, 0, buffer.length);
        }
        catch (IOException e) {
            IJ.log((String)("error writing float" + e));
            return;
        }
    }

    public boolean read(String fileName) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return false;
        }
        int width = (int)this.readfloat(is);
        int height = (int)this.readfloat(is);
        this.v = new VolumeFloat(2, width, height);
        int size = this.getWidth() * this.getHeight();
        this.full = new boolean[height][width];
        int endwidth = (int)this.readfloat(is);
        int endheight = (int)this.readfloat(is);
        int startwidth = (int)this.readfloat(is);
        int startheight = (int)this.readfloat(is);
        for (int y = 0; y < this.v.getHeight(); ++y) {
            if (y >= startheight && y < endheight) {
                byte[] buffer = new byte[this.getWidth() * 4 * 2];
                try {
                    ((InputStream)is).read(buffer, 0, buffer.length);
                }
                catch (IOException e) {
                    IJ.log((String)("" + e));
                    return false;
                }
                int tmpx = 0;
                int tmpy = 0;
                for (int x = startwidth; x < endwidth; ++x) {
                    tmpx = (buffer[x * 4 * 2 + 0] & 0xFF) << 24 | (buffer[x * 4 * 2 + 1] & 0xFF) << 16 | (buffer[x * 4 * 2 + 2] & 0xFF) << 8 | buffer[x * 4 * 2 + 3] & 0xFF;
                    tmpy = (buffer[x * 4 * 2 + 4 + 0] & 0xFF) << 24 | (buffer[x * 4 * 2 + 4 + 1] & 0xFF) << 16 | (buffer[x * 4 * 2 + 4 + 2] & 0xFF) << 8 | buffer[x * 4 * 2 + 4 + 3] & 0xFF;
                    if (Float.intBitsToFloat(tmpx) == 100.0f && Float.intBitsToFloat(tmpy) == 100.0f) {
                        this.set(x, y, 0.0f, 0.0f, false);
                        continue;
                    }
                    this.set(x, y, Float.intBitsToFloat(tmpx), Float.intBitsToFloat(tmpy), true);
                }
            }
            IJ.showStatus((String)("Reading... " + 100 * (y * this.getHeight()) / size + "%"));
        }
        try {
            ((InputStream)is).close();
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return false;
        }
        return true;
    }

    public void write(String fileName) {
        FileOutputStream s = null;
        try {
            s = new FileOutputStream(fileName);
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
        this.writefloat(this.getWidth(), s);
        this.writefloat(this.getHeight(), s);
        this.writefloat(this.getWidth(), s);
        this.writefloat(this.getHeight(), s);
        this.writefloat(0.0f, s);
        this.writefloat(0.0f, s);
        for (int y = 0; y < this.getHeight(); ++y) {
            byte[] buffer = new byte[this.getWidth() * 4 * 2];
            int tmp = 0;
            for (int x = 0; x < this.getWidth(); ++x) {
                tmp = this.full[y][x] ? Float.floatToIntBits(this.getX(x, y)) : Float.floatToIntBits(100.0f);
                buffer[x * 4 * 2 + 0] = (byte)(tmp >> 24 & 0xFF);
                buffer[x * 4 * 2 + 1] = (byte)(tmp >> 16 & 0xFF);
                buffer[x * 4 * 2 + 2] = (byte)(tmp >> 8 & 0xFF);
                buffer[x * 4 * 2 + 3] = (byte)(tmp & 0xFF);
                tmp = this.full[y][x] ? Float.floatToIntBits(this.getY(x, y)) : Float.floatToIntBits(100.0f);
                buffer[x * 4 * 2 + 4 + 0] = (byte)(tmp >> 24 & 0xFF);
                buffer[x * 4 * 2 + 4 + 1] = (byte)(tmp >> 16 & 0xFF);
                buffer[x * 4 * 2 + 4 + 2] = (byte)(tmp >> 8 & 0xFF);
                buffer[x * 4 * 2 + 4 + 3] = (byte)(tmp & 0xFF);
            }
            try {
                ((OutputStream)s).write(buffer, 0, buffer.length);
            }
            catch (IOException e) {
                IJ.log((String)("cannot write flow field" + e));
                return;
            }
            IJ.showStatus((String)("Writing... " + 100 * (y * this.v.getHeight()) / (this.v.getWidth() * this.v.getHeight()) + "%"));
        }
        try {
            ((OutputStream)s).close();
        }
        catch (IOException e) {
            IJ.log((String)("" + e));
            return;
        }
    }

    public void createRotation(int centerX, int centerY, float angle, Roi roi) {
        Rectangle r = null;
        if (roi instanceof Roi) {
            r = roi.getBoundingRect();
        }
        int fulls = 0;
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getWidth(); ++x) {
                boolean doflag;
                this.set(x, y, 0.0f, 0.0f, false);
                boolean bl = doflag = !(roi instanceof Roi);
                if (!doflag) {
                    boolean bl2 = doflag = x > r.x && x < r.x + r.width && y > r.y && y < r.y + r.height && roi.contains(x, y);
                }
                if (!doflag) continue;
                float[] fv = FlowJFlow.polar((float)(x - centerX) + 0.5f, (float)(-(y - centerY)) + 0.5f);
                float[] expA = new float[]{fv[0] * (float)Math.tan(-angle), fv[1] + 1.5707964f};
                float[] expG = new float[2];
                FlowJFlow.toGrid(expG, expA);
                this.set(x, y, expG[0], expG[1]);
                ++fulls;
            }
        }
        IJ.log((String)("Rotate " + centerX + ", " + centerY + "; " + fulls + " pixels in flow field"));
    }

    public static float magnitude3D(float[] r) {
        return (float)Math.sqrt(r[0] * r[0] + r[1] * r[1] + r[2] * r[2]);
    }

    public static float orientationxy(float[] r) {
        return FlowJFlow.orientationxy(r[0], r[1]);
    }

    public static float orientationxy(float vx, float vy) {
        float orient = vx == 0.0f && vy == 0.0f ? 0.0f : (vx > 0.0f && vy >= 0.0f ? (float)Math.atan(vy / vx) : (vx <= 0.0f && vy > 0.0f ? 1.5707964f + (float)Math.atan(-vx / vy) : (vx < 0.0f && vy <= 0.0f ? (float)Math.PI + (float)Math.atan(-vy / -vx) : 4.712389f + (float)Math.atan(vx / -vy))));
        if ((double)orient >= Math.PI * 2) {
            orient = (float)((double)orient - Math.PI * 2);
        }
        if (orient < 0.0f) {
            orient = (float)((double)orient + Math.PI * 2);
        }
        return orient;
    }

    public static float orientationz(float[] r) {
        float lxy = r[0] * r[0] + r[1] * r[1];
        if (lxy == 0.0f) {
            return 1.5707964f + (r[2] > 0.0f ? 0.0f : (float)Math.PI);
        }
        return (float)Math.atan(r[2] / (float)Math.sqrt(lxy));
    }

    public static void polar3D(float[] p, float[] r) {
        p[0] = FlowJFlow.magnitude3D(r);
        p[1] = FlowJFlow.orientationxy(r);
        p[2] = FlowJFlow.orientationz(r);
    }

    public static void polar3D(float[] p, float vx, float vy, float vz) {
        float lxy = vx * vx + vy * vy;
        p[0] = (float)Math.sqrt(lxy + vz * vz);
        p[1] = FlowJFlow.orientationxy(vx, vy);
        p[2] = lxy == 0.0f ? 1.5707964f + (vz > 0.0f ? 0.0f : (float)Math.PI) : (float)Math.atan((double)vz / Math.sqrt(lxy));
    }

    public static void polar(float[] p, float rx, float ry) {
        p[0] = (float)Math.sqrt(rx * rx + ry * ry);
        p[1] = FlowJFlow.orientationxy(rx, ry);
    }

    public static float[] polar(float rx, float ry) {
        float[] p = new float[]{(float)Math.sqrt(rx * rx + ry * ry), FlowJFlow.orientationxy(rx, ry)};
        return p;
    }

    public static float[] polar(float[] r) {
        float[] p = new float[]{(float)Math.sqrt(r[0] * r[0] + r[1] * r[1]), FlowJFlow.orientationxy(r)};
        return p;
    }

    public static void polar(float[] p, float[] r) {
        FlowJFlow.polar(p, r[0], r[1]);
    }

    public static void toGrid(float[] grid, float[] polar) {
        grid[0] = (float)Math.cos(polar[1]) * polar[0];
        grid[1] = (float)Math.sin(polar[1]) * polar[0];
    }
}

