/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijfit.Maximum;
import bijnum.BIJfht;
import bijnum.BIJmatrix;
import bijnum.BIJutil;
import ij.IJ;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import registration.Register;
import volume.Hessian;

public class RegisterFFTHessian
extends Register {
    protected BIJfht fht;
    protected float[] referencefft;
    protected int debug = 3;

    public RegisterFFTHessian(float[] reference, int width) {
        this.reference = reference;
        IJ.showStatus((String)"Registering...computing edges");
        float[] edges = Hessian.largest(reference, width, 2.0);
        if (this.debug == 1) {
            ImagePlus mimp = new ImagePlus("reference edges", (ImageProcessor)new FloatProcessor(width, reference.length / width, edges, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        float[] fit = BIJutil.tile(edges, width);
        this.referencefft = new float[fit.length];
        for (int i = 0; i < fit.length; ++i) {
            this.referencefft[i] = fit[i];
        }
        if (this.debug == 3) {
            new ImagePlus("reference_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(fit.length), (int)Math.sqrt(fit.length), fit, null)).show();
        }
        this.fht = new BIJfht(this.referencefft.length);
        IJ.showStatus((String)"Registering...computing FFT of reference image");
        this.fht.compute(this.referencefft, false);
        if (this.debug == 3) {
            new ImagePlus("reference fft", (ImageProcessor)new ByteProcessor((int)Math.sqrt(this.referencefft.length), (int)Math.sqrt(this.referencefft.length), this.fht.getPowerSpectrum(this.referencefft), null)).show();
        }
        this.width = width;
        this.mask = null;
    }

    public RegisterFFTHessian(float[] reference, int width, float[] mask) {
        IJ.showStatus((String)"Registering...computing vessel edges");
        float[] edges = Hessian.largest(reference, width, 2.0);
        if (mask != null) {
            edges = BIJmatrix.mulElements(edges, mask);
        }
        if (this.debug == 1) {
            ImagePlus mimp = new ImagePlus("reference edges", (ImageProcessor)new FloatProcessor(width, reference.length / width, edges, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        float[] fit = BIJutil.tile(edges, width);
        float[] referencefft = new float[fit.length];
        for (int i = 0; i < fit.length; ++i) {
            referencefft[i] = fit[i];
        }
        if (this.debug == 3) {
            new ImagePlus("reference_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(fit.length), (int)Math.sqrt(fit.length), fit, null)).show();
        }
        this.fht = new BIJfht(referencefft.length);
        IJ.showStatus((String)"Registering...computing FFT of reference image");
        this.fht.compute(referencefft, false);
        if (this.debug == 3) {
            new ImagePlus("reference_fft", (ImageProcessor)new FloatProcessor((int)Math.sqrt(referencefft.length), (int)Math.sqrt(referencefft.length), referencefft, null)).show();
        }
        this.width = width;
        this.mask = mask;
    }

    @Override
    public float[] register(float[] image) {
        float[] nmedges;
        IJ.showStatus((String)"Registering...computing edges");
        float[] edges = nmedges = Hessian.largest(image, this.width, 2.0);
        if (this.mask != null) {
            edges = BIJmatrix.mulElements(nmedges, this.mask);
        }
        float[] fit = BIJutil.tile(edges, this.width);
        if (this.debug == 3) {
            ImagePlus mimp = new ImagePlus("edges_tile", (ImageProcessor)new FloatProcessor((int)Math.sqrt(fit.length), (int)Math.sqrt(fit.length), fit, null));
            mimp.show();
            FileSaver fs = new FileSaver(mimp);
            fs.saveAsTiff("c:/" + mimp.getTitle() + ".tif");
        }
        float[] fft = new float[fit.length];
        for (int i = 0; i < fit.length; ++i) {
            fft[i] = fit[i];
        }
        IJ.showStatus((String)"Registering...computing FFT");
        this.fht.compute(fft, false);
        if (this.debug == 3) {
            new ImagePlus("image fft", (ImageProcessor)new ByteProcessor((int)Math.sqrt(fft.length), (int)Math.sqrt(fft.length), this.fht.getPowerSpectrum(fft), null)).show();
        }
        IJ.showStatus((String)"Registering...computing inverse power spectrum");
        float[] icps = this.fht.crossPowerSpectrum(this.referencefft, fft);
        this.fht.compute(icps, true);
        float[] spectrum = this.fht.flipquad(icps);
        if (this.debug > 2) {
            new ImagePlus("Inverse cross power spectrum", (ImageProcessor)new FloatProcessor((int)Math.sqrt(spectrum.length), (int)Math.sqrt(spectrum.length), spectrum, null)).show();
        }
        float[] crosscorrelation = BIJutil.fit(spectrum, this.width, image.length / this.width);
        if (this.mask != null) {
            BIJmatrix.mulElements(crosscorrelation, this.mask);
        }
        this.estimate = Maximum.findSubpixel(crosscorrelation, this.width);
        if (this.debug > 3) {
            new ImagePlus("X corr", (ImageProcessor)new FloatProcessor(this.width, crosscorrelation.length / this.width, crosscorrelation, null)).show();
        }
        return this.estimate;
    }

    public String toString() {
        return "" + this.estimate[0] + "\t" + this.estimate[1] + "\t";
    }
}

