/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import sc.fiji.filamentdetector.gui.controller.AbstractController;
import sc.fiji.filamentdetector.model.Filament;

public class DetailedFilamentController
extends AbstractController
implements Initializable {
    @FXML
    private Label idLabel;
    @FXML
    private Label frameLabel;
    @FXML
    private Label lenghtLabel;
    @FXML
    private Label sizeLabel;
    @FXML
    private Label sinuosityLabel;
    @FXML
    private Label colorLabel;
    @FXML
    public Button removeFilamentLabel;
    private Filament filament;

    public DetailedFilamentController(Filament filament) {
        this.filament = filament;
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        DecimalFormat f = new DecimalFormat("##.00");
        this.idLabel.setText(Integer.toString(this.filament.getId()));
        this.frameLabel.setText(Integer.toString(this.filament.getFrame()));
        this.lenghtLabel.setText(f.format(this.filament.getLength()));
        this.sizeLabel.setText(Integer.toString(this.filament.getSize()));
        this.sinuosityLabel.setText(f.format(this.filament.getSinuosity()));
        this.colorLabel.setStyle("-fx-background-color:" + this.filament.getColorAsHex());
    }

    public Button getRemoveFilamentLabel() {
        return this.removeFilamentLabel;
    }

    public Filament getFilament() {
        return this.filament;
    }
}

