/*
 * Decompiled with CFR 0.152.
 */
package fiji.packaging;

import fiji.packaging.Packager;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TarPackager
extends Packager {
    protected OutputStream out;
    protected Set<String> directories = new HashSet<String>();
    protected byte[] header = new byte[512];
    protected int epoch = (int)(System.currentTimeMillis() / 1000L);
    protected int fileOffset;
    protected int fileSize;

    @Override
    public String getExtension() {
        return ".tar";
    }

    @Override
    public void open(OutputStream out) throws IOException {
        this.out = out;
    }

    @Override
    public void putNextEntry(String name, boolean executable, int size) throws IOException {
        this.handleDirectory(name);
        this.writeHeader(name, executable ? 493 : 420, size, 0);
        this.fileSize = size;
        this.fileOffset = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.fileOffset + len > this.fileSize) {
            throw new IOException("Unaligned file");
        }
        this.out.write(b, off, len);
        this.fileOffset += len;
    }

    @Override
    public void closeEntry() throws IOException {
        if (this.fileOffset != this.fileSize) {
            throw new IOException("Short file");
        }
        int remainder = this.fileSize & 0x1FF;
        if (remainder > 0) {
            Arrays.fill(this.header, (byte)0);
            this.out.write(this.header, 0, 512 - remainder);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    protected void handleDirectory(String name) throws IOException {
        int slash = name.lastIndexOf(47, name.length() - 2);
        if (slash < 0) {
            return;
        }
        if (this.directories.contains(name = name.substring(0, slash + 1))) {
            return;
        }
        this.handleDirectory(name);
        this.writeHeader(name, 511, 0, 5);
        this.directories.add(name);
    }

    protected void writeHeader(String name, int mode, int size, int type) throws IOException {
        Arrays.fill(this.header, (byte)0);
        if (name.length() > 99) {
            String headerName = "ext-header." + name.hashCode();
            String extendedHeader = this.makeExtendedHeader("path", name);
            int extSize = extendedHeader.length();
            Arrays.fill(this.header, (byte)0);
            System.arraycopy(headerName.getBytes("ASCII"), 0, this.header, 0, headerName.length());
            this.digits(438L, 100, 8);
            this.digits(1000L, 108, 8);
            this.digits(1000L, 116, 8);
            this.digits(extSize, 124, 12);
            this.digits(this.epoch, 136, 12);
            this.header[156] = 120;
            System.arraycopy("ustar".getBytes("ASCII"), 0, this.header, 257, 5);
            this.checksumHeader();
            this.out.write(this.header);
            Arrays.fill(this.header, (byte)0);
            this.out.write(extendedHeader.getBytes("ASCII"));
            if ((extSize & 0x1FF) > 0) {
                this.out.write(this.header, 0, 512 - (extSize & 0x1FF));
            }
            name = "ext-name." + name.hashCode();
        }
        System.arraycopy(name.getBytes("ASCII"), 0, this.header, 0, name.length());
        this.digits(mode, 100, 8);
        this.digits(1000L, 108, 8);
        this.digits(1000L, 116, 8);
        this.digits(size, 124, 12);
        this.digits(this.epoch, 136, 12);
        if (type != 0) {
            this.header[156] = (byte)(48 + type);
        }
        this.checksumHeader();
        this.out.write(this.header);
    }

    protected String makeExtendedHeader(String key, String value) {
        String result = key + "=" + value + "\n";
        int len = result.length() + 2;
        while (len != ("" + len + " " + result).length()) {
            len = ("" + len + " " + result).length();
        }
        return "" + len + " " + result;
    }

    protected void checksumHeader() {
        Arrays.fill(this.header, 148, 156, (byte)32);
        int checksum = 0;
        for (int i = 0; i < this.header.length; ++i) {
            checksum += this.header[i] & 0xFF;
        }
        this.digits(checksum, 148, 7);
    }

    protected void digits(long number, int offset, int len) {
        number = Long.parseLong(Long.toOctalString(number));
        this.header[offset + len - 1] = 0;
        int i = len - 2;
        while (i >= 0) {
            this.header[offset + i] = (byte)(48L + number % 10L);
            --i;
            number /= 10L;
        }
    }
}

