/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.parallel;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import net.imglib2.parallel.DefaultTaskExecutor;
import net.imglib2.parallel.ForkJoinExecutorService;
import net.imglib2.parallel.Parallelization;
import net.imglib2.parallel.SequentialTaskExecutor;
import net.imglib2.parallel.TaskExecutor;

public final class TaskExecutors {
    private static final TaskExecutor FORK_JOIN_TASK_EXECUTOR = new DefaultTaskExecutor(new ForkJoinExecutorService());

    private TaskExecutors() {
    }

    public static TaskExecutor singleThreaded() {
        return SequentialTaskExecutor.getInstance();
    }

    public static TaskExecutor multiThreaded() {
        return FORK_JOIN_TASK_EXECUTOR;
    }

    public static TaskExecutor numThreads(int numThreads) {
        numThreads = Math.max(1, numThreads);
        return TaskExecutors.forExecutorService(new ForkJoinPool(numThreads));
    }

    public static TaskExecutor forExecutorService(ExecutorService executorService) {
        return new DefaultTaskExecutor(executorService);
    }

    public static TaskExecutor forExecutorServiceAndNumThreads(ExecutorService executorService, final int numThreads) {
        return new DefaultTaskExecutor(executorService){

            @Override
            public int getParallelism() {
                return numThreads;
            }
        };
    }

    public static TaskExecutor forExecutorServiceAndNumTasks(ExecutorService executorService, final int numTasks) {
        return new DefaultTaskExecutor(executorService){

            @Override
            public int suggestNumberOfTasks() {
                return numTasks;
            }
        };
    }

    public static TaskExecutor fixedThreadPool(int numThreads) {
        ThreadFactory threadFactory = TaskExecutors.threadFactory(() -> TaskExecutors.singleThreaded());
        return TaskExecutors.forExecutorService(Executors.newFixedThreadPool(numThreads, threadFactory));
    }

    public static TaskExecutor nestedFixedThreadPool(int numThreads, int numSubThreads) {
        ThreadFactory threadFactory = TaskExecutors.threadFactory(() -> TaskExecutors.fixedThreadPool(numSubThreads));
        return TaskExecutors.forExecutorService(Executors.newFixedThreadPool(numThreads, threadFactory));
    }

    public static ThreadFactory threadFactory(Supplier<TaskExecutor> taskExecutorFactory) {
        return TaskExecutors.applyTaskExecutorToThreadFactory(taskExecutorFactory, Executors.defaultThreadFactory());
    }

    public static ThreadFactory applyTaskExecutorToThreadFactory(Supplier<TaskExecutor> taskExecutorFactory, ThreadFactory threadFactory) {
        return runnable -> threadFactory.newThread(() -> TaskExecutors.lambda$null$2((Supplier)taskExecutorFactory, runnable));
    }

    private static /* synthetic */ void lambda$null$2(Supplier taskExecutorFactory, Runnable runnable) {
        try (TaskExecutor taskExecutor = (TaskExecutor)taskExecutorFactory.get();){
            Parallelization.runWithExecutor(taskExecutor, runnable);
        }
    }
}

