/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.util.Util;

public class UnsignedByteType
extends GenericByteType<UnsignedByteType> {
    private static final NativeTypeFactory<UnsignedByteType, ByteAccess> typeFactory = NativeTypeFactory.BYTE(UnsignedByteType::new);

    public UnsignedByteType(NativeImg<?, ? extends ByteAccess> img) {
        super(img);
    }

    public UnsignedByteType(int value) {
        super(UnsignedByteType.getCodedSignedByte(value));
    }

    public UnsignedByteType(ByteAccess access) {
        super(access);
    }

    public UnsignedByteType() {
        this(0);
    }

    public static byte getCodedSignedByteChecked(int unsignedByte) {
        if (unsignedByte < 0) {
            unsignedByte = 0;
        } else if (unsignedByte > 255) {
            unsignedByte = 255;
        }
        return UnsignedByteType.getCodedSignedByte(unsignedByte);
    }

    public static byte getCodedSignedByte(int unsignedByte) {
        return (byte)(unsignedByte & 0xFF);
    }

    public static int getUnsignedByte(byte signedByte) {
        return signedByte & 0xFF;
    }

    @Override
    public UnsignedByteType duplicateTypeOnSameNativeImg() {
        return new UnsignedByteType(this.img);
    }

    @Override
    public NativeTypeFactory<UnsignedByteType, ByteAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public void mul(float c) {
        int a = UnsignedByteType.getUnsignedByte(this.getByte());
        this.setByte(UnsignedByteType.getCodedSignedByte(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        int a = UnsignedByteType.getUnsignedByte(this.getByte());
        this.setByte(UnsignedByteType.getCodedSignedByte((int)Util.round((double)a * c)));
    }

    @Override
    public void add(UnsignedByteType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedByteType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(UnsignedByteType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedByteType c) {
        this.set(this.get() - c.get());
    }

    public int get() {
        return UnsignedByteType.getUnsignedByte(this.getByte());
    }

    @Override
    public void set(int f) {
        this.setByte(UnsignedByteType.getCodedSignedByte(f));
    }

    @Override
    public int getInteger() {
        return this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set((int)f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.intValue());
    }

    @Override
    public double getMaxValue() {
        return 255.0;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public UnsignedByteType createVariable() {
        return new UnsignedByteType(0);
    }

    @Override
    public UnsignedByteType copy() {
        return new UnsignedByteType(this.dataAccess != null ? this.get() : 0);
    }

    @Override
    public String toString() {
        return "" + this.get();
    }

    @Override
    public int compareTo(UnsignedByteType other) {
        return Integer.compare(this.get(), other.get());
    }
}

