/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.ijsupport;

import edu.utexas.clm.archipelago.Cluster;
import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.ijsupport.bottle.LayerBottler;
import edu.utexas.clm.archipelago.ijsupport.bottle.PatchBottler;
import edu.utexas.clm.archipelago.ijsupport.bottle.PointBottler;
import edu.utexas.clm.archipelago.ijsupport.bottle.SIFTParamBottler;
import edu.utexas.clm.archipelago.listen.ClusterStateListener;
import edu.utexas.clm.archipelago.network.client.ArchipelagoClient;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.parallel.DefaultExecutorProvider;
import ini.trakem2.parallel.ExecutorProvider;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.utils.Utils;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;

public class TrakEM2Archipelago
implements TPlugIn {
    public boolean setup(Object ... params) {
        Cluster cluster;
        if (Cluster.initializedCluster()) {
            cluster = Cluster.getCluster();
            if (cluster.numRegisteredUIs() <= 0 && !FijiArchipelago.runClusterGUI()) {
                return false;
            }
        } else {
            if (!FijiArchipelago.runClusterGUI()) {
                return false;
            }
            cluster = Cluster.getCluster();
        }
        cluster.addBottler((Bottler)new PointBottler());
        cluster.addBottler((Bottler)new LayerBottler());
        cluster.addBottler((Bottler)new PatchBottler());
        cluster.addBottler((Bottler)new SIFTParamBottler());
        cluster.addStateListener((ClusterStateListener)new ProviderListener());
        ExecutorProvider.setProvider((ExecutorProvider)new ClusterProvider(cluster));
        FijiArchipelago.log((String)"TrakEM2 now using the Cluster");
        return true;
    }

    public Object invoke(Object ... params) {
        return null;
    }

    public boolean applies(Object ob) {
        return false;
    }

    public static File getFile(Project p) {
        FSLoader loader = (FSLoader)p.getLoader();
        return new File(loader.getProjectXMLPath());
    }

    public static synchronized Project getProject(File projectFile) {
        for (Project p : Project.getProjects()) {
            if (!projectFile.equals(TrakEM2Archipelago.getFile(p))) continue;
            return p;
        }
        ControlWindow.setGUIEnabled((boolean)false);
        if (!(Utils.getLogStream() instanceof LogStream)) {
            Utils.setLogStream((PrintStream)new LogStream((OutputStream)System.out, ArchipelagoClient.getFirstClient()));
        }
        return Project.openFSProject((String)projectFile.getAbsolutePath(), (boolean)false);
    }

    private class ClusterProvider
    extends ExecutorProvider {
        private final Cluster cluster;

        public ClusterProvider(Cluster c) {
            this.cluster = c;
        }

        public ExecutorService getService(int nThreads) {
            return this.cluster.getService(nThreads);
        }

        public ExecutorService getService(float fractionThreads) {
            return this.cluster.getService(fractionThreads);
        }
    }

    private class ProviderListener
    implements ClusterStateListener {
        private final AtomicBoolean doneSwitched = new AtomicBoolean(false);

        public synchronized void stateChanged(Cluster cluster) {
            switch (cluster.getState()) {
                case STOPPED: 
                case STOPPING: {
                    if (this.doneSwitched.getAndSet(true)) break;
                    FijiArchipelago.log((String)"TrakEM2 now using the Default ExecutorService Provider");
                    if (!(ExecutorProvider.getProvider() instanceof ClusterProvider)) break;
                    ExecutorProvider.setProvider((ExecutorProvider)new DefaultExecutorProvider());
                }
            }
        }
    }

    private static class LogStream
    extends PrintStream {
        private final ArchipelagoClient client;

        public LogStream(OutputStream stream, ArchipelagoClient client) {
            super(stream);
            this.client = client;
        }

        @Override
        public void println(String str) {
            super.println(str);
            if (this.client != null) {
                this.client.log(str);
            }
        }
    }
}

