/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.filters.Filter;

public abstract class AbstractFilter<T>
extends AbstractSCIFIOPlugin
implements Filter {
    private T parent = null;
    private final Class<? extends T> parentClass;

    public AbstractFilter(Class<? extends T> parentClass) {
        this.parentClass = parentClass;
    }

    @Override
    public boolean enabledDefault() {
        return false;
    }

    public T getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Object parent) {
        if (!this.parentClass.isAssignableFrom(parent.getClass())) {
            throw new IllegalArgumentException("Invalid parent. Provided: " + parent.getClass() + " Expected: " + this.parentClass);
        }
        this.parent = parent;
    }

    @Override
    public void reset() {
        this.parent = null;
    }

    @Override
    public boolean isCompatible(Class<?> c) {
        return this.parentClass.isAssignableFrom(c);
    }
}

