/*
 * Decompiled with CFR 0.152.
 */
package io.scif.img;

import io.scif.Reader;
import io.scif.Writer;
import io.scif.config.SCIFIOConfig;
import io.scif.img.AbstractImgIOComponent;
import io.scif.img.ImgIOException;
import io.scif.img.ImgOpener;
import io.scif.img.ImgSaver;
import io.scif.img.SCIFIOImgPlus;
import io.scif.refs.RefManagerService;
import java.net.URISyntaxException;
import java.util.List;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.Context;
import org.scijava.io.location.Location;
import org.scijava.io.location.LocationService;
import org.scijava.log.LogService;
import org.scijava.util.ListUtils;

public final class IO {
    private static LogService logService;

    public static SCIFIOImgPlus<?> open(Location source) {
        return IO.open(IO.opener(), source);
    }

    public static SCIFIOImgPlus<?> open(String source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source)));
    }

    public static SCIFIOImgPlus<FloatType> openFloat(Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllFloat(source)));
    }

    public static SCIFIOImgPlus<FloatType> openFloat(String source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllFloat(source)));
    }

    public static SCIFIOImgPlus<DoubleType> openDouble(Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllDouble(source)));
    }

    public static SCIFIOImgPlus<DoubleType> openDouble(String source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllDouble(source)));
    }

    public static SCIFIOImgPlus<UnsignedByteType> openUnsignedByte(Location source) {
        return IO.openUnsignedByte(IO.opener(), source);
    }

    public static SCIFIOImgPlus<UnsignedByteType> openUnsignedByte(String source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllUnsignedByte(source)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Location source, T type) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, type)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(String source, T type) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, type)));
    }

    public static SCIFIOImgPlus<?> open(String source, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, config)));
    }

    public static SCIFIOImgPlus<?> open(Location source, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, config)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Location source, T type, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, type, config)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(String source, T type, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, type, config)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(String source, ImgFactory<T> imgFactory) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, imgFactory)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Location source, ImgFactory<T> imgFactory) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, imgFactory)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, imgFactory, config)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Location source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(source, imgFactory, config)));
    }

    public static SCIFIOImgPlus<?> open(Reader reader, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(reader, config)));
    }

    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Reader reader, T type, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(reader, type, config)));
    }

    public static <T extends RealType<T>> SCIFIOImgPlus<T> open(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(reader, type, imgFactory, config)));
    }

    public static List<SCIFIOImgPlus<?>> openAll(Location source) {
        return IO.openAll(IO.opener(), source);
    }

    public static List<SCIFIOImgPlus<?>> openAll(String source) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()));
    }

    public static List<SCIFIOImgPlus<FloatType>> openAllFloat(Location source) {
        return IO.openAllFloat(IO.opener(), source);
    }

    public static List<SCIFIOImgPlus<FloatType>> openAllFloat(String source) {
        ImgOpener opener = new ImgOpener();
        return IO.openAllFloat(opener, IO.resolve(source, opener.context()));
    }

    public static List<SCIFIOImgPlus<DoubleType>> openAllDouble(Location source) {
        return IO.openAllDouble(IO.opener(), source);
    }

    public static List<SCIFIOImgPlus<DoubleType>> openAllDouble(String source) {
        ImgOpener opener = new ImgOpener();
        return IO.openAllDouble(opener, IO.resolve(source, opener.context()));
    }

    public static List<SCIFIOImgPlus<UnsignedByteType>> openAllUnsignedByte(Location source) {
        return IO.openAllUnsignedByte(IO.opener(), source);
    }

    public static List<SCIFIOImgPlus<UnsignedByteType>> openAllUnsignedByte(String source) {
        ImgOpener opener = new ImgOpener();
        return IO.openAllUnsignedByte(opener, IO.resolve(source, opener.context()));
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Location source, T type) {
        return IO.openAll(IO.opener(), source, type);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(String source, T type) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), type);
    }

    public static List<SCIFIOImgPlus<?>> openAll(String source, SCIFIOConfig config) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), config);
    }

    public static List<SCIFIOImgPlus<?>> openAll(Location source, SCIFIOConfig config) {
        return IO.openAll(IO.opener(), source, config);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(String source, T type, SCIFIOConfig config) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), type, config);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Location source, T type, SCIFIOConfig config) {
        return IO.openAll(IO.opener(), source, type, config);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(String source, ImgFactory<T> imgFactory) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), imgFactory);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Location source, ImgFactory<T> imgFactory) {
        return IO.openAll(IO.opener(), source, imgFactory);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), imgFactory, config);
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Location source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.openAll(IO.opener(), source, imgFactory, config);
    }

    public static List<SCIFIOImgPlus<?>> openAll(Reader reader, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getSourceLocation(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Reader reader, T type, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, type, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getSourceLocation(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T>> List<SCIFIOImgPlus<T>> openAll(Reader reader, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, imgFactory, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getSourceLocation(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static <T extends RealType<T>> List<SCIFIOImgPlus<T>> openAll(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        ImgOpener opener = IO.opener();
        List imgPlus = null;
        try {
            imgPlus = opener.openImgs(reader, imgFactory.imgFactory(type), config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(reader.getMetadata().getSourceLocation(), (Exception)((Object)e));
        }
        return imgPlus;
    }

    public static void save(String dest, Img<?> img) {
        ImgSaver saver = new ImgSaver();
        IO.save(saver, IO.resolve(dest, saver.context()), img);
    }

    public static void save(Location dest, Img<?> img) {
        IO.save(new ImgSaver(), dest, img);
    }

    public static void save(String dest, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        ImgSaver saver = new ImgSaver();
        IO.save(saver, IO.resolve(dest, saver.context()), imgPlus, imageIndex);
    }

    public static void save(Location dest, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        IO.save(new ImgSaver(), dest, imgPlus, imageIndex);
    }

    public static void save(Writer writer, Img<?> img) {
        try {
            new ImgSaver().saveImg(writer, img);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
    }

    public static void save(Writer writer, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        try {
            new ImgSaver().saveImg(writer, imgPlus, imageIndex);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImgOpener opener() {
        ImgOpener opener = new ImgOpener();
        if (logService != null) return opener;
        Class<IO> clazz = IO.class;
        synchronized (IO.class) {
            if (logService != null) return opener;
            logService = (LogService)opener.getContext().getService(LogService.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return opener;
        }
    }

    private static SCIFIOImgPlus<?> open(ImgOpener opener, Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source)));
    }

    private static SCIFIOImgPlus<FloatType> openFloat(ImgOpener opener, Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllFloat(opener, source)));
    }

    private static SCIFIOImgPlus<DoubleType> openDouble(ImgOpener opener, Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllDouble(opener, source)));
    }

    private static SCIFIOImgPlus<UnsignedByteType> openUnsignedByte(ImgOpener opener, Location source) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAllUnsignedByte(opener, source)));
    }

    private static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(ImgOpener opener, Location source, T type) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source, type)));
    }

    private static SCIFIOImgPlus<?> open(ImgOpener opener, Location source, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source, config)));
    }

    private static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(ImgOpener opener, Location source, T type, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source, type, config)));
    }

    private static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(ImgOpener opener, Location source, ImgFactory<T> imgFactory) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source, imgFactory)));
    }

    private static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(ImgOpener opener, Location source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return (SCIFIOImgPlus)((Object)ListUtils.first(IO.openAll(opener, source, imgFactory, config)));
    }

    private static List<SCIFIOImgPlus<?>> openAll(ImgOpener opener, Location source) {
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static List<SCIFIOImgPlus<FloatType>> openAllFloat(ImgOpener opener, Location source) {
        List<SCIFIOImgPlus<FloatType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new FloatType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static List<SCIFIOImgPlus<DoubleType>> openAllDouble(ImgOpener opener, Location source) {
        List<SCIFIOImgPlus<DoubleType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new DoubleType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static List<SCIFIOImgPlus<UnsignedByteType>> openAllUnsignedByte(ImgOpener opener, Location source) {
        List<SCIFIOImgPlus<UnsignedByteType>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, new UnsignedByteType());
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(ImgOpener opener, Location source, T type) {
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, type);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static List<SCIFIOImgPlus<?>> openAll(ImgOpener opener, Location source, SCIFIOConfig config) {
        List<SCIFIOImgPlus<?>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(ImgOpener opener, Location source, T type, SCIFIOConfig config) {
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, type, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(ImgOpener opener, Location source, ImgFactory<T> imgFactory) {
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, imgFactory);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(ImgOpener opener, Location source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        List<SCIFIOImgPlus<T>> imgPlus = null;
        try {
            imgPlus = opener.openImgs(source, imgFactory, config);
            IO.register(imgPlus, opener);
        }
        catch (ImgIOException e) {
            IO.openError(source, (Exception)((Object)e));
        }
        return imgPlus;
    }

    private static void save(ImgSaver saver, Location dest, Img<?> img) {
        try {
            saver.saveImg(dest, img);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
    }

    private static void save(ImgSaver saver, Location dest, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        try {
            saver.saveImg(dest, imgPlus, imageIndex);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(dest, (Exception)((Object)e));
        }
    }

    private static void register(List<? extends SCIFIOImgPlus> imgPlus, AbstractImgIOComponent component) {
        Context ctx = component.getContext();
        RefManagerService refManagerService = (RefManagerService)ctx.getService(RefManagerService.class);
        for (SCIFIOImgPlus sCIFIOImgPlus : imgPlus) {
            refManagerService.manage((Object)sCIFIOImgPlus, ctx);
        }
    }

    private static Location resolve(String source, Context context) {
        LocationService loc = (LocationService)context.getService(LocationService.class);
        Location location = null;
        try {
            location = loc.resolve(source);
        }
        catch (URISyntaxException e) {
            IO.resolveError(source, e);
        }
        return location;
    }

    private static void openError(Location source, Exception e) {
        logService.error((Object)("Failed to open ImgPlus for source: " + source), (Throwable)e);
    }

    private static void saveError(Location dest, Exception e) {
        logService.error((Object)("Failed to save ImgPlus to id: " + dest), (Throwable)e);
    }

    private static void resolveError(String source, Exception e) {
        logService.error((Object)("Failed to resolve source string: " + source), (Throwable)e);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(String source, ImgFactory<T> imgFactory, T type) {
        ImgOpener opener = new ImgOpener();
        return IO.open(opener, IO.resolve(source, opener.context()), imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> open(Location source, ImgFactory<T> imgFactory, T type) {
        return IO.open(IO.opener(), source, imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(String source, ImgFactory<T> imgFactory, T type) {
        ImgOpener opener = new ImgOpener();
        return IO.openAll(opener, IO.resolve(source, opener.context()), imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openAll(Location source, ImgFactory<T> imgFactory, T type) {
        return IO.openAll(IO.opener(), source, imgFactory);
    }

    @Deprecated
    public static List<SCIFIOImgPlus<?>> openImgs(String source) {
        return IO.openAll(source);
    }

    @Deprecated
    public static List<SCIFIOImgPlus<?>> openImgs(String source, SCIFIOConfig config) {
        return IO.openAll(source, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory) {
        return IO.openAll(source, imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.openAll(source, imgFactory, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, ImgFactory<T> imgFactory, T type) {
        return IO.openAll(source, imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type, SCIFIOConfig config) {
        return IO.openAll(source, type, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(String source, T type) {
        return IO.openAll(source, type);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, SCIFIOConfig config) {
        return IO.openAll(reader, type, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.openAll(reader, imgFactory, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> List<SCIFIOImgPlus<T>> openImgs(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.openAll(reader, type, imgFactory, config);
    }

    @Deprecated
    public static List<SCIFIOImgPlus<FloatType>> openFloatImgs(String source) {
        return IO.openAllFloat(source);
    }

    @Deprecated
    public static List<SCIFIOImgPlus<DoubleType>> openDoubleImgs(String source) {
        return IO.openAllDouble(source);
    }

    @Deprecated
    public static List<SCIFIOImgPlus<UnsignedByteType>> openUnsignedByteImgs(String source) {
        return IO.openAllUnsignedByte(source);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type) {
        return IO.open(source, type);
    }

    @Deprecated
    public static SCIFIOImgPlus<?> openImg(String source, SCIFIOConfig config) {
        return IO.open(source, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, T type, SCIFIOConfig config) {
        return IO.open(source, type, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory) {
        return IO.open(source, imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory, SCIFIOConfig config) throws ImgIOException {
        return IO.open(source, imgFactory, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(String source, ImgFactory<T> imgFactory, T type) {
        return IO.open(source, imgFactory);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, SCIFIOConfig config) {
        return IO.open(reader, type, config);
    }

    @Deprecated
    public static <T extends RealType<T> & NativeType<T>> SCIFIOImgPlus<T> openImg(Reader reader, T type, ImgFactory<T> imgFactory, SCIFIOConfig config) {
        return IO.open(reader, type, imgFactory, config);
    }

    @Deprecated
    public static void saveImg(String dest, Img<?> img) {
        IO.save(dest, img);
    }

    @Deprecated
    public static void saveImg(String dest, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        IO.save(dest, imgPlus, imageIndex);
    }

    @Deprecated
    public static void saveImg(Writer writer, Img<?> img) {
        try {
            new ImgSaver().saveImg(writer, img);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
    }

    public static void saveImg(Writer writer, SCIFIOImgPlus<?> imgPlus, int imageIndex) {
        try {
            new ImgSaver().saveImg(writer, imgPlus, imageIndex);
        }
        catch (IncompatibleTypeException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
        catch (ImgIOException e) {
            IO.saveError(writer.getMetadata().getDestinationLocation(), (Exception)((Object)e));
        }
    }
}

