/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.segmentation;

import ij.ImageJ;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.algorithm.integral.IntegralImageLong;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.segmentation.IntegralImage3d;
import spim.Threads;

public class DOM {
    public static final void computeDifferencOfMean3d(final Image<LongType> integralImg, final Image<FloatType> domImg, final int sx1, final int sy1, final int sz1, final int sx2, final int sy2, final int sz2, float min, float max) {
        float diff = max - min;
        float sumPixels1 = sx1 * sy1 * sz1;
        float sumPixels2 = sx2 * sy2 * sz2;
        final float d1 = sumPixels1 * diff;
        final float d2 = sumPixels2 * diff;
        final int sx1Half = sx1 / 2;
        final int sy1Half = sy1 / 2;
        final int sz1Half = sz1 / 2;
        final int sx2Half = sx2 / 2;
        final int sy2Half = sy2 / 2;
        final int sz2Half = sz2 / 2;
        final int sxHalfMax = Math.max(sx1Half, sx2Half);
        final int syHalfMax = Math.max(sy1Half, sy2Half);
        final int szHalfMax = Math.max(sz1Half, sz2Half);
        final int w = domImg.getDimension(0) - Math.max(sx1, sx2) / 2 * 2;
        final int h = domImg.getDimension(1) - Math.max(sy1, sy2) / 2 * 2;
        final int d = domImg.getDimension(2) - Math.max(sz1, sz2) / 2 * 2;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)Threads.numThreads());
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    LocalizableByDimCursor r11 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r12 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r13 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r14 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r15 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r16 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r17 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r18 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r21 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r22 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r23 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r24 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r25 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r26 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r27 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r28 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor result = domImg.createLocalizableByDimCursor();
                    int[] p = new int[3];
                    for (int z = 0; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < h; ++y) {
                            p[0] = sxHalfMax;
                            p[1] = y + syHalfMax;
                            p[2] = z + szHalfMax;
                            result.setPosition(p);
                            p[0] = sxHalfMax - sx1Half;
                            p[1] = y + syHalfMax - sy1Half;
                            p[2] = z + szHalfMax - sz1Half;
                            r11.setPosition(p);
                            p[0] = p[0] + sx1;
                            r12.setPosition(p);
                            p[1] = p[1] + sy1;
                            r13.setPosition(p);
                            p[0] = p[0] - sx1;
                            r14.setPosition(p);
                            p[2] = p[2] + sz1;
                            r15.setPosition(p);
                            p[0] = p[0] + sx1;
                            r16.setPosition(p);
                            p[1] = p[1] - sy1;
                            r17.setPosition(p);
                            p[0] = p[0] - sx1;
                            r18.setPosition(p);
                            p[0] = sxHalfMax - sx2Half;
                            p[1] = y + syHalfMax - sy2Half;
                            p[2] = z + szHalfMax - sz2Half;
                            r21.setPosition(p);
                            p[0] = p[0] + sx2;
                            r22.setPosition(p);
                            p[1] = p[1] + sy2;
                            r23.setPosition(p);
                            p[0] = p[0] - sx2;
                            r24.setPosition(p);
                            p[2] = p[2] + sz2;
                            r25.setPosition(p);
                            p[0] = p[0] + sx2;
                            r26.setPosition(p);
                            p[1] = p[1] - sy2;
                            r27.setPosition(p);
                            p[0] = p[0] - sx2;
                            r28.setPosition(p);
                            for (int x = 0; x < w; ++x) {
                                long s1 = -((LongType)r11.getType()).get() + ((LongType)r12.getType()).get() - ((LongType)r13.getType()).get() + ((LongType)r14.getType()).get() - ((LongType)r15.getType()).get() + ((LongType)r16.getType()).get() - ((LongType)r17.getType()).get() + ((LongType)r18.getType()).get();
                                long s2 = -((LongType)r21.getType()).get() + ((LongType)r22.getType()).get() - ((LongType)r23.getType()).get() + ((LongType)r24.getType()).get() - ((LongType)r25.getType()).get() + ((LongType)r26.getType()).get() - ((LongType)r27.getType()).get() + ((LongType)r28.getType()).get();
                                ((FloatType)result.getType()).set((float)s2 / d2 - (float)s1 / d1);
                                if (x == w - 1) continue;
                                r11.fwd(0);
                                r12.fwd(0);
                                r13.fwd(0);
                                r14.fwd(0);
                                r15.fwd(0);
                                r16.fwd(0);
                                r17.fwd(0);
                                r18.fwd(0);
                                r21.fwd(0);
                                r22.fwd(0);
                                r23.fwd(0);
                                r24.fwd(0);
                                r25.fwd(0);
                                r26.fwd(0);
                                r27.fwd(0);
                                r28.fwd(0);
                                result.fwd(0);
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static final void mean(final Image<LongType> integralImg, final Image<FloatType> domImg, final int sx, final int sy, final int sz) {
        final float sumPixels = sx * sy * sz;
        final int sxHalf = sx / 2;
        final int syHalf = sy / 2;
        final int szHalf = sz / 2;
        final int w = domImg.getDimension(0) - sx / 2 * 2;
        final int h = domImg.getDimension(1) - sy / 2 * 2;
        final int d = domImg.getDimension(2) - sz / 2 * 2;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    LocalizableByDimCursor r1 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r2 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r3 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r4 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r5 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r6 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r7 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor r8 = integralImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor result = domImg.createLocalizableByDimCursor();
                    int[] p = new int[3];
                    for (int z = 0; z < d; ++z) {
                        if (z % numThreads != myNumber) continue;
                        for (int y = 0; y < h; ++y) {
                            p[0] = sxHalf;
                            p[1] = y + syHalf;
                            p[2] = z + szHalf;
                            result.setPosition(p);
                            p[0] = 0;
                            p[1] = y;
                            p[2] = z;
                            r1.setPosition(p);
                            p[0] = p[0] + sx;
                            r2.setPosition(p);
                            p[1] = p[1] + sy;
                            r3.setPosition(p);
                            p[0] = p[0] - sx;
                            r4.setPosition(p);
                            p[2] = p[2] + sz;
                            r5.setPosition(p);
                            p[0] = p[0] + sx;
                            r6.setPosition(p);
                            p[1] = p[1] - sy;
                            r7.setPosition(p);
                            p[0] = p[0] - sx;
                            r8.setPosition(p);
                            for (int x = 0; x < w; ++x) {
                                long s = -((LongType)r1.getType()).get() + ((LongType)r2.getType()).get() - ((LongType)r3.getType()).get() + ((LongType)r4.getType()).get() - ((LongType)r5.getType()).get() + ((LongType)r6.getType()).get() - ((LongType)r7.getType()).get() + ((LongType)r8.getType()).get();
                                ((FloatType)result.getType()).set((float)s / sumPixels);
                                r1.fwd(0);
                                r2.fwd(0);
                                r3.fwd(0);
                                r4.fwd(0);
                                r5.fwd(0);
                                r6.fwd(0);
                                r7.fwd(0);
                                r8.fwd(0);
                                result.fwd(0);
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static final void meanMirror(Image<LongType> integralImg, final Image<FloatType> domImg, int sx, int sy, int sz) {
        DOM.mean(integralImg, domImg, sx, sy, sz);
        final int sxHalf = sx / 2;
        final int syHalf = sy / 2;
        final int szHalf = sz / 2;
        final int sxHalf2 = sxHalf * 2;
        final int syHalf2 = syHalf * 2;
        final int szHalf2 = szHalf * 2;
        final int w = domImg.getDimension(0);
        final int h = domImg.getDimension(1);
        final int d = domImg.getDimension(2);
        final int w1 = w - sxHalf - 1;
        final int h1 = h - syHalf - 1;
        final int d1 = d - szHalf - 1;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final int numThreads = threads.length;
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    LocalizableByDimCursor c1 = domImg.createLocalizableByDimCursor();
                    LocalizableByDimCursor c2 = domImg.createLocalizableByDimCursor();
                    int[] p1 = new int[3];
                    int[] p2 = new int[3];
                    for (int z = 0; z < d; ++z) {
                        boolean zBigger;
                        if (z % numThreads != myNumber) continue;
                        boolean zSmaller = z < szHalf;
                        boolean bl = zBigger = z > d1;
                        p1[2] = zSmaller ? szHalf2 - z : (zBigger ? 2 * d1 - z : z);
                        p2[2] = z;
                        for (int y = 0; y < h; ++y) {
                            boolean yBigger;
                            boolean ySmaller = y < syHalf;
                            boolean bl2 = yBigger = y > h1;
                            p1[1] = ySmaller ? syHalf2 - y : (yBigger ? 2 * h1 - y : y);
                            p2[1] = y;
                            for (int x = 0; x < w; ++x) {
                                boolean xBigger;
                                boolean xSmaller = x < sxHalf;
                                boolean bl3 = xBigger = x > w1;
                                if (!xSmaller && !ySmaller && !zSmaller && !xBigger && !yBigger && !zBigger) continue;
                                p2[0] = x;
                                c1.setPosition(p2);
                                p1[0] = xSmaller ? sxHalf2 - x : (xBigger ? 2 * w1 - x : x);
                                c2.setPosition(p1);
                                ((FloatType)c1.getType()).set(((FloatType)c2.getType()).get());
                            }
                        }
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static final void computeDifferencOfMean(final Image<LongType> integralImg, final Image<FloatType> domImg, final int sx1, final int sy1, final int sz1, final int sx2, final int sy2, final int sz2, float min, float max) {
        float diff = max - min;
        float sumPixels1 = sx1 * sy1 * sz1;
        float sumPixels2 = sx2 * sy2 * sz2;
        final float d1 = sumPixels1 * diff;
        final float d2 = sumPixels2 * diff;
        final int sx1Half = sx1 / 2;
        final int sy1Half = sy1 / 2;
        final int sz1Half = sz1 / 2;
        final int sx2Half = sx2 / 2;
        final int sy2Half = sy2 / 2;
        final int sz2Half = sz2 / 2;
        final int sxHalfMax = Math.max(sx1Half, sx2Half);
        final int syHalfMax = Math.max(sy1Half, sy2Half);
        final int szHalfMax = Math.max(sz1Half, sz2Half);
        final int w = domImg.getDimension(0) - Math.max(sx1, sx2) / 2 * 2;
        final int h = domImg.getDimension(1) - Math.max(sy1, sy2) / 2 * 2;
        final int d = domImg.getDimension(2) - Math.max(sz1, sz2) / 2 * 2;
        long imageSize = domImg.getNumPixels();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)imageSize, (int)threads.length);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    int[] position = new int[3];
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long loopSize = myChunk.getLoopSize();
                    LocalizableCursor cursor = domImg.createLocalizableCursor();
                    LocalizableByDimCursor randomAccess = integralImg.createLocalizableByDimCursor();
                    cursor.fwd(myChunk.getStartPosition());
                    for (long j = 0L; j < loopSize; ++j) {
                        FloatType result = (FloatType)cursor.next();
                        int x = cursor.getPosition(0);
                        int y = cursor.getPosition(1);
                        int z = cursor.getPosition(2);
                        int xt = x - sxHalfMax;
                        int yt = y - syHalfMax;
                        int zt = z - szHalfMax;
                        if (xt >= 0 && yt >= 0 && zt >= 0 && xt < w && yt < h && zt < d) {
                            position[0] = x - sx1Half;
                            position[1] = y - sy1Half;
                            position[2] = z - sz1Half;
                            randomAccess.setPosition(position);
                            float s1 = (float)DOM.computeSum2(sx1, sy1, sz1, (LocalizableByDimCursor<LongType>)randomAccess) / d1;
                            position[0] = x - sx2Half;
                            position[1] = y - sy2Half;
                            position[2] = z - sz2Half;
                            randomAccess.setPosition(position);
                            float s2 = (float)DOM.computeSum2(sx2, sy2, sz2, (LocalizableByDimCursor<LongType>)randomAccess) / d2;
                            result.set(s2 - s1);
                            continue;
                        }
                        result.set(0.0f);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    public static final long computeSum2(int vX, int vY, int vZ, LocalizableByDimCursor<LongType> randomAccess) {
        long sum = -((LongType)randomAccess.getType()).get();
        randomAccess.move(vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(vY, 1);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(-vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(vZ, 2);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(-vY, 1);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(-vX, 0);
        return sum += ((LongType)randomAccess.getType()).get();
    }

    public static final long computeSum(int fromX, int fromY, int fromZ, int vX, int vY, int vZ, LocalizableByDimCursor<LongType> randomAccess) {
        randomAccess.setPosition(fromX, 0);
        randomAccess.setPosition(fromY, 1);
        randomAccess.setPosition(fromZ, 2);
        long sum = -((LongType)randomAccess.getType()).get();
        randomAccess.move(vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(vY, 1);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(-vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(vZ, 2);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(vX, 0);
        sum += ((LongType)randomAccess.getType()).get();
        randomAccess.move(-vY, 1);
        sum += -((LongType)randomAccess.getType()).get();
        randomAccess.move(-vX, 0);
        return sum += ((LongType)randomAccess.getType()).get();
    }

    public static final void computeMinMax(Image<FloatType> img, FloatType min, FloatType max) {
        min.set(Float.MAX_VALUE);
        max.set(Float.MIN_VALUE);
        for (FloatType t : img) {
            float value = t.get();
            if (value > max.get()) {
                max.set(value);
            }
            if (!(value < min.get())) continue;
            min.set(value);
        }
    }

    public static Image<FloatType> computeContentBasedGauss(Image<FloatType> img, int fusionSigma1, int fusionSigma2, float zStretching) {
        double[] k1 = new double[img.getNumDimensions()];
        double[] k2 = new double[img.getNumDimensions()];
        for (int d = 0; d < img.getNumDimensions() - 1; ++d) {
            k1[d] = fusionSigma1;
            k2[d] = fusionSigma2;
        }
        k1[img.getNumDimensions() - 1] = (float)fusionSigma1 / zStretching;
        k2[img.getNumDimensions() - 1] = (float)fusionSigma2 / zStretching;
        Image kernel1 = FourierConvolution.createGaussianKernel((ContainerFactory)new ArrayContainerFactory(), (double[])k1);
        Image kernel2 = FourierConvolution.createGaussianKernel((ContainerFactory)new ArrayContainerFactory(), (double[])k2);
        System.out.println(new Date(System.currentTimeMillis()) + " conv1");
        FourierConvolution fftConv1 = new FourierConvolution(img, kernel1);
        fftConv1.process();
        Image conv1 = fftConv1.getResult();
        fftConv1.close();
        fftConv1 = null;
        System.out.println(new Date(System.currentTimeMillis()) + " comp");
        Cursor cursorImg = img.createCursor();
        Cursor cursorConv = conv1.createCursor();
        while (cursorImg.hasNext()) {
            cursorImg.fwd();
            cursorConv.fwd();
            float diff = ((FloatType)cursorImg.getType()).get() - ((FloatType)cursorConv.getType()).get();
            ((FloatType)cursorConv.getType()).set(diff * diff);
        }
        System.out.println(new Date(System.currentTimeMillis()) + " conv2");
        FourierConvolution fftConv2 = new FourierConvolution(conv1, kernel2);
        fftConv2.process();
        Image gaussContent = fftConv2.getResult();
        fftConv2.close();
        fftConv2 = null;
        kernel1.close();
        kernel2.close();
        conv1.close();
        ViewDataBeads.normalizeImage((Image<FloatType>)gaussContent);
        return gaussContent;
    }

    public static Image<FloatType> computeContentBasedWeighting(Image<FloatType> img, int fusionSigma1, int fusionSigma2, float zStretching) {
        int rxy1 = Math.round(fusionSigma1);
        int rxy2 = Math.round(fusionSigma2);
        int rz1 = Math.round((float)fusionSigma1 / zStretching);
        int rz2 = Math.round((float)fusionSigma2 / zStretching);
        Image<LongType> integralImg = IntegralImage3d.compute(img);
        Image imgConv = img.createNewImage();
        DOM.meanMirror(integralImg, (Image<FloatType>)imgConv, rxy1 * 2 + 1, rxy1 * 2 + 1, rz1 * 2 + 1);
        Cursor cursorImg = img.createCursor();
        Cursor cursorConv = imgConv.createCursor();
        while (cursorImg.hasNext()) {
            cursorImg.fwd();
            cursorConv.fwd();
            float diff = ((FloatType)cursorImg.getType()).get() - ((FloatType)cursorConv.getType()).get();
            ((FloatType)cursorConv.getType()).set(diff * diff);
        }
        IntegralImage3d.computeIntegralImage(integralImg, (Image<FloatType>)imgConv);
        DOM.meanMirror(integralImg, (Image<FloatType>)imgConv, rxy2 * 2 + 1, rxy2 * 2 + 1, rz2 * 2 + 1);
        integralImg.close();
        ViewDataBeads.normalizeImage((Image<FloatType>)imgConv);
        return imgConv;
    }

    public static void main(String[] args) {
        new ImageJ();
        Image img = LOCI.openLOCIFloatType((String)"/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM/spim_TL18_Angle0.tif", (ContainerFactory)new ArrayContainerFactory());
        long ti = System.currentTimeMillis();
        Image<FloatType> cb = DOM.computeContentBasedWeighting((Image<FloatType>)img, 20, 40, 2.73f);
        System.out.println("Content-based took: " + (System.currentTimeMillis() - ti) + " ms.");
        ImageJFunctions.show(cb);
        SimpleMultiThreading.threadHaltUnClean();
        IntegralImageLong intImg = new IntegralImageLong(img, (Converter)new Converter<FloatType, LongType>(){

            public void convert(FloatType input, LongType output) {
                output.set((long)Util.round((float)input.get()));
            }
        });
        intImg.process();
        Image integralImg = intImg.getResult();
        DOM.meanMirror((Image<LongType>)integralImg, (Image<FloatType>)img, 31, 31, 11);
        ImageJFunctions.show((Image)img);
        SimpleMultiThreading.threadHaltUnClean();
        FloatType min = new FloatType();
        FloatType max = new FloatType();
        DOM.computeMinMax((Image<FloatType>)img, min, max);
        Image domImg = img.createNewImage();
        long t = 0L;
        int num = 10;
        for (int i = 0; i < num; ++i) {
            long t1 = System.currentTimeMillis();
            DOM.computeDifferencOfMean3d((Image<LongType>)integralImg, (Image<FloatType>)domImg, 3, 3, 3, 5, 5, 5, min.get(), max.get());
            long t2 = System.currentTimeMillis();
            t += t2 - t1;
            System.out.println("run " + i + ": " + (t2 - t1) + " ms.");
        }
        System.out.println("avg: " + t / (long)num + " ms.");
    }
}

