/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import net.imglib2.type.label.ComparableLabelMultisetEntryList;
import net.imglib2.type.label.Label;
import net.imglib2.type.label.LabelMultisetEntry;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.label.LongMappedAccess;
import net.imglib2.type.label.LongMappedAccessData;
import net.imglib2.type.label.MappedObjectArrayList;
import net.imglib2.type.label.Multiset;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class LabelMultisetEntryList
extends MappedObjectArrayList<LabelMultisetEntry, LongMappedAccess> {
    public LabelMultisetEntryList() {
        super(LabelMultisetEntry.type);
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        int hash1 = 13;
        int hash2 = 31;
        int hash = hash1;
        for (LabelMultisetEntry e : this) {
            builder.append(hash).append((Object)e).append(e.getCount() * hash);
            hash = hash1;
            hash1 = hash2;
            hash2 = hash;
            hash = hash1;
        }
        return builder.toHashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LabelMultisetEntryList)) {
            return false;
        }
        LabelMultisetEntryList other = (LabelMultisetEntryList)o;
        if (other.size() != this.size()) {
            return false;
        }
        ComparableLabelMultisetEntryList thisComparable = new ComparableLabelMultisetEntryList(this);
        ComparableLabelMultisetEntryList otherComparable = new ComparableLabelMultisetEntryList(other);
        return thisComparable.compareTo(otherComparable) == 0;
    }

    public LabelMultisetEntryList(int capacity) {
        super(LabelMultisetEntry.type, capacity);
    }

    public LabelMultisetEntryList(LongMappedAccessData data, long baseOffset) {
        super(LabelMultisetEntry.type, data, baseOffset);
        this.sortById();
    }

    protected int multisetSize() {
        int size = 0;
        for (LabelMultisetEntry e : this) {
            size += e.getCount();
        }
        return size;
    }

    @Override
    public boolean add(LabelMultisetEntry obj) {
        LabelMultisetEntry ref = (LabelMultisetEntry)this.createRef();
        this.add(obj, ref);
        this.releaseRef(ref);
        return true;
    }

    @Override
    public boolean add(LabelMultisetEntry obj, LabelMultisetEntry ref) {
        int idx = this.binarySearch(obj.getId(), ref);
        if (idx >= 0) {
            LabelMultisetEntry entry = this.get(idx, ref);
            entry.setCount(entry.getCount() + obj.getCount());
        } else {
            this.add(-(idx + 1), obj, ref);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends LabelMultisetEntry> c) {
        LabelMultisetEntry ref = (LabelMultisetEntry)this.createRef();
        for (LabelMultisetEntry labelMultisetEntry : c) {
            this.add(labelMultisetEntry, ref);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends LabelMultisetEntry> c, LabelMultisetEntry ref) {
        for (LabelMultisetEntry labelMultisetEntry : c) {
            this.add(labelMultisetEntry, ref);
        }
        return true;
    }

    public int binarySearch(long id) {
        return this.binarySearch(id, 0, this.size());
    }

    public int binarySearch(long id, LabelMultisetEntry ref) {
        return this.binarySearch(id, 0, this.size(), ref);
    }

    public int binarySearch(long id, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.size()) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        LabelMultisetEntry ref = (LabelMultisetEntry)this.createRef();
        int idx = this.binarySearch(id, fromIndex, toIndex, ref);
        this.releaseRef(ref);
        return idx;
    }

    public int binarySearch(long id, int fromIndex, int toIndex, LabelMultisetEntry ref) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.size()) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midVal = this.get(mid, ref).getId();
            if (midVal < id) {
                low = mid + 1;
                continue;
            }
            if (midVal > id) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void sortById() {
        this.sort((o1, o2) -> {
            long i1 = o1.getId();
            long i2 = o2.getId();
            return Long.compare(i1, i2);
        });
    }

    public void sortByCount() {
        this.sort((o1, o2) -> {
            int i2;
            int i1 = o1.getCount();
            int countCompare = Integer.compare(i1, i2 = o2.getCount());
            if (countCompare == 0) {
                return Long.compare(o2.getId(), o1.getId());
            }
            return countCompare;
        });
    }

    public void mergeConsecutiveEntries() {
        int oldSize = this.size();
        if (oldSize < 2) {
            return;
        }
        int newSize = oldSize;
        LabelMultisetEntry oldTail = (LabelMultisetEntry)this.createRef();
        LabelMultisetEntry newTail = (LabelMultisetEntry)this.createRef();
        int newPos = 0;
        this.get(newPos, newTail);
        for (int oldPos = 1; oldPos < oldSize; ++oldPos) {
            this.get(oldPos, oldTail);
            if (oldTail.getId() == newTail.getId()) {
                newTail.setCount(newTail.getCount() + oldTail.getCount());
                --newSize;
                continue;
            }
            this.get(++newPos, newTail);
            if (newPos == oldPos) continue;
            newTail.set(oldTail);
        }
        this.setSize(newSize);
    }

    public void mergeWith(LabelMultisetEntryList list) {
        LabelMultisetEntry e2;
        LabelMultisetEntry e1;
        block10: {
            if (list.isEmpty()) {
                return;
            }
            if (this.isEmpty()) {
                for (LabelMultisetEntry e : list) {
                    this.add(e);
                }
                return;
            }
            e1 = (LabelMultisetEntry)this.createRef();
            e2 = (LabelMultisetEntry)this.createRef();
            int i = 0;
            int j = 0;
            long id1 = this.get(i, e1).getId();
            long id2 = list.get(j, e2).getId();
            block1: while (true) {
                if (id1 == id2) {
                    e1.setCount(e1.getCount() + e2.getCount());
                    if (++j < list.size()) {
                        id2 = list.get(j, e2).getId();
                        continue;
                    }
                    break block10;
                }
                if (id2 < id1) {
                    this.add(i, e2);
                    this.get(++i, e1).getId();
                    if (++j < list.size()) {
                        id2 = list.get(j, e2).getId();
                        continue;
                    }
                    break block10;
                }
                while (++i < this.size()) {
                    id1 = this.get(i, e1).getId();
                    if (id2 > id1) continue;
                    continue block1;
                }
                break;
            }
            while (j < list.size()) {
                this.add(list.get(j, e2));
                ++j;
            }
        }
        this.releaseRef(e2);
        this.releaseRef(e1);
    }

    public void mergeWith(Multiset<Label> multiset) {
        this.mergeWith(multiset.entrySet());
    }

    public void mergeWith(Set<LabelMultisetType.Entry<Label>> entrySet) {
        LabelMultisetEntry e1;
        block10: {
            if (entrySet.isEmpty()) {
                return;
            }
            if (this.isEmpty()) {
                LabelMultisetEntry e12 = (LabelMultisetEntry)this.createRef();
                this.ensureCapacity(entrySet.size());
                this.setSize(entrySet.size());
                int i = 0;
                for (LabelMultisetType.Entry<Label> e : entrySet) {
                    this.get(i++, e12);
                    e12.setId(e.getElement().id());
                    e12.setCount(e.getCount());
                }
                this.releaseRef(e12);
                return;
            }
            e1 = (LabelMultisetEntry)this.createRef();
            Iterator<LabelMultisetType.Entry<Label>> iter = entrySet.iterator();
            LabelMultisetType.Entry<Label> e2 = iter.next();
            int i = 0;
            long id1 = this.get(i, e1).getId();
            long id2 = e2.getElement().id();
            block1: while (true) {
                if (id1 == id2) {
                    e1.setCount(e1.getCount() + e2.getCount());
                    if (iter.hasNext()) {
                        e2 = iter.next();
                        id2 = e2.getElement().id();
                        continue;
                    }
                    break block10;
                }
                if (id2 < id1) {
                    this.add(i, e1);
                    e1.setId(id2);
                    e1.setCount(e2.getCount());
                    this.get(++i, e1).getId();
                    if (iter.hasNext()) {
                        e2 = iter.next();
                        id2 = e2.getElement().id();
                        continue;
                    }
                    break block10;
                }
                while (++i < this.size()) {
                    id1 = this.get(i, e1).getId();
                    if (id2 > id1) continue;
                    continue block1;
                }
                break;
            }
            while (true) {
                this.add(e1);
                this.get(i++, e1);
                e1.setId(id2);
                e1.setCount(e2.getCount());
                if (!iter.hasNext()) break;
                e2 = iter.next();
                id2 = e2.getElement().id();
            }
        }
        this.releaseRef(e1);
    }
}

