/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.renjin.compiler.ir.tac.expressions.IRThunk;

public class ThunkMap {
    private Map<IRThunk, String> map = Maps.newHashMap();
    private String classPrefix = "r/compiled/runtime/";

    public ThunkMap(String classPrefix) {
        this.classPrefix = classPrefix;
    }

    public String getClassName(IRThunk thunk) {
        String className = this.map.get(thunk);
        if (className == null) {
            className = this.classPrefix + this.map.size();
            this.map.put(thunk, className);
        }
        return className;
    }

    public Set<Map.Entry<IRThunk, String>> entrySet() {
        return this.map.entrySet();
    }

    public Set<IRThunk> keySet() {
        return this.map.keySet();
    }
}

