/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.internals.distributions;

public class MersenneTwister {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int GNU_R_SEED_SCRAMBLE_CONSTANT = 50;
    private int[] stateVector = new int[625];
    private int stateVectorIndex = 625;

    private static int TEMPERING_SHIFT_U(int y) {
        return y >>> 11;
    }

    private static int TEMPERING_SHIFT_S(int y) {
        return y << 7;
    }

    private static int TEMPERING_SHIFT_T(int y) {
        return y << 15;
    }

    private static int TEMPERING_SHIFT_L(int y) {
        return y >>> 18;
    }

    public MersenneTwister() {
        this.setSeed(System.currentTimeMillis());
    }

    public MersenneTwister(long seed2) {
        this.setSeed(seed2);
    }

    public void setSeed(long seed2) {
        int j;
        int s = (int)(seed2 & 0xFFFFL);
        for (j = 0; j < 50; ++j) {
            s = 69069 * s + 1;
        }
        for (j = 0; j < 625; ++j) {
            this.stateVector[j] = s = 69069 * s + 1;
        }
        this.stateVector[0] = 624;
        boolean notallzero = true;
        for (j = 1; j <= 624; ++j) {
            if (this.stateVector[j] == 0) continue;
            notallzero = false;
            break;
        }
        if (notallzero) {
            this.setSeed(System.currentTimeMillis());
        }
    }

    public double nextDouble() {
        int y;
        int[] mag01 = new int[]{0, -1727483681};
        this.stateVectorIndex = this.stateVector[0];
        if (this.stateVectorIndex >= 624) {
            int kk;
            for (kk = 1; kk < 228; ++kk) {
                y = this.stateVector[kk] & Integer.MIN_VALUE | this.stateVector[kk + 1] & Integer.MAX_VALUE;
                this.stateVector[kk] = this.stateVector[kk + 397] ^ y >>> 1 ^ mag01[y & 1];
            }
            while (kk < 624) {
                y = this.stateVector[kk] & Integer.MIN_VALUE | this.stateVector[kk + 1] & Integer.MAX_VALUE;
                this.stateVector[kk] = this.stateVector[kk + -227] ^ y >>> 1 ^ mag01[y & 1];
                ++kk;
            }
            y = this.stateVector[624] & Integer.MIN_VALUE | this.stateVector[1] & Integer.MAX_VALUE;
            this.stateVector[624] = this.stateVector[397] ^ y >>> 1 ^ mag01[y & 1];
            this.stateVectorIndex = 0;
        }
        y = this.stateVector[this.stateVectorIndex + 1];
        y ^= MersenneTwister.TEMPERING_SHIFT_U(y);
        y ^= MersenneTwister.TEMPERING_SHIFT_S(y) & 0x9D2C5680;
        y ^= MersenneTwister.TEMPERING_SHIFT_T(y) & 0xEFC60000;
        y ^= MersenneTwister.TEMPERING_SHIFT_L(y);
        this.stateVector[0] = ++this.stateVectorIndex;
        long yUnsigned = (long)y & 0xFFFFFFFFL;
        return (double)yUnsigned * 2.3283064365386963E-10;
    }
}

