/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.functions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.List;
import net.thisptr.jackson.jq.Expression;
import net.thisptr.jackson.jq.Function;
import net.thisptr.jackson.jq.PathOutput;
import net.thisptr.jackson.jq.Scope;
import net.thisptr.jackson.jq.Version;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.internal.BuiltinFunction;
import net.thisptr.jackson.jq.internal.misc.Preconditions;
import net.thisptr.jackson.jq.path.Path;

public abstract class MathFunction
implements Function {
    @Override
    public void apply(Scope scope, List<Expression> args, JsonNode in, Path ipath, PathOutput output, Version version) throws JsonQueryException {
        Preconditions.checkInputType("mathfunc", in, JsonNodeType.NUMBER);
        output.emit((JsonNode)new DoubleNode(this.f(in.asDouble())), null);
    }

    protected abstract double f(double var1);

    @BuiltinFunction(value={"log2/0"})
    public static class Log2Function
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.log10(v) / Math.log10(2.0);
        }
    }

    @BuiltinFunction(value={"sqrt/0"})
    public static class SqrtFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sqrt(v);
        }
    }

    @BuiltinFunction(value={"sin/0"})
    public static class SinFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.sin(v);
        }
    }

    @BuiltinFunction(value={"floor/0"})
    public static class FloorFunction
    extends MathFunction {
        @Override
        protected double f(double f) {
            return Math.floor(f);
        }
    }

    @BuiltinFunction(value={"cos/0"})
    public static class CosFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.cos(v);
        }
    }

    @BuiltinFunction(value={"atan/0"})
    public static class AtanFunction
    extends MathFunction {
        @Override
        protected double f(double v) {
            return Math.atan(v);
        }
    }
}

