/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.compat;

import ij.IJ;
import ij.ImageJ;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import org.scijava.event.EventHandler;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.service.event.ServicesLoadedEvent;
import sc.fiji.compat.FijiService;
import sc.fiji.compat.FileDialogDecorator;
import sc.fiji.compat.JFileChooserDecorator;
import sc.fiji.compat.MenuRefresher;

@Plugin(type=Service.class)
public class DefaultFijiService
extends AbstractService
implements FijiService {
    public void actuallyInitialize() {
        FileDialogDecorator.registerAutomaticDecorator();
        JFileChooserDecorator.registerAutomaticDecorator();
        DefaultFijiService.setAWTAppClassName("fiji-Main");
        ImageJ ij = IJ.getInstance();
        if (ij != null) {
            new MenuRefresher().run();
            new Thread(){

                @Override
                public void run() {
                    String[] ijArgs = ImageJ.getArgs();
                    if (ijArgs != null && ijArgs.length > 3) {
                        return;
                    }
                }
            }.start();
        }
    }

    @EventHandler
    protected void onEvent(ServicesLoadedEvent evt) {
        this.actuallyInitialize();
    }

    private static boolean setAWTAppClassName(String appName) {
        if (!GraphicsEnvironment.isHeadless()) {
            try {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (toolkit == null) {
                    return false;
                }
                Class<?> clazz = toolkit.getClass();
                if (!"sun.awt.X11.XToolkit".equals(clazz.getName())) {
                    return false;
                }
                Field field = clazz.getDeclaredField("awtAppClassName");
                field.setAccessible(true);
                field.set(toolkit, appName);
                return true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }
}

