/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.io.IOException;
import java.net.URL;
import org.scijava.ui.swing.script.TextEditor;

public class MacroFunctions {
    public final String MACRO_FUNCTIONS_URL = "http://imagej.net/developer/macro/functions.html";
    private final TextEditor editor;

    public MacroFunctions(TextEditor editor) {
        this.editor = editor;
    }

    public void openHelp(String name) throws IOException {
        String functionName;
        String url = "http://imagej.net/developer/macro/functions.html";
        if (name != null && (functionName = this.startsWithIdentifier(name)) != null) {
            url = url + "#" + functionName;
        }
        this.editor.getPlatformService().open(new URL(url));
    }

    protected String startsWithIdentifier(String text) {
        int end;
        int start;
        if (text == null) {
            return null;
        }
        char[] array = text.toCharArray();
        for (start = 0; start < array.length && Character.isWhitespace(array[start]); ++start) {
        }
        if (start >= array.length || !Character.isJavaIdentifierStart(array[start])) {
            return null;
        }
        for (end = start + 1; end < array.length && Character.isJavaIdentifierPart(array[end]); ++end) {
        }
        return new String(array, start, end - start);
    }
}

