/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.ModelChangeEvent;
import fiji.plugin.trackmate.ModelChangeListener;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotCollection;
import fiji.plugin.trackmate.features.EdgeFeatureCalculator;
import fiji.plugin.trackmate.features.SpotFeatureCalculator;
import fiji.plugin.trackmate.features.TrackFeatureCalculator;
import java.util.ArrayList;
import net.imglib2.algorithm.MultiThreaded;
import org.jgrapht.graph.DefaultWeightedEdge;

public class ModelFeatureUpdater
implements ModelChangeListener,
MultiThreaded {
    private final SpotFeatureCalculator spotFeatureCalculator;
    private final EdgeFeatureCalculator edgeFeatureCalculator;
    private final TrackFeatureCalculator trackFeatureCalculator;
    private final Model model;
    private int numThreads;

    public ModelFeatureUpdater(Model model, Settings settings) {
        this.model = model;
        boolean doLogIt = false;
        this.spotFeatureCalculator = new SpotFeatureCalculator(model, settings, false);
        this.edgeFeatureCalculator = new EdgeFeatureCalculator(model, settings, false);
        this.trackFeatureCalculator = new TrackFeatureCalculator(model, settings, false);
        model.addModelChangeListener(this);
        this.setNumThreads();
    }

    @Override
    public void modelChanged(ModelChangeEvent event) {
        if (event.getEventID() != 8) {
            return;
        }
        ArrayList<Spot> spots = new ArrayList<Spot>(event.getSpots().size());
        for (Spot spot : event.getSpots()) {
            if (event.getSpotFlag(spot) == 1) continue;
            spots.add(spot);
        }
        SpotCollection sc = SpotCollection.fromCollection(spots);
        ArrayList<DefaultWeightedEdge> edges = new ArrayList<DefaultWeightedEdge>(event.getEdges().size());
        for (DefaultWeightedEdge edge : event.getEdges()) {
            if (event.getEdgeFlag(edge) == 5) continue;
            edges.add(edge);
        }
        this.spotFeatureCalculator.computeSpotFeatures(sc, false);
        this.edgeFeatureCalculator.computeEdgesFeatures(edges, false);
        this.trackFeatureCalculator.computeTrackFeatures(event.getTrackUpdated(), false);
    }

    public void quit() {
        this.model.removeModelChangeListener(this);
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads() {
        this.setNumThreads(Runtime.getRuntime().availableProcessors());
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
        this.spotFeatureCalculator.setNumThreads(numThreads);
        this.edgeFeatureCalculator.setNumThreads(numThreads);
        this.trackFeatureCalculator.setNumThreads(numThreads);
    }
}

