/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.spot;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import Jama.SingularValueDecomposition;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.SpotRoi;
import fiji.plugin.trackmate.features.spot.AbstractSpotFeatureAnalyzer;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Util;

public class SpotFitEllipseAnalyzer<T extends RealType<T>>
extends AbstractSpotFeatureAnalyzer<T> {
    private final boolean is2D;
    private static final double MACHEPS = 2.2204E-16;

    public SpotFitEllipseAnalyzer(boolean is2D) {
        this.is2D = is2D;
    }

    @Override
    public void process(Spot spot) {
        double aspectRatio;
        double theta;
        double minor;
        double major;
        double y0;
        double x0;
        if (this.is2D) {
            SpotRoi roi = spot.getRoi();
            if (roi != null) {
                double[] Q = SpotFitEllipseAnalyzer.fitEllipse(roi.x, roi.y);
                double[] A = SpotFitEllipseAnalyzer.quadraticToCartesian(Q);
                x0 = A[0];
                y0 = A[1];
                major = A[2];
                minor = A[3];
                theta = A[4];
                aspectRatio = major / minor;
            } else {
                double radius = spot.getFeature("RADIUS");
                x0 = 0.0;
                y0 = 0.0;
                major = radius;
                minor = radius;
                theta = 0.0;
                aspectRatio = 1.0;
            }
        } else {
            x0 = Double.NaN;
            y0 = Double.NaN;
            major = Double.NaN;
            minor = Double.NaN;
            theta = Double.NaN;
            aspectRatio = Double.NaN;
        }
        spot.putFeature("ELLIPSE_X0", x0);
        spot.putFeature("ELLIPSE_Y0", y0);
        spot.putFeature("ELLIPSE_MAJOR", major);
        spot.putFeature("ELLIPSE_MINOR", minor);
        spot.putFeature("ELLIPSE_THETA", theta);
        spot.putFeature("ELLIPSE_ASPECTRATIO", aspectRatio);
    }

    private static double[] fitEllipse(double[] x, double[] y) {
        int nPoints = x.length;
        double[] centroid = SpotFitEllipseAnalyzer.getCentroid(x, y);
        double xC = centroid[0];
        double yC = centroid[1];
        double[][] d1 = new double[nPoints][3];
        for (int i = 0; i < nPoints; ++i) {
            double xixC = x[i] - xC;
            double yiyC = y[i] - yC;
            d1[i][0] = xixC * xixC;
            d1[i][1] = xixC * yiyC;
            d1[i][2] = yiyC * yiyC;
        }
        Matrix D1 = new Matrix(d1);
        double[][] d2 = new double[nPoints][3];
        for (int i = 0; i < nPoints; ++i) {
            d2[i][0] = x[i] - xC;
            d2[i][1] = y[i] - yC;
            d2[i][2] = 1.0;
        }
        Matrix D2 = new Matrix(d2);
        Matrix S1 = D1.transpose().times(D1);
        Matrix S2 = D1.transpose().times(D2);
        Matrix S3 = D2.transpose().times(D2);
        Matrix T = SpotFitEllipseAnalyzer.pinv(S3).times(-1.0).times(S2.transpose());
        Matrix M = S1.plus(S2.times(T));
        double[][] m = M.getArray();
        double[][] n = new double[][]{{m[2][0] / 2.0, m[2][1] / 2.0, m[2][2] / 2.0}, {-m[1][0], -m[1][1], -m[1][2]}, {m[0][0] / 2.0, m[0][1] / 2.0, m[0][2] / 2.0}};
        Matrix N = new Matrix((double[][])n);
        EigenvalueDecomposition E = N.eig();
        Matrix eVec = E.getV();
        Matrix R1 = eVec.getMatrix(0, 0, 0, 2);
        Matrix R2 = eVec.getMatrix(1, 1, 0, 2);
        Matrix R3 = eVec.getMatrix(2, 2, 0, 2);
        Matrix cond = R1.times(4.0).arrayTimes(R3).minus(R2.arrayTimes(R2));
        int f = 0;
        for (int i = 0; i < 3; ++i) {
            if (!(cond.get(0, i) > 0.0)) continue;
            f = i;
            break;
        }
        Matrix A1 = eVec.getMatrix(0, 2, f, f);
        Matrix A = new Matrix(6, 1);
        A.setMatrix(0, 2, 0, 0, A1);
        A.setMatrix(3, 5, 0, 0, T.times(A1));
        double[] a = A.getColumnPackedCopy();
        double a4 = a[3] - 2.0 * a[0] * xC - a[1] * yC;
        double a5 = a[4] - 2.0 * a[2] * yC - a[1] * xC;
        double a6 = a[5] + a[0] * xC * xC + a[2] * yC * yC + a[1] * xC * yC - a[3] * xC - a[4] * yC;
        A.set(3, 0, a4);
        A.set(4, 0, a5);
        A.set(5, 0, a6);
        A = A.times(1.0 / A.normF());
        return A.getColumnPackedCopy();
    }

    private static double[] getCentroid(double[] x, double[] y) {
        return new double[]{Util.average((double[])x), Util.average((double[])y)};
    }

    private static final double[] quadraticToCartesian(double[] Q) {
        double A = Q[0];
        double B = Q[1];
        double C = Q[2];
        double D = Q[3];
        double E = Q[4];
        double F = Q[5];
        double term1 = 2.0 * (A * E * E + C * D * D - B * D * E + (B * B - 4.0 * A * C) * F);
        double term2 = A + C;
        double term3 = Math.sqrt((A - C) * (A - C) + B * B);
        double term4 = B * B - 4.0 * A * C;
        double a = -Math.sqrt(term1 * (term2 + term3)) / term4;
        double b = -Math.sqrt(term1 * (term2 - term3)) / term4;
        double x0 = (2.0 * C * D - B * E) / term4;
        double y0 = (2.0 * A * E - B * D) / term4;
        double theta = B != 0.0 ? Math.atan(1.0 / B * (C - A - term3)) : (A < 0.0 ? 0.0 : 1.5707963267948966);
        if (b > a) {
            double btemp = b;
            b = a;
            a = btemp;
            if ((theta += 1.5707963267948966) > Math.PI) {
                theta -= Math.PI;
            }
        }
        return new double[]{x0, y0, a, b, theta};
    }

    public static Matrix pinv(Matrix x) {
        int cols;
        int rows = x.getRowDimension();
        if (rows < (cols = x.getColumnDimension())) {
            Matrix result = SpotFitEllipseAnalyzer.pinv(x.transpose());
            if (result != null) {
                result = result.transpose();
            }
            return result;
        }
        SingularValueDecomposition svdX = new SingularValueDecomposition(x);
        if (svdX.rank() < 1) {
            return null;
        }
        double[] singularValues = svdX.getSingularValues();
        double tol = (double)Math.max(rows, cols) * singularValues[0] * 2.2204E-16;
        double[] singularValueReciprocals = new double[singularValues.length];
        for (int i = 0; i < singularValues.length; ++i) {
            if (!(Math.abs(singularValues[i]) >= tol)) continue;
            singularValueReciprocals[i] = 1.0 / singularValues[i];
        }
        double[][] u = svdX.getU().getArray();
        double[][] v = svdX.getV().getArray();
        int min = Math.min(cols, u[0].length);
        double[][] inverse = new double[cols][rows];
        for (int i = 0; i < cols; ++i) {
            for (int j = 0; j < u.length; ++j) {
                for (int k = 0; k < min; ++k) {
                    double[] dArray = inverse[i];
                    int n = j;
                    dArray[n] = dArray[n] + v[i][k] * singularValueReciprocals[k] * u[j][k];
                }
            }
        }
        return new Matrix(inverse);
    }
}

