/*
 * Decompiled with CFR 0.152.
 */
package fiji.expressionparser;

import fiji.expressionparser.ImgLibNumberFactory;
import fiji.expressionparser.ImgLibOperatorSet;
import fiji.expressionparser.function.ImgLibAbs;
import fiji.expressionparser.function.ImgLibArcCosine;
import fiji.expressionparser.function.ImgLibArcSine;
import fiji.expressionparser.function.ImgLibArcTangent;
import fiji.expressionparser.function.ImgLibArcTangent2;
import fiji.expressionparser.function.ImgLibCeil;
import fiji.expressionparser.function.ImgLibCosine;
import fiji.expressionparser.function.ImgLibDithering;
import fiji.expressionparser.function.ImgLibExp;
import fiji.expressionparser.function.ImgLibFloor;
import fiji.expressionparser.function.ImgLibFunction;
import fiji.expressionparser.function.ImgLibGaussConv;
import fiji.expressionparser.function.ImgLibLog;
import fiji.expressionparser.function.ImgLibModulus;
import fiji.expressionparser.function.ImgLibNormalize;
import fiji.expressionparser.function.ImgLibPower;
import fiji.expressionparser.function.ImgLibRound;
import fiji.expressionparser.function.ImgLibSine;
import fiji.expressionparser.function.ImgLibSquareRoot;
import fiji.expressionparser.function.ImgLibTangent;
import java.util.ArrayList;
import net.imglib2.type.numeric.RealType;
import org.nfunk.jep.JEP;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.type.NumberFactory;

public class ImgLibParser<T extends RealType<T>>
extends JEP {
    public ImgLibParser() {
        this.opSet = new ImgLibOperatorSet();
        this.numberFactory = new ImgLibNumberFactory();
    }

    public ImgLibParser(JEP j) {
        super(j);
        this.opSet = new ImgLibOperatorSet();
        this.numberFactory = new ImgLibNumberFactory();
    }

    public ImgLibParser(boolean traverseIn, boolean allowUndeclaredIn, boolean implicitMulIn, NumberFactory numberFactoryIn) {
        super(traverseIn, allowUndeclaredIn, implicitMulIn, numberFactoryIn);
        this.opSet = new ImgLibOperatorSet();
    }

    public void addStandardFunctions() {
        ImgLibSine sine = new ImgLibSine();
        ImgLibCosine cosine = new ImgLibCosine();
        ImgLibTangent tangent = new ImgLibTangent();
        ImgLibArcSine arcsine = new ImgLibArcSine();
        ImgLibArcCosine arccosine = new ImgLibArcCosine();
        ImgLibArcTangent arctangent = new ImgLibArcTangent();
        ImgLibArcTangent2 arctangent2 = new ImgLibArcTangent2();
        ImgLibLog log = new ImgLibLog();
        ImgLibExp exp = new ImgLibExp();
        ImgLibPower power = new ImgLibPower();
        ImgLibSquareRoot sqrt = new ImgLibSquareRoot();
        ImgLibAbs abs = new ImgLibAbs();
        ImgLibModulus modulus = new ImgLibModulus();
        ImgLibCeil ceil = new ImgLibCeil();
        ImgLibFloor floor = new ImgLibFloor();
        ImgLibRound round = new ImgLibRound();
        ArrayList<PostfixMathCommand> il_funs = new ArrayList<PostfixMathCommand>();
        il_funs.add(sine);
        il_funs.add(cosine);
        il_funs.add(tangent);
        il_funs.add(arcsine);
        il_funs.add(arccosine);
        il_funs.add(arctangent);
        il_funs.add(arctangent2);
        il_funs.add(log);
        il_funs.add(exp);
        il_funs.add(power);
        il_funs.add(sqrt);
        il_funs.add(abs);
        il_funs.add(modulus);
        il_funs.add(ceil);
        il_funs.add(floor);
        il_funs.add(round);
        for (ImgLibFunction imgLibFunction : il_funs) {
            this.funTab.put(imgLibFunction.getFunctionString(), (PostfixMathCommandI)imgLibFunction);
        }
    }

    public void addImgLibAlgorithms() {
        ImgLibGaussConv gauss = new ImgLibGaussConv();
        ImgLibNormalize normalizer = new ImgLibNormalize();
        ImgLibDithering dither = new ImgLibDithering();
        ArrayList<PostfixMathCommand> il_algos = new ArrayList<PostfixMathCommand>();
        il_algos.add(gauss);
        il_algos.add(normalizer);
        il_algos.add(dither);
        for (ImgLibFunction imgLibFunction : il_algos) {
            this.funTab.put(imgLibFunction.getFunctionString(), (PostfixMathCommandI)imgLibFunction);
        }
    }
}

