/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryStripArray;
import org.scijava.java3d.IndexedGeometryArray;
import org.scijava.java3d.J3DBuffer;
import org.scijava.java3d.internal.BufferWrapper;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.GeometryState;
import org.scijava.vecmath.Color3b;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4b;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.TexCoord2f;
import org.scijava.vecmath.TexCoord3f;
import org.scijava.vecmath.Vector3f;

public abstract class GeometryArrayState
extends GeometryState {
    protected int vertexFormat;
    protected int vertexCount;
    protected int texCoordSetCount;
    protected int[] texCoordSetMap;
    private static final int FORMAT_NULL = 0;
    private static final int FORMAT_BYTE = 1;
    private static final int FORMAT_FLOAT = 2;
    private static final int FORMAT_DOUBLE = 3;
    private static final int FORMAT_3B = 4;
    private static final int FORMAT_4B = 5;
    private static final int FORMAT_2F = 6;
    private static final int FORMAT_3F = 7;
    private static final int FORMAT_4F = 8;
    private static final int FORMAT_2D = 9;
    private static final int FORMAT_3D = 10;

    public GeometryArrayState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        block107: {
            float[] textureCoords;
            J3DBuffer buf;
            boolean byRef;
            boolean nio;
            block109: {
                TexCoord2f[] tcoords;
                block108: {
                    Object[] data;
                    Object[] colors;
                    Buffer bb;
                    J3DBuffer buf2;
                    block106: {
                        super.writeObject(out);
                        boolean bl = nio = (this.vertexFormat & 0x800) != 0;
                        if ((this.vertexFormat & 0x100) == 0) break block106;
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            out.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                            if (!(this.node instanceof GeometryStripArray)) {
                                out.writeInt(((GeometryArray)this.node).getValidVertexCount());
                            }
                        }
                        if (nio) {
                            FloatBuffer x = (FloatBuffer)((GeometryArray)this.node).getInterleavedVertexBuffer().getBuffer();
                            float[] f = new float[x.limit()];
                            x.position(0);
                            x.get(f);
                            this.writeFloatArray(out, f);
                        } else {
                            this.writeFloatArray(out, ((GeometryArray)this.node).getInterleavedVertices());
                        }
                        break block107;
                    }
                    boolean bl = byRef = (this.vertexFormat & 0x80) != 0;
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        if (!byRef) {
                            out.writeInt(((GeometryArray)this.node).getInitialVertexIndex());
                        }
                        if (!(this.node instanceof GeometryStripArray)) {
                            out.writeInt(((GeometryArray)this.node).getValidVertexCount());
                        }
                    }
                    if ((this.vertexFormat & 0xC) == 12) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 2: {
                                        out.writeInt(1);
                                        bb = (ByteBuffer)buf2.getBuffer();
                                        byte[] bytes = new byte[bb.limit()];
                                        ((ByteBuffer)bb).position(0);
                                        ((ByteBuffer)bb).get(bytes);
                                        out.writeInt(bytes.length);
                                        out.write(bytes);
                                        break;
                                    }
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef4f() != null) {
                                out.writeInt(8);
                                colors = ((GeometryArray)this.node).getColorRef4f();
                                data = new float[colors.length * 4];
                                for (int i = 0; i < colors.length; ++i) {
                                    data[i * 4 + 0] = colors[i].x;
                                    data[i * 4 + 1] = colors[i].y;
                                    data[i * 4 + 2] = colors[i].z;
                                    data[i * 4 + 3] = colors[i].w;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                out.writeInt(1);
                                colors = ((GeometryArray)this.node).getColorRefByte();
                                out.writeInt(colors.length);
                                out.write((byte[])colors);
                            } else if (((GeometryArray)this.node).getColorRef4b() != null) {
                                out.writeInt(5);
                                colors = ((GeometryArray)this.node).getColorRef4b();
                                out.writeInt(colors.length);
                                data = new byte[colors.length * 4];
                                for (int i = 0; i < colors.length; ++i) {
                                    data[i * 4 + 0] = colors[i].x;
                                    data[i * 4 + 1] = colors[i].y;
                                    data[i * 4 + 2] = colors[i].z;
                                    data[i * 4 + 3] = colors[i].w;
                                }
                                out.write((byte[])data);
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            colors = new byte[this.vertexCount * 4];
                            ((GeometryArray)this.node).getColors(0, (byte[])colors);
                            out.write((byte[])colors);
                        }
                    } else if ((this.vertexFormat & 4) == 4) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialColorIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getColorRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 2: {
                                        out.writeInt(1);
                                        bb = (ByteBuffer)buf2.getBuffer();
                                        byte[] bytes = new byte[bb.limit()];
                                        ((ByteBuffer)bb).position(0);
                                        ((ByteBuffer)bb).get(bytes);
                                        out.writeInt(bytes.length);
                                        out.write(bytes);
                                        break;
                                    }
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getColorRef3f() != null) {
                                out.writeInt(7);
                                colors = ((GeometryArray)this.node).getColorRef3f();
                                data = new float[colors.length * 3];
                                for (int i = 0; i < colors.length; ++i) {
                                    data[i * 3 + 0] = colors[i].x;
                                    data[i * 3 + 1] = colors[i].y;
                                    data[i * 3 + 2] = colors[i].z;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getColorRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getColorRefFloat());
                            } else if (((GeometryArray)this.node).getColorRefByte() != null) {
                                out.writeInt(1);
                                colors = ((GeometryArray)this.node).getColorRefByte();
                                out.writeInt(colors.length);
                                out.write((byte[])colors);
                            } else if (((GeometryArray)this.node).getColorRef3b() != null) {
                                out.writeInt(4);
                                colors = ((GeometryArray)this.node).getColorRef3b();
                                out.writeInt(colors.length);
                                data = new byte[colors.length * 3];
                                for (int i = 0; i < colors.length; ++i) {
                                    data[i * 3 + 0] = colors[i].x;
                                    data[i * 3 + 1] = colors[i].y;
                                    data[i * 3 + 2] = colors[i].z;
                                }
                                out.write((byte[])data);
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            byte[] colors3 = new byte[this.vertexCount * 3];
                            ((GeometryArray)this.node).getColors(0, colors3);
                            out.write(colors3);
                        }
                    }
                    if ((this.vertexFormat & 1) != 0) {
                        if (byRef) {
                            Point3f[] coords;
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialCoordIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getCoordRefBuffer();
                                switch (BufferWrapper.getBufferType(buf2)) {
                                    case 3: {
                                        out.writeInt(2);
                                        bb = (FloatBuffer)buf2.getBuffer();
                                        float[] floats = new float[bb.limit()];
                                        ((FloatBuffer)bb).position(0);
                                        ((FloatBuffer)bb).get(floats);
                                        this.writeFloatArray(out, floats);
                                        break;
                                    }
                                    case 4: {
                                        out.writeInt(3);
                                        bb = (DoubleBuffer)buf2.getBuffer();
                                        double[] doubles = new double[bb.limit()];
                                        ((DoubleBuffer)bb).position(0);
                                        ((DoubleBuffer)bb).get(doubles);
                                        this.writeDoubleArray(out, doubles);
                                        break;
                                    }
                                    case 0: {
                                        out.writeInt(0);
                                    }
                                }
                            } else if (((GeometryArray)this.node).getCoordRef3f() != null) {
                                out.writeInt(7);
                                coords = ((GeometryArray)this.node).getCoordRef3f();
                                data = new float[coords.length * 3];
                                for (int i = 0; i < coords.length; ++i) {
                                    data[i * 3 + 0] = coords[i].x;
                                    data[i * 3 + 1] = coords[i].y;
                                    data[i * 3 + 2] = coords[i].z;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getCoordRef3d() != null) {
                                out.writeInt(10);
                                coords = ((GeometryArray)this.node).getCoordRef3d();
                                data = new double[coords.length * 3];
                                for (int i = 0; i < coords.length; ++i) {
                                    data[i * 3 + 0] = (float)coords[i].x;
                                    data[i * 3 + 1] = (float)coords[i].y;
                                    data[i * 3 + 2] = (float)coords[i].z;
                                }
                                this.writeDoubleArray(out, (double[])data);
                            } else if (((GeometryArray)this.node).getCoordRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getCoordRefFloat());
                            } else if (((GeometryArray)this.node).getCoordRefDouble() != null) {
                                out.writeInt(3);
                                this.writeDoubleArray(out, ((GeometryArray)this.node).getCoordRefDouble());
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            float[] points = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getCoordinates(0, points);
                            this.writeFloatArray(out, points);
                        }
                    }
                    if ((this.vertexFormat & 2) != 0) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialNormalIndex());
                            }
                            if (nio) {
                                buf2 = ((GeometryArray)this.node).getNormalRefBuffer();
                                if (BufferWrapper.getBufferType(buf2) == 0) {
                                    out.writeInt(0);
                                } else {
                                    out.writeInt(2);
                                    bb = (FloatBuffer)buf2.getBuffer();
                                    float[] floats = new float[bb.limit()];
                                    ((FloatBuffer)bb).position(0);
                                    ((FloatBuffer)bb).get(floats);
                                    this.writeFloatArray(out, floats);
                                }
                            } else if (((GeometryArray)this.node).getNormalRef3f() != null) {
                                out.writeInt(7);
                                Vector3f[] norms = ((GeometryArray)this.node).getNormalRef3f();
                                data = new float[norms.length * 3];
                                for (int i = 0; i < norms.length; ++i) {
                                    data[i * 3 + 0] = norms[i].x;
                                    data[i * 3 + 1] = norms[i].y;
                                    data[i * 3 + 2] = norms[i].z;
                                }
                                this.writeFloatArray(out, (float[])data);
                            } else if (((GeometryArray)this.node).getNormalRefFloat() != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getNormalRefFloat());
                            } else {
                                out.writeInt(0);
                            }
                        } else {
                            float[] normals = new float[this.vertexCount * 3];
                            ((GeometryArray)this.node).getNormals(0, normals);
                            this.writeFloatArray(out, normals);
                        }
                    }
                    if ((this.vertexFormat & 0x20) == 0) break block108;
                    for (int set = 0; set < this.texCoordSetCount; ++set) {
                        if (byRef) {
                            if (!(this.node instanceof IndexedGeometryArray)) {
                                out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                            }
                            if (nio) {
                                buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                                if (BufferWrapper.getBufferType(buf) == 0) {
                                    out.writeInt(0);
                                    continue;
                                }
                                out.writeInt(2);
                                FloatBuffer bb2 = (FloatBuffer)buf.getBuffer();
                                float[] floats = new float[bb2.limit()];
                                bb2.position(0);
                                bb2.get(floats);
                                this.writeFloatArray(out, floats);
                                continue;
                            }
                            if (((GeometryArray)this.node).getTexCoordRef2f(set) != null) {
                                out.writeInt(6);
                                tcoords = ((GeometryArray)this.node).getTexCoordRef2f(set);
                                float[] data2 = new float[tcoords.length * 2];
                                for (int i = 0; i < tcoords.length; ++i) {
                                    data2[i * 2 + 0] = tcoords[i].x;
                                    data2[i * 2 + 1] = tcoords[i].y;
                                }
                                this.writeFloatArray(out, data2);
                                continue;
                            }
                            if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                                out.writeInt(2);
                                this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                                continue;
                            }
                            out.writeInt(0);
                            continue;
                        }
                        textureCoords = new float[this.vertexCount * 2];
                        ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                        this.writeFloatArray(out, textureCoords);
                    }
                    break block107;
                }
                if ((this.vertexFormat & 0x40) == 0) break block109;
                for (int set = 0; set < this.texCoordSetCount; ++set) {
                    if (byRef) {
                        if (!(this.node instanceof IndexedGeometryArray)) {
                            out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                        }
                        if (nio) {
                            buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                            if (BufferWrapper.getBufferType(buf) == 0) {
                                out.writeInt(0);
                                continue;
                            }
                            out.writeInt(2);
                            FloatBuffer bb = (FloatBuffer)buf.getBuffer();
                            float[] floats = new float[bb.limit()];
                            bb.position(0);
                            bb.get(floats);
                            this.writeFloatArray(out, floats);
                            continue;
                        }
                        if (((GeometryArray)this.node).getTexCoordRef3f(set) != null) {
                            out.writeInt(7);
                            tcoords = ((GeometryArray)this.node).getTexCoordRef3f(set);
                            float[] data = new float[tcoords.length * 3];
                            for (int i = 0; i < tcoords.length; ++i) {
                                data[i * 3 + 0] = tcoords[i].x;
                                data[i * 3 + 1] = tcoords[i].y;
                                data[i * 3 + 2] = tcoords[i].z;
                            }
                            this.writeFloatArray(out, data);
                            continue;
                        }
                        if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                            out.writeInt(2);
                            this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                            continue;
                        }
                        out.writeInt(0);
                        continue;
                    }
                    textureCoords = new float[this.vertexCount * 3];
                    ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                    this.writeFloatArray(out, textureCoords);
                }
                break block107;
            }
            if ((this.vertexFormat & 0x400) == 0) break block107;
            for (int set = 0; set < this.texCoordSetCount; ++set) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        out.writeInt(((GeometryArray)this.node).getInitialTexCoordIndex(set));
                    }
                    if (nio) {
                        buf = ((GeometryArray)this.node).getTexCoordRefBuffer(set);
                        if (BufferWrapper.getBufferType(buf) == 0) {
                            out.writeInt(0);
                            continue;
                        }
                        out.writeInt(2);
                        FloatBuffer bb = (FloatBuffer)buf.getBuffer();
                        float[] floats = new float[bb.limit()];
                        bb.position(0);
                        bb.get(floats);
                        this.writeFloatArray(out, floats);
                        continue;
                    }
                    if (((GeometryArray)this.node).getTexCoordRefFloat(set) != null) {
                        out.writeInt(2);
                        this.writeFloatArray(out, ((GeometryArray)this.node).getTexCoordRefFloat(set));
                        continue;
                    }
                    out.writeInt(0);
                    continue;
                }
                textureCoords = new float[this.vertexCount * 4];
                ((GeometryArray)this.node).getTextureCoordinates(set, 0, textureCoords);
                this.writeFloatArray(out, textureCoords);
            }
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        block88: {
            Object[] data;
            Object[] colors;
            Color4f[] colors2;
            Object[] data2;
            float[] floats;
            ByteBuffer b;
            byte[] bytes;
            boolean byRef;
            boolean nio;
            block87: {
                super.readObject(in);
                boolean bl = nio = (this.vertexFormat & 0x800) != 0;
                if ((this.vertexFormat & 0x100) == 0) break block87;
                if (!(this.node instanceof IndexedGeometryArray)) {
                    ((GeometryArray)this.node).setInitialVertexIndex(in.readInt());
                    if (!(this.node instanceof GeometryStripArray)) {
                        ((GeometryArray)this.node).setValidVertexCount(in.readInt());
                    }
                }
                if (nio) {
                    float[] floats2 = this.readFloatArray(in);
                    ByteBuffer b2 = ByteBuffer.allocateDirect(floats2.length * 4);
                    FloatBuffer f = b2.order(ByteOrder.nativeOrder()).asFloatBuffer();
                    f.put(floats2);
                    ((GeometryArray)this.node).setInterleavedVertexBuffer(new J3DBuffer(f));
                } else {
                    ((GeometryArray)this.node).setInterleavedVertices(this.readFloatArray(in));
                }
                break block88;
            }
            boolean bl = byRef = (this.vertexFormat & 0x80) != 0;
            if (!(this.node instanceof IndexedGeometryArray)) {
                if (!byRef) {
                    ((GeometryArray)this.node).setInitialVertexIndex(in.readInt());
                }
                if (!(this.node instanceof GeometryStripArray)) {
                    ((GeometryArray)this.node).setValidVertexCount(in.readInt());
                }
            }
            if ((this.vertexFormat & 0xC) == 12) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 1: {
                                bytes = new byte[in.readInt()];
                                in.readFully(bytes);
                                b = ByteBuffer.allocateDirect(bytes.length);
                                b.put(bytes);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(b));
                                break;
                            }
                            case 2: {
                                floats = this.readFloatArray(in);
                                b = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f.put(floats);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(f));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 8: {
                                int i;
                                data2 = this.readFloatArray(in);
                                colors2 = new Color4f[data2.length / 4];
                                for (i = 0; i < colors2.length; ++i) {
                                    colors2[i].x = data2[i * 4 + 0];
                                    colors2[i].y = data2[i * 4 + 1];
                                    colors2[i].z = data2[i * 4 + 2];
                                    colors2[i].w = data2[i * 4 + 3];
                                }
                                ((GeometryArray)this.node).setColorRef4f(colors2);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 1: {
                                data2 = new byte[in.readInt()];
                                in.readFully((byte[])data2);
                                ((GeometryArray)this.node).setColorRefByte((byte[])data2);
                                break;
                            }
                            case 5: {
                                int i;
                                colors = new Color4b[in.readInt()];
                                data = new byte[colors.length * 4];
                                in.readFully((byte[])data);
                                for (i = 0; i < colors.length; ++i) {
                                    colors[i].x = data[i * 4 + 0];
                                    colors[i].y = data[i * 4 + 1];
                                    colors[i].z = data[i * 4 + 2];
                                    colors[i].w = data[i * 4 + 3];
                                }
                                ((GeometryArray)this.node).setColorRef4b((Color4b[])colors);
                            }
                        }
                    }
                } else {
                    colors = new byte[this.vertexCount * 4];
                    in.readFully((byte[])colors);
                    ((GeometryArray)this.node).setColors(0, (byte[])colors);
                }
            } else if ((this.vertexFormat & 4) == 4) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialColorIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 1: {
                                bytes = new byte[in.readInt()];
                                in.readFully(bytes);
                                b = ByteBuffer.allocateDirect(bytes.length);
                                b.put(bytes);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(b));
                                break;
                            }
                            case 2: {
                                floats = this.readFloatArray(in);
                                b = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f.put(floats);
                                ((GeometryArray)this.node).setColorRefBuffer(new J3DBuffer(f));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                int i;
                                data2 = this.readFloatArray(in);
                                colors2 = new Color3f[data2.length / 3];
                                for (i = 0; i < colors2.length; ++i) {
                                    colors2[i].x = data2[i * 3 + 0];
                                    colors2[i].y = data2[i * 3 + 1];
                                    colors2[i].z = data2[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setColorRef3f((Color3f[])colors2);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setColorRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 1: {
                                data2 = new byte[in.readInt()];
                                in.readFully((byte[])data2);
                                ((GeometryArray)this.node).setColorRefByte((byte[])data2);
                                break;
                            }
                            case 4: {
                                int i;
                                colors = new Color3b[in.readInt()];
                                data = new byte[colors.length * 3];
                                in.readFully((byte[])data);
                                for (i = 0; i < colors.length; ++i) {
                                    colors[i].x = data[i * 3 + 0];
                                    colors[i].y = data[i * 3 + 1];
                                    colors[i].z = data[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setColorRef3b((Color3b[])colors);
                            }
                        }
                    }
                } else {
                    colors = new byte[this.vertexCount * 3];
                    in.readFully((byte[])colors);
                    ((GeometryArray)this.node).setColors(0, (byte[])colors);
                }
            }
            if ((this.vertexFormat & 1) != 0) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialCoordIndex(in.readInt());
                    }
                    if (nio) {
                        switch (in.readInt()) {
                            case 2: {
                                floats = this.readFloatArray(in);
                                b = ByteBuffer.allocateDirect(floats.length * 4);
                                FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                                f.put(floats);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer(f));
                                break;
                            }
                            case 3: {
                                double[] doubles = this.readDoubleArray(in);
                                b = ByteBuffer.allocateDirect(doubles.length * 8);
                                DoubleBuffer f = b.order(ByteOrder.nativeOrder()).asDoubleBuffer();
                                f.put(doubles);
                                ((GeometryArray)this.node).setCoordRefBuffer(new J3DBuffer(f));
                            }
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                data2 = this.readFloatArray(in);
                                Point3f[] coords = new Point3f[data2.length / 3];
                                for (int i = 0; i < coords.length; ++i) {
                                    coords[i].x = data2[i * 3 + 0];
                                    coords[i].y = data2[i * 3 + 1];
                                    coords[i].z = data2[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setCoordRef3f(coords);
                                break;
                            }
                            case 10: {
                                data2 = this.readDoubleArray(in);
                                Point3f[] coords = new Point3d[data2.length / 3];
                                for (int i = 0; i < coords.length; ++i) {
                                    coords[i].x = data2[i * 3 + 0];
                                    coords[i].y = data2[i * 3 + 1];
                                    coords[i].z = data2[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setCoordRef3d((Point3d[])coords);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setCoordRefFloat(this.readFloatArray(in));
                                break;
                            }
                            case 3: {
                                ((GeometryArray)this.node).setCoordRefDouble(this.readDoubleArray(in));
                            }
                        }
                    }
                } else {
                    float[] points = this.readFloatArray(in);
                    ((GeometryArray)this.node).setCoordinates(0, points);
                }
            }
            if ((this.vertexFormat & 2) != 0) {
                if (byRef) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialNormalIndex(in.readInt());
                    }
                    if (nio) {
                        if (in.readInt() == 2) {
                            floats = this.readFloatArray(in);
                            b = ByteBuffer.allocateDirect(floats.length * 4);
                            FloatBuffer f = b.order(ByteOrder.nativeOrder()).asFloatBuffer();
                            f.put(floats);
                            ((GeometryArray)this.node).setNormalRefBuffer(new J3DBuffer(f));
                        }
                    } else {
                        switch (in.readInt()) {
                            case 7: {
                                data2 = this.readFloatArray(in);
                                Vector3f[] norms = new Vector3f[data2.length / 3];
                                for (int i = 0; i < norms.length; ++i) {
                                    norms[i].x = data2[i * 3 + 0];
                                    norms[i].y = data2[i * 3 + 1];
                                    norms[i].z = data2[i * 3 + 2];
                                }
                                ((GeometryArray)this.node).setNormalRef3f(norms);
                                break;
                            }
                            case 2: {
                                ((GeometryArray)this.node).setNormalRefFloat(this.readFloatArray(in));
                            }
                        }
                    }
                } else {
                    float[] normals = this.readFloatArray(in);
                    ((GeometryArray)this.node).setNormals(0, normals);
                }
            }
            if ((this.vertexFormat & 0x20) == 0 && (this.vertexFormat & 0x40) == 0 && (this.vertexFormat & 0x400) == 0) break block88;
            if (byRef) {
                block46: for (int set = 0; set < this.texCoordSetCount; ++set) {
                    if (!(this.node instanceof IndexedGeometryArray)) {
                        ((GeometryArray)this.node).setInitialTexCoordIndex(set, in.readInt());
                    }
                    if (nio) {
                        if (in.readInt() != 2) continue;
                        float[] floats3 = this.readFloatArray(in);
                        ByteBuffer b3 = ByteBuffer.allocateDirect(floats3.length * 4);
                        FloatBuffer f = b3.order(ByteOrder.nativeOrder()).asFloatBuffer();
                        f.put(floats3);
                        ((GeometryArray)this.node).setTexCoordRefBuffer(set, new J3DBuffer(f));
                        continue;
                    }
                    switch (in.readInt()) {
                        case 6: {
                            data = this.readFloatArray(in);
                            TexCoord2f[] tcoords = new TexCoord2f[data.length / 2];
                            for (int i = 0; i < tcoords.length; ++i) {
                                tcoords[i].x = data[i * 2 + 0];
                                tcoords[i].y = data[i * 2 + 1];
                            }
                            ((GeometryArray)this.node).setTexCoordRef2f(set, tcoords);
                            continue block46;
                        }
                        case 7: {
                            data = this.readFloatArray(in);
                            TexCoord3f[] tcoords = new TexCoord3f[data.length / 3];
                            for (int i = 0; i < tcoords.length; ++i) {
                                tcoords[i].x = data[i * 3 + 0];
                                tcoords[i].y = data[i * 3 + 1];
                                tcoords[i].z = data[i * 3 + 2];
                            }
                            ((GeometryArray)this.node).setTexCoordRef3f(set, tcoords);
                            continue block46;
                        }
                        case 2: {
                            float[] tcoords = this.readFloatArray(in);
                            ((GeometryArray)this.node).setTexCoordRefFloat(set, tcoords);
                        }
                    }
                }
            } else {
                for (int set = 0; set < this.texCoordSetCount; ++set) {
                    float[] textureCoords = this.readFloatArray(in);
                    ((GeometryArray)this.node).setTextureCoordinates(set, 0, textureCoords);
                }
            }
        }
    }

    @Override
    protected void writeConstructorParams(DataOutput out) throws IOException {
        this.vertexCount = ((GeometryArray)this.node).getVertexCount();
        this.vertexFormat = ((GeometryArray)this.node).getVertexFormat();
        this.texCoordSetCount = ((GeometryArray)this.node).getTexCoordSetCount();
        this.texCoordSetMap = new int[((GeometryArray)this.node).getTexCoordSetMapLength()];
        ((GeometryArray)this.node).getTexCoordSetMap(this.texCoordSetMap);
        out.writeInt(this.vertexCount);
        out.writeInt(this.vertexFormat);
        out.writeInt(this.texCoordSetCount);
        out.writeInt(this.texCoordSetMap.length);
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            out.writeInt(this.texCoordSetMap[i]);
        }
        super.writeConstructorParams(out);
    }

    @Override
    protected void readConstructorParams(DataInput in) throws IOException {
        this.vertexCount = in.readInt();
        this.vertexFormat = in.readInt();
        this.texCoordSetCount = in.readInt();
        this.texCoordSetMap = new int[in.readInt()];
        for (int i = 0; i < this.texCoordSetMap.length; ++i) {
            this.texCoordSetMap[i] = in.readInt();
        }
        super.readConstructorParams(in);
    }

    protected void writeDoubleArray(DataOutput out, double[] array) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        dataOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dataOut.writeDouble(array[i]);
        }
        dataOut.close();
        out.writeInt(byteStream.size());
        out.write(byteStream.toByteArray());
    }

    protected double[] readDoubleArray(DataInput in) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteStream);
        double[] array = new double[dataIn.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dataIn.readDouble();
        }
        dataIn.close();
        return array;
    }

    protected void writeFloatArray(DataOutput out, float[] array) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        dataOut.writeInt(array.length);
        for (int i = 0; i < array.length; ++i) {
            dataOut.writeFloat(array[i]);
        }
        dataOut.close();
        out.writeInt(byteStream.size());
        out.write(byteStream.toByteArray());
    }

    protected float[] readFloatArray(DataInput in) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteStream);
        float[] array = new float[dataIn.readInt()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dataIn.readFloat();
        }
        dataIn.close();
        return array;
    }
}

