/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Mutate1D;
import org.ojalgo.constant.PrimitiveMath;

abstract class DiagonalAccess<N extends Number, D extends Access1D<N> & Mutate1D>
implements Access2D<N> {
    private final int myDimension;
    private final N myZero;
    final D mainDiagonal;
    final D subdiagonal;
    final D superdiagonal;

    private DiagonalAccess() {
        this(null, null, null, null);
    }

    DiagonalAccess(D mainDiag, D superdiag, D subdiag, N zero) {
        this.mainDiagonal = mainDiag;
        this.superdiagonal = superdiag;
        this.subdiagonal = subdiag;
        this.myZero = zero;
        this.myDimension = mainDiag != null ? (int)mainDiag.count() : (superdiag != null ? (int)superdiag.count() + 1 : (int)subdiag.count() + 1);
    }

    @Override
    public long countColumns() {
        return this.myDimension;
    }

    @Override
    public long countRows() {
        return this.myDimension;
    }

    @Override
    public double doubleValue(long row, long col) {
        if (this.mainDiagonal != null && row == col) {
            return this.mainDiagonal.doubleValue(row);
        }
        if (this.superdiagonal != null && col - row == 1L) {
            return this.superdiagonal.doubleValue(row);
        }
        if (this.subdiagonal != null && row - col == 1L) {
            return this.subdiagonal.doubleValue(col);
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public N get(long row, long col) {
        if (this.mainDiagonal != null && row == col) {
            return this.mainDiagonal.get(row);
        }
        if (this.superdiagonal != null && col - row == 1L) {
            return this.superdiagonal.get(row);
        }
        if (this.subdiagonal != null && row - col == 1L) {
            return this.subdiagonal.get(col);
        }
        return this.myZero;
    }

    public String toString() {
        return "DiagonalAccess [mainDiagonal=" + this.mainDiagonal + ", subdiagonal=" + this.subdiagonal + ", superdiagonal=" + this.superdiagonal + "]";
    }

    int getDimension() {
        return this.myDimension;
    }

    N getZero() {
        return this.myZero;
    }
}

