/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.ElementsSupplier;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SparseStore;
import org.ojalgo.scalar.Scalar;

final class IdentityStore<N extends Number>
extends FactoryStore<N> {
    private IdentityStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        ProgrammingError.throwForIllegalInvocation();
    }

    IdentityStore(PhysicalStore.Factory<N, ?> factory, int dimension) {
        super(factory, dimension, dimension);
    }

    @Override
    public MatrixStore<N> conjugate() {
        return this;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        if (aRow == aCol) {
            return PrimitiveMath.ONE;
        }
        return PrimitiveMath.ZERO;
    }

    @Override
    public int firstInColumn(int col) {
        return col;
    }

    @Override
    public int firstInRow(int row) {
        return row;
    }

    @Override
    public N get(long aRow, long aCol) {
        if (aRow == aCol) {
            return this.physical().scalar().one().get();
        }
        return this.physical().scalar().zero().get();
    }

    @Override
    public int limitOfColumn(int col) {
        return col + 1;
    }

    @Override
    public int limitOfRow(int row) {
        return row + 1;
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        if (right instanceof Access2D.Collectable) {
            ((Access2D.Collectable)((Object)right)).supplyTo(target);
        } else {
            super.multiply(right, target);
        }
    }

    @Override
    public MatrixStore<N> multiply(double scalar) {
        SparseStore retVal = new SparseStore(this.physical(), this.getRowDim(), this.getColDim());
        retVal.loopDiagonal(0L, 0L, (r, c) -> retVal.set(r, c, scalar));
        return retVal;
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        return right.copy();
    }

    @Override
    public MatrixStore<N> multiply(N scalar) {
        SparseStore retVal = new SparseStore(this.physical(), this.getRowDim(), this.getColDim());
        retVal.loopDiagonal(0L, 0L, (r, c) -> retVal.set(r, c, (Number)scalar));
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        return super.multiplyBoth(leftAndRight);
    }

    @Override
    public ElementsSupplier<N> premultiply(Access1D<N> left) {
        return super.premultiply(left);
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.reset();
        receiver.fillDiagonal(this.physical().scalar().one().get());
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        if (row == column) {
            return this.physical().scalar().one();
        }
        return this.physical().scalar().zero();
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }
}

