/*
 * Decompiled with CFR 0.152.
 */
package fiji.drawing;

import ij.ImagePlus;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Radial_Gradient
implements PlugInFilter {
    ImagePlus image;

    public int setup(String arg, ImagePlus image) {
        this.image = image;
        return 16;
    }

    public void run(ImageProcessor ip) {
        int in = Toolbar.getForegroundColor().getRGB();
        int out = Toolbar.getBackgroundColor().getRGB();
        int w = ip.getWidth();
        int[] pixels = (int[])ip.getPixels();
        Roi roi = this.image.getRoi();
        if (roi == null) {
            Gradient g = new Gradient(w, ip.getHeight(), in, out);
            while (g.fwd()) {
                pixels[g.x + g.y * w] = g.color;
            }
        } else {
            Rectangle rect = roi.getBounds();
            Gradient g = new Gradient(rect.width, rect.height, in, out);
            while (g.fwd()) {
                int x = rect.x + g.x;
                int y = rect.y + g.y;
                if (!roi.contains(x, y)) continue;
                pixels[x + y * w] = g.color;
            }
        }
    }

    class Gradient {
        int x;
        int y;
        int color;
        protected int w;
        protected int h;
        protected int halfW;
        protected int halfH;
        protected int max;
        protected int yMinusHalfH2;
        protected int in;
        protected int out;

        Gradient(int width, int height, int inColor, int outColor) {
            this.w = width;
            this.h = height;
            this.in = inColor;
            this.out = outColor;
            this.x = -1;
            this.y = 0;
            this.halfW = (this.w + 1) / 2;
            this.halfH = (this.h + 1) / 2;
            this.max = this.halfW * this.halfW + this.halfH * this.halfH;
            this.yMinusHalfH2 = (this.y - this.halfH) * (this.y - this.halfH);
        }

        protected int getColor(int distance, int max) {
            int result = 0;
            for (int i = 255; i != -16777216; i <<= 8) {
                result |= i & (int)((long)(this.in & i) + (long)((this.out & i) - (this.in & i)) * (long)distance / (long)max);
            }
            return result;
        }

        boolean fwd() {
            if (++this.x >= this.w) {
                this.x = 0;
                if (++this.y >= this.h) {
                    return false;
                }
                this.yMinusHalfH2 = (this.y - this.halfH) * (this.y - this.halfH);
            }
            this.color = this.getColor((this.x - this.halfW) * (this.x - this.halfW) + this.yMinusHalfH2, this.max);
            return true;
        }
    }
}

