/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Point;
import java.awt.geom.Point2D;

public enum TranslationDirection {
    NORTH,
    WEST,
    SOUTH,
    EAST,
    NORTH_WEST,
    SOUTH_WEST,
    NORTH_EAST,
    SOUTH_EAST;


    @Nullable
    public static TranslationDirection getDirection(Point startPoint, Point endPoint) {
        int dx = endPoint.x - startPoint.x;
        int dy = endPoint.y - startPoint.y;
        if (dx == 0) {
            if (dy == 0) {
                return null;
            }
            if (dy > 0) {
                return SOUTH;
            }
            return NORTH;
        }
        if (dx > 0) {
            if (dy == 0) {
                return EAST;
            }
            if (dy > 0) {
                return SOUTH_EAST;
            }
            return NORTH_EAST;
        }
        if (dy == 0) {
            return WEST;
        }
        if (dy > 0) {
            return SOUTH_WEST;
        }
        return NORTH_WEST;
    }

    @Nullable
    public static TranslationDirection getDirection(Point2D.Double startPoint, Point2D.Double endPoint) {
        double dx = endPoint.x - startPoint.x;
        double dy = endPoint.y - startPoint.y;
        if (dx == 0.0) {
            if (dy == 0.0) {
                return null;
            }
            if (dy > 0.0) {
                return SOUTH;
            }
            return NORTH;
        }
        if (dx > 0.0) {
            if (dy == 0.0) {
                return EAST;
            }
            if (dy > 0.0) {
                return SOUTH_EAST;
            }
            return NORTH_EAST;
        }
        if (dy == 0.0) {
            return WEST;
        }
        if (dy > 0.0) {
            return SOUTH_WEST;
        }
        return NORTH_WEST;
    }
}

