/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui.sourcegrouptree;

import bdv.util.WrappedList;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.ViewerState;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SourceGroupTreeModel
implements TreeModel {
    private final EventListenerList listenerList = new EventListenerList();
    private final String root = "root";
    private final Object[] rootPath = new Object[]{"root"};
    private final ViewerState state;
    private StateModel model;
    private static final int NO_ENTRY_VALUE = -1;

    public SourceGroupTreeModel(ViewerState state) {
        this.model = new StateModel(state);
        this.state = state;
        state.changeListeners().add(e -> {
            switch (e) {
                case CURRENT_GROUP_CHANGED: 
                case GROUP_ACTIVITY_CHANGED: 
                case SOURCE_TO_GROUP_ASSIGNMENT_CHANGED: 
                case GROUP_NAME_CHANGED: 
                case NUM_GROUPS_CHANGED: {
                    StateModel model = new StateModel(state);
                    SwingUtilities.invokeLater(() -> this.analyzeChanges(model));
                }
            }
        });
    }

    @Override
    public Object getRoot() {
        return "root";
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == "root") {
            return this.model.getGroups().get(index);
        }
        if (parent instanceof GroupModel) {
            return ((GroupModel)parent).getSources().get(index);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == "root") {
            return this.model.getGroups().size();
        }
        if (parent instanceof GroupModel) {
            return ((GroupModel)parent).getSources().size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == "root") {
            return this.model.getGroups().isEmpty();
        }
        if (node instanceof GroupModel) {
            return ((GroupModel)node).getSources().isEmpty();
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object o = path.getLastPathComponent();
        if (o instanceof GroupModel) {
            this.state.setGroupName(((GroupModel)o).group, newValue.toString());
        }
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == "root") {
            return this.model.getGroups().indexOf(child);
        }
        if (parent instanceof GroupModel) {
            return ((GroupModel)parent).getSources().indexOf(child);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    private void fireTreeNodesChanged(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesChanged(e);
        }
    }

    private void fireTreeNodesInserted(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesInserted(e);
        }
    }

    private void fireTreeNodesRemoved(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeNodesRemoved(e);
        }
    }

    private void fireTreeStructureChanged(TreeModelEvent e) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(e);
        }
    }

    public TreePath getPathTo(GroupModel group) {
        return new TreePath(new Object[]{"root", group});
    }

    private void analyzeChanges(StateModel model) {
        Object[] children;
        int[] childIndices;
        StateModel previousModel = this.model;
        this.model = model;
        ArrayList<Object> removedGroups = new ArrayList<Object>();
        for (Object group : previousModel.getGroups()) {
            if (model.getGroups().contains(group)) continue;
            removedGroups.add(group);
        }
        ArrayList<Object> addedGroups = new ArrayList<Object>();
        for (Object group : model.getGroups()) {
            if (previousModel.getGroups().contains(group)) continue;
            addedGroups.add(group);
        }
        ArrayList<Object> changedGroups = new ArrayList<Object>();
        for (Object group : model.getGroups()) {
            GroupModel previousGroup = previousModel.getGroups().get((GroupModel)group);
            if (previousGroup == null || ((GroupModel)group).isCurrent() == previousGroup.isCurrent() && ((GroupModel)group).isActive() == previousGroup.isActive() && Objects.equals(((GroupModel)group).getName(), previousGroup.getName())) continue;
            changedGroups.add(group);
        }
        ArrayList<GroupModel> structurallyChangedGroups = new ArrayList<GroupModel>();
        for (GroupModel group : model.getGroups()) {
            List<SourceModel> previousContent;
            List<SourceModel> content;
            GroupModel previousGroup = previousModel.getGroups().get(group);
            if (previousGroup == null || (content = group.getSources()).equals(previousContent = previousGroup.getSources())) continue;
            structurallyChangedGroups.add(group);
        }
        if (!addedGroups.isEmpty()) {
            childIndices = new int[addedGroups.size()];
            Arrays.setAll(childIndices, i -> model.getGroups().indexOf(addedGroups.get(i)));
            children = addedGroups.toArray(new Object[0]);
            this.fireTreeNodesInserted(new TreeModelEvent((Object)this, this.rootPath, childIndices, children));
        } else if (!removedGroups.isEmpty()) {
            childIndices = new int[removedGroups.size()];
            Arrays.setAll(childIndices, i -> previousModel.getGroups().indexOf(removedGroups.get(i)));
            children = removedGroups.toArray(new Object[0]);
            this.fireTreeNodesRemoved(new TreeModelEvent((Object)this, this.rootPath, childIndices, children));
        }
        if (!changedGroups.isEmpty()) {
            childIndices = new int[changedGroups.size()];
            Arrays.setAll(childIndices, i -> model.getGroups().indexOf(changedGroups.get(i)));
            children = changedGroups.toArray(new Object[0]);
            this.fireTreeNodesChanged(new TreeModelEvent((Object)this, this.rootPath, childIndices, children));
        }
        if (!structurallyChangedGroups.isEmpty()) {
            for (GroupModel group : structurallyChangedGroups) {
                Object[] path = new Object[]{"root", group};
                this.fireTreeStructureChanged(new TreeModelEvent((Object)this, path, null, null));
            }
        }
    }

    static class SourceModel {
        private final String name;
        private final SourceAndConverter<?> source;

        public SourceModel(SourceAndConverter<?> source) {
            this.name = source.getSpimSource().getName();
            this.source = source;
        }

        public String getName() {
            return this.name;
        }

        public SourceAndConverter<?> getSource() {
            return this.source;
        }

        public boolean equals(Object o) {
            return o instanceof SourceModel && this.source.equals(((SourceModel)o).source);
        }

        public int hashCode() {
            return this.source.hashCode();
        }
    }

    static class GroupModel {
        private final String name;
        private final boolean active;
        private final boolean current;
        private final List<SourceModel> sources;
        private final SourceGroup group;

        public GroupModel(SourceGroup group, ViewerState state) {
            this.name = state.getGroupName(group);
            this.active = state.isGroupActive(group);
            this.current = state.isCurrentGroup(group);
            ArrayList orderedSources = new ArrayList(state.getSourcesInGroup(group));
            orderedSources.sort(state.sourceOrder());
            ArrayList<SourceModel> slist = new ArrayList<SourceModel>();
            TObjectIntHashMap sindices = new TObjectIntHashMap(10, 0.5f, -1);
            for (int i = 0; i < orderedSources.size(); ++i) {
                SourceModel sourceModel = new SourceModel((SourceAndConverter)orderedSources.get(i));
                slist.add(sourceModel);
                sindices.put((Object)sourceModel, i);
            }
            this.sources = new UnmodifiableSources(slist, (TObjectIntMap<SourceModel>)sindices);
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public boolean isCurrent() {
            return this.current;
        }

        public List<SourceModel> getSources() {
            return this.sources;
        }

        public SourceGroup getGroup() {
            return this.group;
        }

        public boolean equals(Object o) {
            return o instanceof GroupModel && this.group.equals(((GroupModel)o).group);
        }

        public int hashCode() {
            return this.group.hashCode();
        }

        static class UnmodifiableSources
        extends WrappedList<SourceModel> {
            private final TObjectIntMap<SourceModel> sourceIndices;

            public UnmodifiableSources(List<SourceModel> sources, TObjectIntMap<SourceModel> sourceIndices) {
                super(Collections.unmodifiableList(sources));
                this.sourceIndices = sourceIndices;
            }

            @Override
            public boolean contains(Object o) {
                return this.sourceIndices.containsKey(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.sourceIndices.keySet().containsAll(c);
            }

            @Override
            public int indexOf(Object o) {
                return this.sourceIndices.get(o);
            }

            @Override
            public int lastIndexOf(Object o) {
                return this.sourceIndices.get(o);
            }
        }
    }

    static class StateModel {
        private final UnmodifiableGroups groups;

        public StateModel(ViewerState state) {
            ArrayList<GroupModel> glist = new ArrayList<GroupModel>();
            TObjectIntHashMap gindices = new TObjectIntHashMap(10, 0.5f, -1);
            List<SourceGroup> sgroups = state.getGroups();
            for (int i = 0; i < sgroups.size(); ++i) {
                GroupModel groupModel = new GroupModel(sgroups.get(i), state);
                glist.add(groupModel);
                gindices.put((Object)groupModel, i);
            }
            this.groups = new UnmodifiableGroups(glist, (TObjectIntMap<GroupModel>)gindices);
        }

        public UnmodifiableGroups getGroups() {
            return this.groups;
        }

        static class UnmodifiableGroups
        extends WrappedList<GroupModel> {
            private final TObjectIntMap<GroupModel> groupIndices;

            public UnmodifiableGroups(List<GroupModel> groups, TObjectIntMap<GroupModel> groupIndices) {
                super(Collections.unmodifiableList(groups));
                this.groupIndices = groupIndices;
            }

            public GroupModel get(GroupModel groupModel) {
                int index = this.groupIndices.get((Object)groupModel);
                return index == -1 ? null : (GroupModel)this.get(index);
            }

            @Override
            public boolean contains(Object o) {
                return this.groupIndices.containsKey(o);
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                return this.groupIndices.keySet().containsAll(c);
            }

            @Override
            public int indexOf(Object o) {
                return this.groupIndices.get(o);
            }

            @Override
            public int lastIndexOf(Object o) {
                return this.groupIndices.get(o);
            }
        }
    }
}

