/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.model.mxGeometry;
import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxSwingConstants;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class mxVertexHandler
extends mxCellHandler {
    public static Cursor[] CURSORS = new Cursor[]{new Cursor(6), new Cursor(8), new Cursor(7), new Cursor(10), new Cursor(11), new Cursor(4), new Cursor(9), new Cursor(5), new Cursor(13)};
    protected transient boolean gridEnabledEvent = false;
    protected transient boolean constrainedEvent = false;

    public mxVertexHandler(mxGraphComponent graphComponent, mxCellState state) {
        super(graphComponent, state);
    }

    @Override
    protected Rectangle[] createHandles() {
        Rectangle[] h = null;
        if (this.graphComponent.getGraph().isCellResizable(this.getState().getCell())) {
            Rectangle bounds = this.getState().getRectangle();
            int half = mxConstants.HANDLE_SIZE / 2;
            int left = bounds.x - half;
            int top = bounds.y - half;
            int w2 = bounds.x + bounds.width / 2 - half;
            int h2 = bounds.y + bounds.height / 2 - half;
            int right = bounds.x + bounds.width - half;
            int bottom = bounds.y + bounds.height - half;
            h = new Rectangle[9];
            int s = mxConstants.HANDLE_SIZE;
            h[0] = new Rectangle(left, top, s, s);
            h[1] = new Rectangle(w2, top, s, s);
            h[2] = new Rectangle(right, top, s, s);
            h[3] = new Rectangle(left, h2, s, s);
            h[4] = new Rectangle(right, h2, s, s);
            h[5] = new Rectangle(left, bottom, s, s);
            h[6] = new Rectangle(w2, bottom, s, s);
            h[7] = new Rectangle(right, bottom, s, s);
        } else {
            h = new Rectangle[1];
        }
        int s = mxConstants.LABEL_HANDLE_SIZE;
        mxRectangle bounds = this.state.getLabelBounds();
        h[h.length - 1] = new Rectangle((int)(bounds.getX() + bounds.getWidth() / 2.0 - (double)s), (int)(bounds.getY() + bounds.getHeight() / 2.0 - (double)s), 2 * s, 2 * s);
        return h;
    }

    @Override
    protected JComponent createPreview() {
        JPanel preview = new JPanel();
        preview.setBorder(mxSwingConstants.PREVIEW_BORDER);
        preview.setOpaque(false);
        preview.setVisible(false);
        return preview;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!e.isConsumed() && this.first != null) {
            this.gridEnabledEvent = this.graphComponent.isGridEnabledEvent(e);
            this.constrainedEvent = this.graphComponent.isConstrainedEvent(e);
            double dx = e.getX() - this.first.x;
            double dy = e.getY() - this.first.y;
            if (this.isLabel(this.index)) {
                mxPoint pt = new mxPoint(e.getPoint());
                if (this.gridEnabledEvent) {
                    pt = this.graphComponent.snapScaledPoint(pt);
                }
                int idx = (int)Math.round(pt.getX() - (double)this.first.x);
                int idy = (int)Math.round(pt.getY() - (double)this.first.y);
                if (this.constrainedEvent) {
                    if (Math.abs(idx) > Math.abs(idy)) {
                        idy = 0;
                    } else {
                        idx = 0;
                    }
                }
                Rectangle rect = this.state.getLabelBounds().getRectangle();
                rect.translate(idx, idy);
                this.preview.setBounds(rect);
            } else {
                mxGraph graph = this.graphComponent.getGraph();
                double scale = graph.getView().getScale();
                if (this.gridEnabledEvent) {
                    dx = graph.snap(dx / scale) * scale;
                    dy = graph.snap(dy / scale) * scale;
                }
                mxRectangle bounds = this.union(this.getState(), dx, dy, this.index);
                bounds.setWidth(bounds.getWidth() + 1.0);
                bounds.setHeight(bounds.getHeight() + 1.0);
                this.preview.setBounds(bounds.getRectangle());
            }
            if (!this.preview.isVisible() && this.graphComponent.isSignificant(dx, dy)) {
                this.preview.setVisible(true);
            }
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isConsumed() && this.first != null) {
            if (this.preview != null && this.preview.isVisible()) {
                if (this.isLabel(this.index)) {
                    this.moveLabel(e);
                } else {
                    this.resizeCell(e);
                }
            }
            e.consume();
        }
        super.mouseReleased(e);
    }

    protected void moveLabel(MouseEvent e) {
        mxGraph graph = this.graphComponent.getGraph();
        mxGeometry geometry = graph.getModel().getGeometry(this.state.getCell());
        if (geometry != null) {
            mxPoint offset;
            double scale = graph.getView().getScale();
            mxPoint pt = new mxPoint(e.getPoint());
            if (this.gridEnabledEvent) {
                pt = this.graphComponent.snapScaledPoint(pt);
            }
            double dx = (pt.getX() - (double)this.first.x) / scale;
            double dy = (pt.getY() - (double)this.first.y) / scale;
            if (this.constrainedEvent) {
                if (Math.abs(dx) > Math.abs(dy)) {
                    dy = 0.0;
                } else {
                    dx = 0.0;
                }
            }
            if ((offset = geometry.getOffset()) == null) {
                offset = new mxPoint();
            }
            geometry = (mxGeometry)geometry.clone();
            geometry.setOffset(new mxPoint(Math.round(dx += offset.getX()), Math.round(dy += offset.getY())));
            graph.getModel().setGeometry(this.state.getCell(), geometry);
        }
    }

    protected void resizeCell(MouseEvent e) {
        mxGraph graph = this.graphComponent.getGraph();
        double scale = graph.getView().getScale();
        Object cell = this.state.getCell();
        mxGeometry geometry = graph.getModel().getGeometry(cell);
        if (geometry != null) {
            double dx = (double)(e.getX() - this.first.x) / scale;
            double dy = (double)(e.getY() - this.first.y) / scale;
            if (this.isLabel(this.index)) {
                if ((geometry = (mxGeometry)geometry.clone()).getOffset() != null) {
                    dx += geometry.getOffset().getX();
                    dy += geometry.getOffset().getY();
                }
                if (this.gridEnabledEvent) {
                    dx = graph.snap(dx);
                    dy = graph.snap(dy);
                }
                geometry.setOffset(new mxPoint(dx, dy));
                graph.getModel().setGeometry(cell, geometry);
            } else {
                mxRectangle bounds = this.union(geometry, dx, dy, this.index);
                Rectangle rect = bounds.getRectangle();
                if (this.gridEnabledEvent) {
                    int x = (int)graph.snap(rect.x);
                    int y = (int)graph.snap(rect.y);
                    rect.width = (int)graph.snap(rect.width - x + rect.x);
                    rect.height = (int)graph.snap(rect.height - y + rect.y);
                    rect.x = x;
                    rect.y = y;
                }
                graph.resizeCell(cell, new mxRectangle(rect));
            }
        }
    }

    @Override
    protected Cursor getCursor(MouseEvent e, int index) {
        if (index >= 0 && index <= CURSORS.length) {
            return CURSORS[index];
        }
        return null;
    }

    protected mxRectangle union(mxRectangle bounds, double dx, double dy, int index) {
        double left = bounds.getX();
        double right = left + bounds.getWidth();
        double top = bounds.getY();
        double bottom = top + bounds.getHeight();
        if (index > 4) {
            bottom += dy;
        } else if (index < 3) {
            top += dy;
        }
        if (index == 0 || index == 3 || index == 5) {
            left += dx;
        } else if (index == 2 || index == 4 || index == 7) {
            right += dx;
        }
        double width = right - left;
        double height = bottom - top;
        if (width < 0.0) {
            left += width;
            width = Math.abs(width);
        }
        if (height < 0.0) {
            top += height;
            height = Math.abs(height);
        }
        return new mxRectangle(left, top, width, height);
    }

    @Override
    public Color getSelectionColor() {
        return mxSwingConstants.VERTEX_SELECTION_COLOR;
    }

    @Override
    public Stroke getSelectionStroke() {
        return mxSwingConstants.VERTEX_SELECTION_STROKE;
    }

    @Override
    public void paint(Graphics g) {
        Rectangle bounds = this.getState().getRectangle();
        if (g.hitClip(bounds.x, bounds.y, bounds.width, bounds.height)) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke = g2.getStroke();
            g2.setStroke(this.getSelectionStroke());
            g.setColor(this.getSelectionColor());
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g2.setStroke(stroke);
        }
        super.paint(g);
    }
}

