/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij.export.imgloader;

import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.imagestack.ImageStackImageLoader;
import bdv.img.virtualstack.VirtualStackImageLoader;
import ij.ImagePlus;
import java.util.ArrayList;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.TypedBasicImgLoader;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.stats.ComputeMinMax;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.RealFloatConverter;
import net.imglib2.converter.RealUnsignedShortConverter;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;

@Deprecated
public class ImagePlusImgLoader<T extends Type<T>>
implements TypedBasicImgLoader<T> {
    protected final ImagePlus imp;
    protected final BasicImgLoader loader;
    protected VolatileGlobalCellCache loadercache;
    protected final ArrayList<SetupImgLoader<?>> setupImgLoaders;
    protected double impMin;
    protected double impMax;
    protected final T type;
    protected final ConverterFactory<T> converterFactory;

    public static ImagePlusImgLoader<UnsignedShortType> createGray8(ImagePlus imp, MinMaxOption minMaxOption, double min, double max) {
        if (imp.getType() != 0) {
            throw new RuntimeException("expected ImagePlus type GRAY8");
        }
        if (imp.getStack() != null && imp.getStack().isVirtual()) {
            return new ImagePlusImgLoader<UnsignedShortType>(imp, VirtualStackImageLoader.createUnsignedByteInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
        }
        return new ImagePlusImgLoader<UnsignedShortType>(imp, ImageStackImageLoader.createUnsignedByteInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
    }

    public static ImagePlusImgLoader<FloatType> createFloatFromGray8(ImagePlus imp, MinMaxOption minMaxOption, double min, double max) {
        if (imp.getType() != 0) {
            throw new RuntimeException("expected ImagePlus type GRAY8");
        }
        if (imp.getStack() != null && imp.getStack().isVirtual()) {
            return new ImagePlusImgLoader<FloatType>(imp, VirtualStackImageLoader.createUnsignedByteInstance(imp), minMaxOption, min, max, new FloatType(), new RealFloatConverterFactory());
        }
        return new ImagePlusImgLoader<FloatType>(imp, ImageStackImageLoader.createUnsignedByteInstance(imp), minMaxOption, min, max, new FloatType(), new RealFloatConverterFactory());
    }

    public static ImagePlusImgLoader<UnsignedShortType> createGray16(ImagePlus imp, MinMaxOption minMaxOption, double min, double max) {
        if (imp.getType() != 1) {
            throw new RuntimeException("expected ImagePlus type GRAY16");
        }
        if (imp.getStack() != null && imp.getStack().isVirtual()) {
            return new ImagePlusImgLoader<UnsignedShortType>(imp, VirtualStackImageLoader.createUnsignedShortInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
        }
        return new ImagePlusImgLoader<UnsignedShortType>(imp, ImageStackImageLoader.createUnsignedShortInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
    }

    public static ImagePlusImgLoader<UnsignedShortType> createGray32(ImagePlus imp, MinMaxOption minMaxOption, double min, double max) {
        if (imp.getType() != 2) {
            throw new RuntimeException("expected ImagePlus type GRAY32");
        }
        if (imp.getStack() != null && imp.getStack().isVirtual()) {
            return new ImagePlusImgLoader<UnsignedShortType>(imp, VirtualStackImageLoader.createFloatInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
        }
        return new ImagePlusImgLoader<UnsignedShortType>(imp, ImageStackImageLoader.createFloatInstance(imp), minMaxOption, min, max, new UnsignedShortType(), new RealUnsignedShortConverterFactory());
    }

    protected <S extends RealType<S> & NativeType<S>> ImagePlusImgLoader(ImagePlus imp, TypedBasicImgLoader<S> loader, MinMaxOption minMaxOption, double min, double max, T type, ConverterFactory<T> converterFactory) {
        this.imp = imp;
        this.loader = loader;
        this.type = type;
        this.converterFactory = converterFactory;
        int numSetups = imp.getNChannels();
        this.setupImgLoaders = new ArrayList();
        for (int setupId = 0; setupId < numSetups; ++setupId) {
            this.setupImgLoaders.add(new SetupImgLoader(loader.getSetupImgLoader(setupId)));
        }
        this.loadercache = loader instanceof VirtualStackImageLoader ? ((VirtualStackImageLoader)loader).getCacheControl() : null;
        if (minMaxOption == MinMaxOption.COMPUTE) {
            this.impMin = Double.POSITIVE_INFINITY;
            this.impMax = Double.NEGATIVE_INFINITY;
            RealType minT = (RealType)((RealType)loader.getSetupImgLoader(0).getImageType()).createVariable();
            RealType maxT = (RealType)minT.createVariable();
            int numTimepoints = imp.getNFrames();
            for (int t = 0; t < numTimepoints; ++t) {
                for (int s = 0; s < numSetups; ++s) {
                    ComputeMinMax.computeMinMax((RandomAccessibleInterval)loader.getSetupImgLoader(s).getImage(t, new ImgLoaderHint[0]), (Comparable)minT, (Comparable)maxT);
                    this.impMin = Math.min(minT.getRealDouble(), this.impMin);
                    this.impMax = Math.max(maxT.getRealDouble(), this.impMax);
                    if (this.loadercache == null) continue;
                    this.loadercache.clearCache();
                }
            }
            System.out.println("COMPUTE");
            System.out.println(this.impMin + "  " + this.impMax);
        } else if (minMaxOption == MinMaxOption.TAKE_FROM_IMAGEPROCESSOR) {
            this.impMin = imp.getDisplayRangeMin();
            this.impMax = imp.getDisplayRangeMax();
            System.out.println("TAKE_FROM_IMAGEPROCESSOR");
            System.out.println(this.impMin + "  " + this.impMax);
        } else {
            this.impMin = min;
            this.impMax = max;
            System.out.println("SET");
            System.out.println(this.impMin + "  " + this.impMax);
        }
    }

    public void clearCache() {
        if (this.loadercache != null) {
            this.loadercache.clearCache();
            System.runFinalization();
            System.gc();
        }
    }

    public SetupImgLoader<?> getSetupImgLoader(int setupId) {
        return this.setupImgLoaders.get(setupId);
    }

    public class SetupImgLoader<S extends RealType<S> & NativeType<S>>
    implements BasicSetupImgLoader<T> {
        final BasicSetupImgLoader<S> loader;

        protected SetupImgLoader(BasicSetupImgLoader<S> loader) {
            this.loader = loader;
        }

        public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
            if (ImagePlusImgLoader.this.loadercache != null) {
                ImagePlusImgLoader.this.loadercache.clearCache();
            }
            RandomAccessibleInterval img = this.loader.getImage(timepointId, new ImgLoaderHint[0]);
            return Converters.convert((RandomAccessibleInterval)img, ImagePlusImgLoader.this.converterFactory.create(ImagePlusImgLoader.this.impMin, ImagePlusImgLoader.this.impMax), (Type)ImagePlusImgLoader.this.type.createVariable());
        }

        public T getImageType() {
            return ImagePlusImgLoader.this.type;
        }
    }

    static class RealFloatConverterFactory
    implements ConverterFactory<FloatType> {
        RealFloatConverterFactory() {
        }

        @Override
        public <S extends RealType<S> & NativeType<S>> Converter<S, FloatType> create(double min, double max) {
            return new RealFloatConverter();
        }
    }

    static class RealUnsignedShortConverterFactory
    implements ConverterFactory<UnsignedShortType> {
        RealUnsignedShortConverterFactory() {
        }

        @Override
        public <S extends RealType<S> & NativeType<S>> Converter<S, UnsignedShortType> create(double min, double max) {
            return new RealUnsignedShortConverter(min, max);
        }
    }

    public static interface ConverterFactory<T> {
        public <S extends RealType<S> & NativeType<S>> Converter<S, T> create(double var1, double var3);
    }

    public static enum MinMaxOption {
        SET,
        COMPUTE,
        TAKE_FROM_IMAGEPROCESSOR;

    }
}

