/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.swing.JOptionPane;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import org.scijava.Context;
import sc.fiji.labkit.ui.Preferences;
import sc.fiji.labkit.ui.inputimage.ImgPlusViewsOld;
import sc.fiji.labkit.ui.inputimage.InputImage;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.labeling.LabelingSerializer;

public class InitialLabeling {
    public static Labeling initialLabeling(Context context, InputImage inputImage) {
        Preferences preferences = new Preferences(context);
        List<String> defaultLabels = preferences.getDefaultLabels();
        return InitialLabeling.initLabeling(inputImage, context, defaultLabels);
    }

    static Labeling initLabeling(InputImage inputImage, Context context, List<String> defaultLabels) {
        String filename = inputImage.getDefaultLabelingFilename();
        if (new File(filename).exists()) {
            try {
                return InitialLabeling.openLabeling(inputImage, context, filename);
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return InitialLabeling.defaultLabeling(inputImage, defaultLabels);
    }

    private static Labeling defaultLabeling(InputImage inputImage, List<String> defaultLabels) {
        ImgPlus<? extends NumericType<?>> image = inputImage.imageForSegmentation();
        FinalInterval bigInterval = new FinalInterval(ImgPlusViewsOld.hyperSlice(image, Axes.CHANNEL, 0L));
        Interval smallInterval = InitialLabeling.askShrinkInterval((Interval)bigInterval);
        int scaling = InitialLabeling.getIntegerScale(smallInterval, (Interval)bigInterval).getAsInt();
        Labeling labeling = Labeling.createEmpty(defaultLabels, smallInterval);
        labeling.setAxes(InitialLabeling.scaledAxes((double)scaling, InitialLabeling.filterChannelAxis(ImgPlusViewsOld.getCalibratedAxes(image))));
        return labeling;
    }

    private static List<CalibratedAxis> filterChannelAxis(List<CalibratedAxis> calibratedAxes) {
        return calibratedAxes.stream().filter(axis -> axis.type() != Axes.CHANNEL).collect(Collectors.toList());
    }

    private static Labeling openLabeling(InputImage inputImage, Context context, String filename) throws IOException {
        Labeling open = new LabelingSerializer(context).open(filename);
        InitialLabeling.fixAxes(open, inputImage);
        return open;
    }

    private static void fixAxes(Labeling labeling, InputImage image) {
        ImgPlus<? extends NumericType<?>> imgPlus = image.imageForSegmentation();
        if (!imgPlus.getName().endsWith(".czi")) {
            return;
        }
        List<CalibratedAxis> labelingAxes = labeling.axes();
        List<CalibratedAxis> imageAxes = InitialLabeling.filterChannelAxis(ImgPlusViewsOld.getCalibratedAxes(imgPlus));
        ImgPlus<? extends NumericType<?>> imageInterval = imgPlus;
        Interval labelingInterval = labeling.interval();
        OptionalDouble optionalDouble = InitialLabeling.getScale(labelingInterval, imageInterval);
        if (!optionalDouble.isPresent()) {
            String message = "\"" + image.getDefaultLabelingFilename() + "\"\nThe labeling does not match the image sizes.\nLabkit might give wrong results.\nIt's recommended to delete the labeling and start from scratch again.";
            JOptionPane.showMessageDialog(null, message, "WARNING", 0);
            return;
        }
        double scale = optionalDouble.getAsDouble();
        boolean calibrationCorrect = IntStream.range(0, labelingAxes.size()).allMatch(i -> InitialLabeling.getLinearScale((CalibratedAxis)imageAxes.get(i)) * scale == InitialLabeling.getLinearScale((CalibratedAxis)labelingAxes.get(i)));
        if (calibrationCorrect) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Labeling contains wrong calibration information.\nFix it?", "Open Labeling", 2);
        if (result == 0) {
            labeling.setAxes(InitialLabeling.scaledAxes(scale, imageAxes));
        }
    }

    private static OptionalDouble getScale(Interval labelingInterval, Interval imageInterval) {
        OptionalInt scale = InitialLabeling.getIntegerScale(labelingInterval, imageInterval);
        if (scale.isPresent()) {
            return OptionalDouble.of(scale.getAsInt());
        }
        OptionalInt reverseScale = InitialLabeling.getIntegerScale(imageInterval, labelingInterval);
        if (reverseScale.isPresent()) {
            return OptionalDouble.of(1.0 / (double)reverseScale.getAsInt());
        }
        return OptionalDouble.empty();
    }

    private static OptionalInt getIntegerScale(Interval small, Interval big) {
        int scale = (int)(big.dimension(0) / small.dimension(0));
        if (scale <= 0) {
            return OptionalInt.empty();
        }
        boolean isIntegerScale = IntStream.range(0, small.numDimensions()).allMatch(i -> big.dimension(i) / (long)scale == small.dimension(i));
        return isIntegerScale ? OptionalInt.of(scale) : OptionalInt.empty();
    }

    private static List<CalibratedAxis> scaledAxes(double factor, List<CalibratedAxis> imageAxes) {
        if (factor == 1.0) {
            return imageAxes;
        }
        return imageAxes.stream().map(axis -> InitialLabeling.scaledAxes(factor, (DefaultLinearAxis)axis)).collect(Collectors.toList());
    }

    private static CalibratedAxis scaledAxes(double factor, DefaultLinearAxis input) {
        return new DefaultLinearAxis(input.type(), input.unit(), input.scale() * factor, input.origin());
    }

    private static double getLinearScale(CalibratedAxis downScaled) {
        return ((DefaultLinearAxis)downScaled).scale();
    }

    private static Interval askShrinkInterval(Interval interval) {
        Object selected;
        if (interval.numDimensions() != 2) {
            return interval;
        }
        if (!InitialLabeling.consideredBig(interval)) {
            return interval;
        }
        interval = new FinalInterval(interval);
        ArrayList<Interval> suggestions = new ArrayList<Interval>();
        suggestions.add(interval);
        while (InitialLabeling.consideredBig(interval)) {
            interval = InitialLabeling.shrink(interval);
            suggestions.add(interval);
        }
        List texts = suggestions.stream().map(i -> i.dimension(0) + "x" + i.dimension(1)).collect(Collectors.toList());
        int index = texts.indexOf(selected = JOptionPane.showInputDialog(null, "Select resultion of the labeling", "Labekit", -1, null, texts.toArray(), texts.get(texts.size() - 1)));
        return index >= 0 ? (Interval)suggestions.get(index) : interval;
    }

    private static Interval shrink(Interval interval) {
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)interval);
        long[] newDimensions = LongStream.of(dimensions).map(x -> x / 2L).toArray();
        return new FinalInterval(newDimensions);
    }

    private static boolean consideredBig(Interval interval) {
        return Intervals.numElements((Dimensions)interval) > 10000000L;
    }
}

