/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.utils.sparse;

import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.Arrays;
import net.imglib2.AbstractCursor;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.logic.BitType;
import sc.fiji.labkit.ui.utils.sparse.IntervalIndexer2;

public class SparseIterableRegion
extends AbstractWrappedInterval<Interval>
implements IterableRegion<BitType> {
    private final TLongSet codes;
    private final IntervalIndexer2 indexer;
    private final InsideIterable inside;

    public SparseIterableRegion(Interval interval) {
        this(interval, (TLongSet)new TLongHashSet());
    }

    public SparseIterableRegion(Interval interval, TLongSet positions) {
        super(interval);
        this.codes = positions;
        this.indexer = new IntervalIndexer2(interval);
        this.inside = new InsideIterable();
    }

    public void add(Localizable position) {
        this.codes.add(this.indexer.positionToIndex(position));
    }

    public void remove(Localizable position) {
        this.codes.remove(this.indexer.positionToIndex(position));
    }

    private boolean contains(Localizable position) {
        return this.codes.contains(this.indexer.positionToIndex(position));
    }

    public RandomAccess<BitType> randomAccess() {
        return new SparseRoiRandomAccess();
    }

    public RandomAccess<BitType> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public IterableInterval<Void> inside() {
        return this.inside;
    }

    public BitType getType() {
        return new BitType();
    }

    private class SparseRoiRandomAccess
    extends Point
    implements RandomAccess<BitType> {
        private BitType value;

        private SparseRoiRandomAccess() {
            super(SparseIterableRegion.this.numDimensions());
            this.value = new BitType((LongAccess)new LongArray(1)){

                public void set(boolean value) {
                    if (value) {
                        SparseIterableRegion.this.add((Localizable)SparseRoiRandomAccess.this);
                    } else {
                        SparseIterableRegion.this.remove((Localizable)SparseRoiRandomAccess.this);
                    }
                }

                public boolean get() {
                    return SparseIterableRegion.this.contains((Localizable)SparseRoiRandomAccess.this);
                }
            };
        }

        private SparseRoiRandomAccess(Localizable localizable) {
            super(localizable);
            this.value = new /* invalid duplicate definition of identical inner class */;
        }

        public RandomAccess<BitType> copy() {
            return new SparseRoiRandomAccess((Localizable)this);
        }

        public BitType get() {
            return this.value;
        }
    }

    private class SparseRoiCursor
    extends AbstractCursor<Void>
    implements Cursor<Void> {
        private final long[] sortedCodes;
        private final int lastIndex;
        private final Point point;
        private int i;

        private SparseRoiCursor() {
            super(SparseIterableRegion.this.numDimensions());
            this.point = new Point(SparseIterableRegion.this.numDimensions());
            this.sortedCodes = SparseIterableRegion.this.codes.toArray();
            Arrays.sort(this.sortedCodes);
            this.lastIndex = this.sortedCodes.length - 1;
            this.reset();
        }

        public Void get() {
            return null;
        }

        public SparseRoiCursor copy() {
            throw new UnsupportedOperationException();
        }

        public void fwd() {
            ++this.i;
            SparseIterableRegion.this.indexer.indexToPosition(this.sortedCodes[this.i], (Positionable)this.point);
        }

        public void reset() {
            this.i = -1;
        }

        public boolean hasNext() {
            return this.i < this.lastIndex;
        }

        public void localize(long[] position) {
            this.point.localize(position);
        }

        public long getLongPosition(int d) {
            return this.point.getLongPosition(d);
        }
    }

    private class InsideIterable
    extends AbstractWrappedInterval<Interval>
    implements IterableInterval<Void> {
        InsideIterable() {
            super((Interval)SparseIterableRegion.this);
        }

        public Cursor<Void> cursor() {
            return new SparseRoiCursor();
        }

        public Cursor<Void> localizingCursor() {
            return this.cursor();
        }

        public long size() {
            return SparseIterableRegion.this.codes.size();
        }

        public Void firstElement() {
            return null;
        }

        public Object iterationOrder() {
            return this;
        }
    }
}

