/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import stitching.CommonFunctions;
import stitching.GridLayout;
import stitching.ImageInformation;
import stitching.model.Model;
import stitching.model.TranslationModel2D;
import stitching.model.TranslationModel3D;
import stitching.utils.Log;

public class Stitch_Image_Grid
implements PlugIn {
    private String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public static int gridSizeXStatic = 3;
    public static int gridSizeYStatic = 3;
    public static double overlapStatic = 20.0;
    public static String directoryStatic = "";
    public static String fileNamesStatic = "TiledConfocal_{ii}.lsm";
    public static String rgbOrderStatic = CommonFunctions.rgbTypes[0];
    public static String tileConfStatic = "TileConfiguration.txt";
    public static boolean writeOnlyTileConfStatic = false;
    public static int startXStatic = 1;
    public static int startYStatic = 1;
    public static int startIStatic = 1;
    public static String handleRGBStatic = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;
    public static boolean previewOnlyStatic = false;
    public static boolean computeOverlapStatic = true;

    public void run(String arg0) {
        boolean computeOverlap;
        boolean previewOnly;
        String fusionMethod;
        String handleRGB;
        int startI;
        int startY;
        int startX;
        boolean writeOnlyOutput;
        String output;
        String filenames;
        String directory;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Image Grid");
        GridLayout gridLayout = new GridLayout();
        gd.addNumericField("grid_size_x", (double)gridSizeXStatic, 0);
        gd.addNumericField("grid_size_y", (double)gridSizeYStatic, 0);
        gd.addSlider("overlap [%]", 0.0, 100.0, overlapStatic);
        gd.addDirectoryField("directory", directoryStatic, 50);
        gd.addStringField("file_names", fileNamesStatic, 50);
        gd.addChoice("rgb_order", CommonFunctions.rgbTypes, rgbOrderStatic);
        gd.addStringField("Output_file_name", tileConfStatic, 50);
        gd.addCheckbox("Save_Only_Tile_Configuration", writeOnlyTileConfStatic);
        gd.addNumericField("start_x", (double)startXStatic, 0);
        gd.addNumericField("start_y", (double)startYStatic, 0);
        gd.addNumericField("start_i", (double)startIStatic, 0);
        gd.addChoice("channels_for_registration", CommonFunctions.colorList, handleRGBStatic);
        gd.addChoice("fusion_method", CommonFunctions.methodListCollection, fusionMethodStatic);
        gd.addNumericField("fusion_alpha", alphaStatic, 2);
        gd.addNumericField("regression_threshold", thresholdRStatic, 2);
        gd.addNumericField("max/avg_displacement_threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("absolute_displacement_threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addCheckbox("create_only_preview", previewOnlyStatic);
        gd.addCheckbox("compute_overlap (otherwise use the coordinates given in the layout file)", computeOverlapStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, this.myURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        gridLayout.sizeX = (int)Math.round(gd.getNextNumber());
        gridLayout.sizeY = (int)Math.round(gd.getNextNumber());
        gridSizeXStatic = gridLayout.sizeX;
        gridSizeYStatic = gridLayout.sizeY;
        double overlap = gd.getNextNumber() / 100.0;
        overlapStatic = overlap * 100.0;
        directoryStatic = directory = gd.getNextString();
        fileNamesStatic = filenames = gd.getNextString();
        rgbOrderStatic = gridLayout.rgbOrder = gd.getNextChoice();
        tileConfStatic = output = gd.getNextString();
        writeOnlyTileConfStatic = writeOnlyOutput = gd.getNextBoolean();
        startXStatic = startX = (int)Math.round(gd.getNextNumber());
        startYStatic = startY = (int)Math.round(gd.getNextNumber());
        startIStatic = startI = (int)Math.round(gd.getNextNumber());
        handleRGBStatic = handleRGB = gd.getNextChoice();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = gridLayout.alpha = gd.getNextNumber();
        thresholdRStatic = gridLayout.thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = gridLayout.thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = gridLayout.thresholdDisplacementAbsolute = gd.getNextNumber();
        previewOnlyStatic = previewOnly = gd.getNextBoolean();
        computeOverlapStatic = computeOverlap = gd.getNextBoolean();
        Stitch_Image_Grid.stitchImageGrid(filenames, directory, gridLayout, handleRGB, fusionMethod, output, overlap, startX, startY, startI, writeOnlyOutput, previewOnly, computeOverlap);
    }

    public static ImagePlus stitchImageGrid(String filenames, String inputDirectory, GridLayout gridLayout, String handleRGB, String fusionMethod, String outputFileName, double overlap, int startX, int startY, int startI, boolean writeOnlyOutput, boolean previewOnly, boolean computeOverlap) {
        String replaceX = "{";
        String replaceY = "{";
        String replaceI = "{";
        int numXValues = 0;
        int numYValues = 0;
        int numIValues = 0;
        int x1 = filenames.indexOf("{x");
        int x2 = filenames.indexOf("x}");
        if (x1 >= 0 && x2 > 0) {
            numXValues = x2 - x1;
            for (int i = 0; i < numXValues; ++i) {
                replaceX = replaceX + "x";
            }
            replaceX = replaceX + "}";
        } else {
            replaceX = "\\\\\\\\";
        }
        int y1 = filenames.indexOf("{y");
        int y2 = filenames.indexOf("y}");
        if (y1 >= 0 && y2 > 0) {
            numYValues = y2 - y1;
            for (int i = 0; i < numYValues; ++i) {
                replaceY = replaceY + "y";
            }
            replaceY = replaceY + "}";
        } else {
            replaceY = "\\\\\\\\";
        }
        int i1 = filenames.indexOf("{i");
        int i2 = filenames.indexOf("i}");
        if (i1 >= 0 && i2 > 0) {
            numIValues = i2 - i1;
            for (int i = 0; i < numIValues; ++i) {
                replaceI = replaceI + "i";
            }
            replaceI = replaceI + "}";
        } else {
            replaceI = "\\\\\\\\";
        }
        inputDirectory = inputDirectory.replace('\\', '/');
        inputDirectory = inputDirectory.trim();
        if (inputDirectory.length() > 0 && !inputDirectory.endsWith("/")) {
            inputDirectory = inputDirectory + "/";
        }
        gridLayout.fusionMethod = fusionMethod;
        gridLayout.handleRGB = handleRGB;
        gridLayout.imageInformationList = new ArrayList();
        String fileName = inputDirectory + outputFileName;
        PrintWriter out = Stitch_Image_Grid.openFileWrite(fileName);
        int imgX = 0;
        int imgY = 0;
        int i = 0;
        int xoffset = 0;
        int yoffset = 0;
        int zoffset = 0;
        int dim = 0;
        for (int y = 0; y < gridLayout.sizeY; ++y) {
            yoffset = y == 0 ? 0 : (yoffset += (int)((double)imgY * (1.0 - overlap)));
            for (int x = 0; x < gridLayout.sizeX; ++x) {
                int xs = x + startX;
                int ys = y + startY;
                int is = i + startI;
                String file = filenames.replace(replaceX, Stitch_Image_Grid.getLeadingZeros(numXValues, xs));
                file = file.replace(replaceY, Stitch_Image_Grid.getLeadingZeros(numYValues, ys));
                file = file.replace(replaceI, Stitch_Image_Grid.getLeadingZeros(numIValues, is));
                if (i == 0) {
                    ImagePlus imp = CommonFunctions.loadImage(inputDirectory, file, -1, gridLayout.rgbOrder);
                    if (imp == null) {
                        IJ.error((String)("Cannot open first file: '" + inputDirectory + file + "' - Quitting."));
                        return null;
                    }
                    gridLayout.dim = imp.getStackSize() > 1 ? 3 : 2;
                    imgX = imp.getWidth();
                    imgY = imp.getHeight();
                    dim = imp.getStackSize() > 1 ? 3 : 2;
                    if (out != null) {
                        out.println("# Define the number of dimensions we are working on");
                        out.println("dim = " + dim);
                        out.println("");
                        out.println("# Define the image coordinates");
                    }
                    imp.close();
                }
                if (x == 0 && y == 0) {
                    zoffset = 0;
                    yoffset = 0;
                    xoffset = 0;
                }
                xoffset = x == 0 ? 0 : (xoffset += (int)((double)imgX * (1.0 - overlap)));
                if (out != null) {
                    if (dim == 3) {
                        out.println(inputDirectory + file + "; ; (" + xoffset + ", " + yoffset + ", " + zoffset + ")");
                    } else {
                        out.println(inputDirectory + file + "; ; (" + xoffset + ", " + yoffset + ")");
                    }
                }
                ImageInformation iI = dim == 3 ? new ImageInformation(3, i, (Model)new TranslationModel3D()) : new ImageInformation(2, i, (Model)new TranslationModel2D());
                iI.imageName = inputDirectory + file;
                iI.imp = null;
                iI.offset[0] = xoffset;
                iI.offset[1] = yoffset;
                iI.position[0] = xoffset;
                iI.position[1] = yoffset;
                if (dim == 3) {
                    iI.offset[2] = zoffset;
                    iI.position[2] = zoffset;
                }
                gridLayout.imageInformationList.add(iI);
                ++i;
            }
        }
        if (out != null) {
            out.close();
        }
        if (writeOnlyOutput) {
            return null;
        }
        Stitch_Image_Collection smc = new Stitch_Image_Collection();
        return smc.work(gridLayout, previewOnly, computeOverlap, fileName, true);
    }

    public static String getLeadingZeros(int zeros, int number) {
        String output = "" + number;
        while (output.length() < zeros) {
            output = "0" + output;
        }
        return output;
    }

    public static PrintWriter openFileWrite(String fileName) {
        PrintWriter outputFile;
        try {
            outputFile = new PrintWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            Log.error("CreateGridLayout.openFileWrite(): " + e);
            outputFile = null;
        }
        return outputFile;
    }
}

