/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.util.ArrayList;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.units.quantity.Length;
import stitching.CommonFunctions;
import stitching.GridLayout;
import stitching.ImageInformation;
import stitching.model.Model;
import stitching.model.TranslationModel2D;
import stitching.model.TranslationModel3D;
import stitching.utils.Log;

public class Stitch_Multiple_Series_File
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/~preibisch/contact.html";
    public double alpha;
    public double thresholdR;
    public double thresholdDisplacementRelative;
    public double thresholdDisplacementAbsolute;
    public static String fileNameStatic = "";
    public static boolean computeOverlapStatic = true;
    public static double overlapStatic = 10.0;
    public static boolean invertXStatic = false;
    public static boolean invertYStatic = false;
    public static boolean ignoreZStageStatic = false;
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;
    public static boolean previewOnlyStatic = false;
    public static boolean ignoreCalibrationStatic = false;

    public void run(String arg0) {
        boolean previewOnly;
        String fusionMethod;
        boolean ignoreZStage;
        boolean invertY;
        boolean invertX;
        double overlap;
        boolean ignoreCalibration;
        boolean computeOverlap;
        String fileName;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Multiple Series File");
        gd.addFileField("File", fileNameStatic, 50);
        gd.addCheckbox("Compute_overlap (or trust coordinates in the file)", computeOverlapStatic);
        gd.addCheckbox("Ignore_Calibration", ignoreCalibrationStatic);
        gd.addSlider("Increase_overlap [%]", 0.0, 100.0, overlapStatic);
        gd.addCheckbox("Invert_X coordinates", invertXStatic);
        gd.addCheckbox("Invert_Y coordinates", invertYStatic);
        gd.addCheckbox("Ignore_Z_stage position", ignoreZStageStatic);
        gd.addChoice("Fusion_Method", CommonFunctions.methodListCollection, fusionMethodStatic);
        gd.addNumericField("Fusion alpha", alphaStatic, 2);
        gd.addNumericField("Regression Threshold", thresholdRStatic, 2);
        gd.addNumericField("Max/Avg Displacement Threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("Absolute Avg Displacement Threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addCheckbox("Create_only_preview", previewOnlyStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/~preibisch/contact.html");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://fly.mpi-cbg.de/~preibisch/contact.html");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        fileNameStatic = fileName = gd.getNextString();
        computeOverlapStatic = computeOverlap = gd.getNextBoolean();
        ignoreCalibrationStatic = ignoreCalibration = gd.getNextBoolean();
        overlapStatic = overlap = gd.getNextNumber();
        invertXStatic = invertX = gd.getNextBoolean();
        invertYStatic = invertY = gd.getNextBoolean();
        ignoreZStageStatic = ignoreZStage = gd.getNextBoolean();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = this.alpha = gd.getNextNumber();
        thresholdRStatic = this.thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = this.thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = this.thresholdDisplacementAbsolute = gd.getNextNumber();
        previewOnlyStatic = previewOnly = gd.getNextBoolean();
        ArrayList<ImageInformation> imageInformationList = this.parseMultiSeriesFile(fileName, overlap, ignoreCalibration, invertX, invertY, ignoreZStage);
        if (imageInformationList == null) {
            return;
        }
        for (ImageInformation iI : imageInformationList) {
            Log.info(iI.imageName);
            String offset = "";
            for (int d = 0; d < iI.offset.length; ++d) {
                offset = offset + iI.offset[d] + ", ";
            }
            Log.info(offset);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.imageInformationList = imageInformationList;
        gridLayout.fusionMethod = fusionMethod;
        gridLayout.alpha = this.alpha;
        gridLayout.thresholdR = this.thresholdR;
        gridLayout.thresholdDisplacementRelative = this.thresholdDisplacementRelative;
        gridLayout.thresholdDisplacementAbsolute = this.thresholdDisplacementAbsolute;
        gridLayout.dim = imageInformationList.get((int)0).dim;
        gridLayout.rgbOrder = CommonFunctions.rgbTypes[0];
        new Stitch_Image_Collection().work(gridLayout, previewOnly, computeOverlap, fileName + ".txt", true);
    }

    protected ArrayList<ImageInformation> parseMultiSeriesFile(String filename, double increaseOverlap, boolean ignoreCalibration, boolean invertX, boolean invertY, boolean ignoreZStage) {
        if (filename == null || filename.length() == 0) {
            Log.error("Filename is empty!");
            return null;
        }
        ArrayList<ImageInformation> imageInformationList = new ArrayList<ImageInformation>();
        ChannelSeparator r = new ChannelSeparator();
        try {
            int series;
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            r.setMetadataStore((MetadataStore)meta);
            r.setId(filename);
            int numSeries = r.getSeriesCount();
            Log.debug("numSeries:  " + numSeries);
            if (numSeries == 1) {
                Log.error("File contains only one tile: " + filename);
                return null;
            }
            int dim = 2;
            for (series = 0; series < numSeries; ++series) {
                if (r.getSizeZ() <= 1) continue;
                dim = 3;
            }
            Log.debug("dim:  " + dim);
            series = 0;
            while (series < numSeries) {
                ImageInformation iI;
                Log.debug("fetching data for series:  " + series);
                r.setSeries(series);
                MetadataRetrieve retrieve = service.asRetrieve(r.getMetadataStore());
                double[] location = CommonFunctions.getPlanePosition((IFormatReader)r, retrieve, series, 0, invertX, invertY, ignoreZStage);
                double locationX = location[0];
                double locationY = location[1];
                double locationZ = location[2];
                if (!ignoreCalibration) {
                    double calX = 1.0;
                    double calY = 1.0;
                    double calZ = 1.0;
                    String dimOrder = r.getDimensionOrder().toUpperCase();
                    int posX = dimOrder.indexOf(88);
                    Length cal = retrieve.getPixelsPhysicalSizeX(0);
                    if (posX >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                        calX = cal.value().doubleValue();
                    }
                    Log.debug("calibrationX:  " + calX);
                    int posY = dimOrder.indexOf(89);
                    cal = retrieve.getPixelsPhysicalSizeY(0);
                    if (posY >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                        calY = cal.value().doubleValue();
                    }
                    Log.debug("calibrationY:  " + calY);
                    int posZ = dimOrder.indexOf(90);
                    cal = retrieve.getPixelsPhysicalSizeZ(0);
                    if (posZ >= 0 && cal != null && cal.value().doubleValue() != 0.0) {
                        calZ = cal.value().doubleValue();
                    }
                    Log.debug("calibrationZ:  " + calZ);
                    locationX /= calX;
                    locationY /= calY;
                    locationZ /= calZ;
                }
                Log.debug("locationX [px]:  " + locationX);
                Log.debug("locationY [px]:  " + locationY);
                Log.debug("locationZ [px]:  " + locationZ);
                locationX *= (100.0 - increaseOverlap) / 100.0;
                locationY *= (100.0 - increaseOverlap) / 100.0;
                locationZ *= (100.0 - increaseOverlap) / 100.0;
                if (dim == 2) {
                    iI = new ImageInformation(dim, series, (Model)new TranslationModel2D());
                    iI.offset[0] = (float)locationX;
                    iI.position[0] = iI.offset[0];
                    iI.offset[1] = (float)locationY;
                    iI.position[1] = iI.offset[1];
                } else {
                    iI = new ImageInformation(dim, series, (Model)new TranslationModel3D());
                    iI.offset[0] = (float)locationX;
                    iI.position[0] = iI.offset[0];
                    iI.offset[1] = (float)locationY;
                    iI.position[1] = iI.offset[1];
                    iI.offset[2] = (float)locationZ;
                    iI.position[2] = iI.offset[2];
                }
                iI.imageName = filename;
                iI.imp = null;
                iI.seriesNumber = series++;
                imageInformationList.add(iI);
            }
        }
        catch (Exception ex) {
            Log.error(ex);
            return null;
        }
        return imageInformationList;
    }
}

