/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.TextComponent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.List;
import java.util.Vector;
import mpicbg.stitching.ImageCollectionElement;

public class Downsampler {
    private TextComponent xField;
    private TextComponent yField;
    private TextComponent widthField;
    private TextComponent heightField;
    private Object fieldWithFocus;
    private int originalWidth;
    private int originalHeight;
    private double xScale;
    private double yScale;
    private String params = null;
    private final DownsampleTextListener textListener = new DownsampleTextListener();
    private final DownsampleFocusListener focusListener = new DownsampleFocusListener();

    public void getInput(int imgWidth, int imgHeight) {
        this.originalWidth = imgWidth;
        this.originalHeight = imgHeight;
        GenericDialogPlus gdDownSample = new GenericDialogPlus("Downsample");
        String[] methods = ImageProcessor.getInterpolationMethods();
        gdDownSample.addNumericField("x scale", 1.0, 1);
        gdDownSample.addNumericField("y scale", 1.0, 1);
        gdDownSample.addNumericField("width (pixels)", (double)imgWidth, 0);
        gdDownSample.addNumericField("height (pixels)", (double)imgHeight, 0);
        gdDownSample.addChoice("Interpolation:", methods, methods[methods.length - 1]);
        gdDownSample.addCheckbox("Average when downsizing", true);
        Vector fields = gdDownSample.getNumericFields();
        this.xField = (TextComponent)fields.get(0);
        this.yField = (TextComponent)fields.get(1);
        this.widthField = (TextComponent)fields.get(2);
        this.heightField = (TextComponent)fields.get(3);
        this.xField.addTextListener(this.textListener);
        this.xField.addFocusListener(this.focusListener);
        this.yField.addTextListener(this.textListener);
        this.yField.addFocusListener(this.focusListener);
        this.widthField.addTextListener(this.textListener);
        this.widthField.addFocusListener(this.focusListener);
        this.heightField.addTextListener(this.textListener);
        this.heightField.addFocusListener(this.focusListener);
        gdDownSample.showDialog();
        if (gdDownSample.wasOKed()) {
            this.xScale = gdDownSample.getNextNumber();
            this.yScale = gdDownSample.getNextNumber();
            double width = gdDownSample.getNextNumber();
            double height = gdDownSample.getNextNumber();
            String method = gdDownSample.getNextChoice();
            String average = gdDownSample.getNextBoolean() ? " average" : "";
            this.params = "width=" + width + " height=" + height + average + " interpolation=" + method;
        }
    }

    public boolean hasInput() {
        return this.params != null;
    }

    public void run(ImagePlus ... imps) {
        this.checkInit();
        for (int i = 0; i < imps.length; ++i) {
            ImagePlus imp = imps[i];
            IJ.run((ImagePlus)imp, (String)"Size...", (String)this.params);
        }
    }

    public void run(ImageCollectionElement element) {
        this.checkInit();
        if (element.getOffset() == null) {
            return;
        }
        float[] fArray = element.getOffset();
        fArray[0] = (float)((double)fArray[0] * this.xScale);
        float[] fArray2 = element.getOffset();
        fArray2[1] = (float)((double)fArray2[1] * this.yScale);
    }

    public void run(List<ImageCollectionElement> elements) {
        this.checkInit();
        for (ImageCollectionElement element : elements) {
            this.run(element);
        }
    }

    private void checkInit() {
        if (!this.hasInput()) {
            throw new IllegalStateException("Downsample failed: please run getInput before attempting to downsample.");
        }
    }

    private class DownsampleTextListener
    implements TextListener {
        private DownsampleTextListener() {
        }

        @Override
        public void textValueChanged(TextEvent e) {
            Object source = e.getSource();
            try {
                Double widthText = Double.parseDouble(Downsampler.this.widthField.getText());
                Double heightText = Double.parseDouble(Downsampler.this.heightField.getText());
                Double xText = Double.parseDouble(Downsampler.this.xField.getText());
                Double yText = Double.parseDouble(Downsampler.this.yField.getText());
                if (source == Downsampler.this.widthField && Downsampler.this.widthField == Downsampler.this.fieldWithFocus) {
                    double newX = widthText / (double)Downsampler.this.originalWidth;
                    Downsampler.this.xField.setText(String.valueOf(newX));
                } else if (source == Downsampler.this.heightField && Downsampler.this.heightField == Downsampler.this.fieldWithFocus) {
                    double newY = heightText / (double)Downsampler.this.originalHeight;
                    Downsampler.this.yField.setText(String.valueOf(newY));
                } else if (source == Downsampler.this.xField && Downsampler.this.xField == Downsampler.this.fieldWithFocus) {
                    int newWidth = (int)Math.round(xText * (double)Downsampler.this.originalWidth);
                    Downsampler.this.widthField.setText(String.valueOf(newWidth));
                } else if (source == Downsampler.this.yField && Downsampler.this.yField == Downsampler.this.fieldWithFocus) {
                    int newHeight = (int)Math.round(yText * (double)Downsampler.this.originalHeight);
                    Downsampler.this.heightField.setText(String.valueOf(newHeight));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private class DownsampleFocusListener
    implements FocusListener {
        private DownsampleFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            Downsampler.this.fieldWithFocus = e.getSource();
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

