/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.display;

import java.util.List;
import net.imagej.Data;
import net.imagej.display.DataView;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.display.OverlayView;
import net.imagej.overlay.Overlay;
import org.scijava.display.DisplayService;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginService;
import org.scijava.script.ScriptService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public final class DefaultImageDisplayService
extends AbstractService
implements ImageDisplayService {
    @Parameter
    private EventService eventService;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ScriptService scriptService;

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public PluginService getPluginService() {
        return this.pluginService;
    }

    @Override
    public DisplayService getDisplayService() {
        return this.displayService;
    }

    @Override
    public DataView createDataView(Data data) {
        for (DataView dataView : this.getDataViews()) {
            if (!dataView.isCompatible(data)) continue;
            dataView.initialize(data);
            return dataView;
        }
        throw new IllegalArgumentException("No data view found for data: " + data);
    }

    @Override
    public List<? extends DataView> getDataViews() {
        return this.pluginService.createInstancesOfType(DataView.class);
    }

    @Override
    public ImageDisplay getActiveImageDisplay() {
        return (ImageDisplay)this.displayService.getActiveDisplay(ImageDisplay.class);
    }

    @Override
    public List<ImageDisplay> getImageDisplays() {
        return this.displayService.getDisplaysOfType(ImageDisplay.class);
    }

    public void initialize() {
        this.scriptService.addAlias(ImageDisplay.class);
        this.scriptService.addAlias(DatasetView.class);
        this.scriptService.addAlias(DataView.class);
        this.scriptService.addAlias(OverlayView.class);
        this.scriptService.addAlias(Overlay.class);
    }
}

