/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.process.ByteProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Connector;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Dissector;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Node;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Stack;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Taggable;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.imaging.filters.IFilter;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.tree.DTDParser;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.ReconstructArea;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.regex.Pattern;
import mpicbg.models.TransformList;
import mpicbg.trakem2.transform.CoordinateTransform;
import mpicbg.trakem2.transform.CoordinateTransformList;
import mpicbg.trakem2.transform.InvertibleCoordinateTransform;
import mpicbg.trakem2.transform.InvertibleCoordinateTransformList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TMLHandler
extends DefaultHandler {
    private LayerThing root_lt = null;
    private ProjectThing root_pt = null;
    private TemplateThing root_tt = null;
    private TemplateThing project_tt = null;
    private TemplateThing template_layer_thing = null;
    private TemplateThing template_layer_set_thing = null;
    private Project project = null;
    private final FSLoader loader;
    private boolean skip = false;
    private final HashMap<Displayable, String> ht_links = new HashMap();
    private final ArrayList<Thing> al_open = new ArrayList();
    private final ArrayList<Layer> al_layers = new ArrayList();
    private final ArrayList<LayerSet> al_layer_sets = new ArrayList();
    private final ArrayList<HashMap<String, String>> al_displays = new ArrayList();
    private final HashMap<Long, Displayable> ht_displayables = new HashMap();
    private final HashMap<Long, ZDisplayable> ht_zdispl = new HashMap();
    private final HashMap<Long, ProjectThing> ht_oid_pt = new HashMap();
    private final HashMap<ProjectThing, Boolean> ht_pt_expanded = new HashMap();
    private Ball last_ball = null;
    private AreaList last_area_list = null;
    private long last_area_list_layer_id = -1L;
    private Dissector last_dissector = null;
    private Stack last_stack = null;
    private Patch last_patch = null;
    private CoordinateTransform last_ct = null;
    private InvertibleCoordinateTransform last_ict = null;
    private final ArrayList<IFilter> last_patch_filters = new ArrayList();
    private Treeline last_treeline = null;
    private AreaTree last_areatree = null;
    private Connector last_connector = null;
    private Tree<?> last_tree = null;
    private final LinkedList<Taggable> taggables = new LinkedList();
    private ReconstructArea reca = null;
    private Node<?> last_root_node = null;
    private final LinkedList<Node<?>> nodes = new LinkedList();
    private final Map<Long, List<Node<?>>> node_layer_table = new HashMap();
    private final Map<Tree<?>, Node<?>> tree_root_nodes = new HashMap();
    private final Map<Color, Collection<Node<?>>> node_colors = new HashMap();
    private StringBuilder last_treeline_data = null;
    private Displayable last_displayable = null;
    private StringBuilder last_annotation = null;
    private final ArrayList<TransformList<Object>> ct_list_stack = new ArrayList();
    private boolean open_displays = true;
    private final LinkedList<Runnable> legacy = new LinkedList();
    private int counter = 0;
    private static final String[] all_displayables = new String[]{"t2_area_list", "t2_patch", "t2_pipe", "t2_polyline", "t2_ball", "t2_label", "t2_dissector", "t2_profile", "t2_stack", "t2_treeline", "t2_areatree", "t2_connector"};
    private final Map<Displayable, Map<Long, Map<String, String>>> all_linked_props = new HashMap<Displayable, Map<Long, Map<String, String>>>();

    public TMLHandler(String path, FSLoader loader) {
        TemplateThing[] tt;
        this.loader = loader;
        try {
            tt = DTDParser.extractTemplate(path);
            if (null == tt) {
                Utils.log("TMLHandler: can't read DTD in file " + path);
                loader = null;
                return;
            }
        }
        catch (Exception e) {
            loader = null;
            IJError.print(e);
            return;
        }
        this.root_tt = tt[0];
        if (tt.length > 1) {
            Pattern icts = Pattern.compile("^i{1,2}ct_transform.*$");
            this.root_tt = null;
            for (int k = 0; k < tt.length; ++k) {
                if (icts.matcher(tt[k].getType()).matches()) continue;
                this.root_tt = tt[k];
                break;
            }
        }
        this.template_layer_thing = new TemplateThing("layer");
        this.template_layer_set_thing = new TemplateThing("layer set");
        this.template_layer_set_thing.addChild(this.template_layer_thing);
        this.template_layer_thing.addChild(this.template_layer_set_thing);
        this.project_tt = new TemplateThing("project");
        this.project_tt.addChild(this.root_tt);
    }

    public boolean isUnreadable() {
        return null == this.loader;
    }

    /*
     * WARNING - void declaration
     */
    public Object[] getProjectData(boolean open_displays) {
        if (null == this.project) {
            return null;
        }
        this.open_displays = open_displays;
        for (Displayable displayable : this.ht_displayables.values()) {
            String olinks = this.ht_links.get(displayable);
            if (null == olinks) continue;
            String[] links = olinks.split(",");
            Object var6_27 = null;
            for (int i = 0; i < links.length; ++i) {
                Long l;
                try {
                    l = new Long((String)links[i]);
                }
                catch (NumberFormatException nfe) {
                    Utils.log2("Ignoring incorrectly formated link '" + (String)links[i] + "' for ob " + displayable);
                    continue;
                }
                Displayable partner = this.ht_displayables.get(l);
                if (null != partner) {
                    displayable.link(partner, false);
                    continue;
                }
                Utils.log("TMLHandler: can't find partner with id=" + (String)links[i] + " for Displayable with id=" + displayable.getId());
            }
        }
        for (Map.Entry entry : this.all_linked_props.entrySet()) {
            Displayable origin = (Displayable)entry.getKey();
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                Displayable target = this.ht_displayables.get(entry2.getKey());
                if (null == target) {
                    Utils.log("Setting linked properties for origin " + origin.getId() + ":\n\t* Could not find target displayable #" + entry2.getKey());
                    continue;
                }
                origin.setLinkedProperties(target, (Map)entry2.getValue());
            }
        }
        for (Map.Entry entry : this.ht_oid_pt.entrySet()) {
            ProjectThing pt = (ProjectThing)entry.getValue();
            Displayable od = this.ht_displayables.remove(entry.getKey());
            if (null != od) {
                pt.setObject(od);
                continue;
            }
            Utils.log("#### Failed to find a Displayable for ProjectThing " + pt + " #####");
        }
        for (ZDisplayable zDisplayable : this.ht_zdispl.values()) {
            zDisplayable.setLayer(zDisplayable.getLayerSet().getLayer(0));
        }
        for (Layer layer : this.al_layers) {
            List<Node<?>> list = this.node_layer_table.remove(layer.getId());
            if (null == list) continue;
            for (Node node : list) {
                node.setLayer(layer);
            }
        }
        if (!this.node_layer_table.isEmpty()) {
            Utils.log("ERROR: node_layer_table is not empty!");
        }
        for (Map.Entry entry : this.tree_root_nodes.entrySet()) {
            if (null == entry.getValue()) continue;
            ((Tree)entry.getKey()).setRoot((Node)entry.getValue());
        }
        this.tree_root_nodes.clear();
        for (Map.Entry entry : this.node_colors.entrySet()) {
            for (Node nd : (Collection)entry.getValue()) {
                nd.setColor((Color)entry.getKey());
            }
        }
        this.node_colors.clear();
        for (Runnable runnable : this.legacy) {
            runnable.run();
        }
        try {
            void var3_23;
            HashMap<Long, Layer> ht_lids = new HashMap<Long, Layer>();
            for (Layer layer : this.al_layers) {
                ht_lids.put(new Long(layer.getId()), layer);
            }
            int n = Runtime.getRuntime().availableProcessors();
            switch (n) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    void var3_21;
                    --var3_21;
                    break;
                }
                default: {
                    var3_22 -= 2;
                }
            }
            final ThreadPoolExecutor exec = Utils.newFixedThreadPool((int)var3_23, "TMLHandler-recreateBuckets");
            final HashSet<Long> dlids = new HashSet<Long>();
            final LayerSet layerSet = (LayerSet)this.root_lt.getObject();
            ArrayList fus = new ArrayList();
            final ArrayList fus2 = new ArrayList();
            for (HashMap<String, String> ht_attributes : this.al_displays) {
                String ob = ht_attributes.get("layer_id");
                if (null == ob) continue;
                Long lid = new Long(ob);
                dlids.add(lid);
                final Layer la = (Layer)ht_lids.get(lid);
                if (null == la) {
                    ht_lids.remove(lid);
                    continue;
                }
                new Display(this.project, Long.parseLong(ht_attributes.get("id")), la, ht_attributes);
                fus.add(exec.submit(new Runnable(){

                    @Override
                    public void run() {
                        la.recreateBuckets();
                    }
                }));
            }
            fus.add(exec.submit(new Runnable(){

                @Override
                public void run() {
                    layerSet.recreateBuckets(false);
                }
            }));
            if (dlids.isEmpty() && layerSet.size() > 0) {
                dlids.add(layerSet.getLayer(0).getId());
            }
            final ArrayList<Layer> layers = layerSet.getLayers();
            for (final Long lid : new HashSet(dlids)) {
                fus.add(exec.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int start = layerSet.indexOf(layerSet.getLayer((long)lid));
                        int next = start + 1;
                        int prev = start - 1;
                        while (next < layerSet.size() || prev > -1) {
                            Set set;
                            if (prev > -1) {
                                final Layer lprev = (Layer)layers.get(prev);
                                set = dlids;
                                synchronized (set) {
                                    if (dlids.add(lprev.getId())) {
                                        fus2.add(exec.submit(new Runnable(){

                                            @Override
                                            public void run() {
                                                lprev.recreateBuckets();
                                            }
                                        }));
                                    }
                                }
                                --prev;
                            }
                            if (next >= layers.size()) continue;
                            final Layer lnext = (Layer)layers.get(next);
                            set = dlids;
                            synchronized (set) {
                                if (dlids.add(lnext.getId())) {
                                    fus2.add(exec.submit(new Runnable(){

                                        @Override
                                        public void run() {
                                            lnext.recreateBuckets();
                                        }
                                    }));
                                }
                            }
                            ++next;
                        }
                        Utils.log2("done recreateBuckets chunk");
                    }
                }));
            }
            Utils.wait(fus);
            exec.submit(new Runnable(){

                @Override
                public void run() {
                    Utils.log2("waiting for TMLHandler fus...");
                    Utils.wait(fus2);
                    Utils.log2("done waiting TMLHandler fus.");
                    exec.shutdown();
                }
            });
        }
        catch (Throwable t) {
            IJError.print(t);
        }
        return new Object[]{this.root_tt, this.root_pt, this.root_lt, this.ht_pt_expanded};
    }

    @Override
    public void startElement(String namespace_URI, String local_name, String qualified_name, Attributes attributes) throws SAXException {
        if (null == this.loader) {
            return;
        }
        ++this.counter;
        if (0 == this.counter % 100) {
            Utils.showStatus("Loading " + this.counter, false);
        }
        try {
            qualified_name = qualified_name.toLowerCase();
            HashMap<String, String> ht_attributes = new HashMap<String, String>();
            for (int i = attributes.getLength() - 1; i > -1; --i) {
                ht_attributes.put(attributes.getQName(i).toLowerCase(), attributes.getValue(i));
            }
            DBObject thing = null;
            if (0 == qualified_name.indexOf("t2_")) {
                if (qualified_name.equals("t2_display")) {
                    if (this.open_displays) {
                        this.al_displays.add(ht_attributes);
                    }
                } else {
                    thing = this.makeLayerThing(qualified_name, ht_attributes);
                    if (null != thing && null == this.root_lt && thing.getObject() instanceof LayerSet) {
                        this.root_lt = thing;
                    }
                }
            } else if (qualified_name.equals("project")) {
                if (null != this.root_pt) {
                    Utils.log("WARNING: more than one project definitions.");
                    return;
                }
                this.project = new Project(Long.parseLong(ht_attributes.remove("id")), ht_attributes.remove("title"));
                this.project.setTempLoader(this.loader);
                this.project.parseXMLOptions(ht_attributes);
                this.project.addToDatabase();
                String title = ht_attributes.get("title");
                if (null != title) {
                    this.project.setTitle(title);
                }
                Iterator<TemplateThing> it = this.root_tt.getUniqueTypes(new HashMap<String, TemplateThing>()).values().iterator();
                while (it.hasNext()) {
                    this.project.addUniqueType(it.next());
                }
                this.project.addUniqueType(this.project_tt);
                this.root_pt = new ProjectThing(this.project_tt, this.project, this.project);
                this.root_tt.addToDatabase(this.project);
                thing = this.root_pt;
            } else if (qualified_name.startsWith("ict_transform") || qualified_name.startsWith("iict_transform")) {
                this.makeCoordinateTransform(qualified_name, ht_attributes);
            } else if (!qualified_name.equals("trakem2")) {
                thing = this.makeProjectThing(qualified_name, ht_attributes);
            }
            if (null != thing) {
                int size = this.al_open.size();
                if (size > 0) {
                    Thing parent = this.al_open.get(size - 1);
                    parent.addChild((Thing)((Object)thing));
                }
                this.al_open.add((Thing)((Object)thing));
            }
        }
        catch (Exception e) {
            IJError.print(e);
            this.skip = true;
        }
    }

    @Override
    public void endElement(String namespace_URI, String local_name, String qualified_name) {
        if (null == this.loader) {
            return;
        }
        if (this.skip) {
            this.skip = false;
            return;
        }
        String orig_qualified_name = qualified_name;
        if (0 == (qualified_name = qualified_name.toLowerCase().trim()).indexOf("t2_")) {
            qualified_name = qualified_name.substring(3);
        }
        for (int i = this.al_open.size() - 1; i > -1; --i) {
            Thing thing = this.al_open.get(i);
            if (!thing.getType().toLowerCase().equals(qualified_name)) continue;
            this.al_open.remove(i);
            break;
        }
        if (null != this.last_annotation && null != this.last_displayable) {
            this.last_displayable.setAnnotation(this.last_annotation.toString().trim().replaceAll("&lt;", "<"));
            this.last_annotation = null;
        }
        if (orig_qualified_name.equals("t2_node")) {
            this.nodes.removeLast();
            this.taggables.removeLast();
        } else if (orig_qualified_name.equals("t2_connector")) {
            if (null != this.last_connector) {
                this.tree_root_nodes.put(this.last_connector, this.last_root_node);
                this.last_root_node = null;
                this.last_connector = null;
                this.last_tree = null;
                this.nodes.clear();
            }
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_area_list")) {
            this.last_area_list = null;
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_area")) {
            if (null != this.reca) {
                if (null != this.last_area_list) {
                    this.last_area_list.addArea(this.last_area_list_layer_id, this.reca.getArea());
                } else {
                    ((AreaTree.AreaNode)this.nodes.getLast()).setData(this.reca.getArea());
                }
                this.reca = null;
            }
        } else if (orig_qualified_name.equals("ict_transform_list")) {
            this.ct_list_stack.remove(this.ct_list_stack.size() - 1);
        } else if (orig_qualified_name.equals("t2_patch")) {
            if (this.last_patch_filters.size() > 0) {
                this.last_patch.setFilters(this.last_patch_filters.toArray(new IFilter[this.last_patch_filters.size()]));
            }
            if (null != this.last_ct) {
                this.last_patch.setCoordinateTransformSilently(this.last_ct);
                this.last_ct = null;
            } else if (!this.last_patch.checkCoordinateTransformFile()) {
                Utils.log("ERROR: could not find a file for the coordinate transform #" + this.last_patch.getCoordinateTransformId() + " of Patch #" + this.last_patch.getId());
            }
            if (!this.last_patch.checkAlphaMaskFile()) {
                Utils.log("ERROR: could not find a file for the alpha mask #" + this.last_patch.getAlphaMaskId() + " of Patch #" + this.last_patch.getId());
            }
            this.last_patch = null;
            this.last_patch_filters.clear();
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_ball")) {
            this.last_ball = null;
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_dissector")) {
            this.last_dissector = null;
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_treeline")) {
            if (null != this.last_treeline) {
                if (null == this.last_root_node && null != this.last_treeline_data && this.last_treeline_data.length() > 0) {
                    this.last_root_node = this.parseBranch(Utils.trim(this.last_treeline_data));
                    this.last_treeline_data = null;
                }
                this.tree_root_nodes.put(this.last_treeline, this.last_root_node);
                this.last_root_node = null;
                this.last_treeline = null;
                this.last_tree = null;
                this.nodes.clear();
            }
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_areatree")) {
            if (null != this.last_areatree) {
                this.tree_root_nodes.put(this.last_areatree, this.last_root_node);
                this.last_root_node = null;
                this.last_areatree = null;
                this.last_tree = null;
                this.nodes.clear();
            }
            this.last_displayable = null;
        } else if (orig_qualified_name.equals("t2_stack")) {
            if (null != this.last_ict) {
                this.last_stack.setInvertibleCoordinateTransformSilently(this.last_ict);
                this.last_ict = null;
            }
            this.last_stack = null;
            this.last_displayable = null;
        } else if (this.in(orig_qualified_name, all_displayables)) {
            this.last_displayable = null;
        }
    }

    private final boolean in(String s, String[] all) {
        for (int i = all.length - 1; i > -1; --i) {
            if (!s.equals(all[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void characters(char[] c, int start, int length) {
        if (null != this.last_treeline) {
            this.last_treeline_data.append(c, start, length);
        } else if (null != this.last_annotation) {
            this.last_annotation.append(c, start, length);
        }
    }

    @Override
    public void fatalError(SAXParseException e) {
        Utils.log("Fatal error: column=" + e.getColumnNumber() + " line=" + e.getLineNumber());
    }

    @Override
    public void skippedEntity(String name) {
        Utils.log("SAX Parser has skipped: " + name);
    }

    public void notationDeclaration(String name, String publicId, String systemId) {
        Utils.log("Notation declaration: " + name + ", " + publicId + ", " + systemId);
    }

    @Override
    public void warning(SAXParseException e) {
        Utils.log("SAXParseException : " + e);
    }

    private ProjectThing makeProjectThing(String type, HashMap<String, String> ht_attributes) {
        try {
            type = type.toLowerCase();
            long id = -1L;
            String sid = ht_attributes.remove("id");
            if (null != sid) {
                id = Long.parseLong(sid);
            }
            long oid = -1L;
            String soid = ht_attributes.remove("oid");
            if (null != soid) {
                oid = Long.parseLong(soid);
            }
            Boolean expanded = new Boolean(false);
            String eob = ht_attributes.remove("expanded");
            if (null != eob) {
                expanded = new Boolean(eob);
            }
            String title = ht_attributes.remove("title");
            TemplateThing tt = this.project.getTemplateThing(type);
            if (null == tt) {
                Utils.log("No template for type " + type);
                return null;
            }
            ProjectThing pt = new ProjectThing(tt, this.project, id, null == title ? type : title, null);
            pt.addToDatabase();
            this.ht_pt_expanded.put(pt, expanded);
            if (-1L != oid) {
                this.ht_oid_pt.put(new Long(oid), pt);
            }
            return pt;
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    private void addToLastOpenLayer(Displayable d) {
        int i = this.al_layers.size() - 1;
        if (i > -1) {
            this.al_layers.get(i).addSilently(d);
        }
    }

    private void addToLastOpenLayerSet(ZDisplayable zd) {
        int i = this.al_layer_sets.size() - 1;
        if (i > -1) {
            this.al_layer_sets.get(i).addSilently(zd);
        }
    }

    private void putLinkedProperty(Displayable origin, HashMap<String, String> ht_attributes) {
        Map<String, String> p;
        Long target_id;
        String stid = ht_attributes.get("target_id");
        if (null == stid) {
            Utils.log2("Can't setLinkedProperty to null target id for origin Displayable " + origin.getId());
            return;
        }
        try {
            target_id = Long.parseLong(stid);
        }
        catch (NumberFormatException e) {
            Utils.log2("Unparseable target_id: " + stid + ", for origin " + origin.getId());
            return;
        }
        String key = ht_attributes.get("key");
        String value = ht_attributes.get("value");
        if (null == key || null == value) {
            Utils.log("Skipping linked property for Displayable " + origin.getId() + ": null key or value");
            return;
        }
        key = key.trim();
        value = value.trim();
        if (0 == key.length() || 0 == value.length()) {
            Utils.log("Skipping linked property for Displayable " + origin.getId() + ": empty key or value");
            return;
        }
        Map<Long, Map<String, String>> linked_props = this.all_linked_props.get(origin);
        if (null == linked_props) {
            linked_props = new HashMap<Long, Map<String, String>>();
            this.all_linked_props.put(origin, linked_props);
        }
        if (null == (p = linked_props.get(target_id))) {
            p = new HashMap<String, String>();
            linked_props.put(target_id, p);
        }
        p.put(key, value);
    }

    private LayerThing makeLayerThing(String type, final HashMap<String, String> ht_attributes) {
        try {
            type = type.toLowerCase();
            if (0 == type.indexOf("t2_")) {
                type = type.substring(3);
            }
            long oid = -1L;
            String soid = ht_attributes.get("oid");
            if (null != soid) {
                oid = Long.parseLong(soid);
            }
            if (type.equals("node")) {
                if (null == this.last_tree) {
                    throw new NullPointerException("Can't create a node for null last_tree!");
                }
                Node<?> node = this.last_tree.newNode(ht_attributes);
                this.taggables.add(node);
                long ndlid = Long.parseLong(ht_attributes.get("lid"));
                List<Node<?>> list = this.node_layer_table.get(ndlid);
                if (null == list) {
                    list = new ArrayList();
                    this.node_layer_table.put(ndlid, list);
                }
                list.add(node);
                if (null == this.last_root_node) {
                    this.last_root_node = node;
                } else {
                    String sconf;
                    this.nodes.getLast().add(node, null == (sconf = ht_attributes.get("c")) ? (byte)5 : (byte)Byte.parseByte(sconf));
                }
                String scolor = ht_attributes.get("color");
                if (null != scolor) {
                    Color color = Utils.getRGBColorFromHex(scolor);
                    Collection<Node<?>> nodes = this.node_colors.get(color);
                    if (null == nodes) {
                        nodes = new ArrayList();
                        this.node_colors.put(color, nodes);
                    }
                    nodes.add(node);
                }
                this.nodes.add(node);
            } else {
                if (type.equals("profile")) {
                    Profile profile = new Profile(this.project, oid, ht_attributes, this.ht_links);
                    profile.addToDatabase();
                    this.ht_displayables.put(oid, profile);
                    this.addToLastOpenLayer(profile);
                    this.last_displayable = profile;
                    return null;
                }
                if (type.equals("pipe")) {
                    Pipe pipe = new Pipe(this.project, oid, ht_attributes, this.ht_links);
                    pipe.addToDatabase();
                    this.ht_displayables.put(new Long(oid), pipe);
                    this.ht_zdispl.put(new Long(oid), pipe);
                    this.last_displayable = pipe;
                    this.addToLastOpenLayerSet(pipe);
                    return null;
                }
                if (type.equals("polyline")) {
                    Polyline pline = new Polyline(this.project, oid, ht_attributes, this.ht_links);
                    pline.addToDatabase();
                    this.last_displayable = pline;
                    this.ht_displayables.put(new Long(oid), pline);
                    this.ht_zdispl.put(new Long(oid), pline);
                    this.addToLastOpenLayerSet(pline);
                    return null;
                }
                if (type.equals("connector")) {
                    final Connector con = new Connector(this.project, oid, ht_attributes, this.ht_links);
                    if (ht_attributes.containsKey("origin")) {
                        this.legacy.add(new Runnable(){

                            @Override
                            public void run() {
                                con.readLegacyXML((LayerSet)TMLHandler.this.al_layer_sets.get(TMLHandler.this.al_layer_sets.size() - 1), ht_attributes, TMLHandler.this.ht_links);
                            }
                        });
                    }
                    con.addToDatabase();
                    this.last_connector = con;
                    this.last_tree = con;
                    this.last_displayable = con;
                    this.ht_displayables.put(new Long(oid), con);
                    this.ht_zdispl.put(new Long(oid), con);
                    this.addToLastOpenLayerSet(con);
                    return null;
                }
                if (type.equals("path")) {
                    if (null != this.reca) {
                        this.reca.add(ht_attributes.get("d"));
                        return null;
                    }
                    return null;
                }
                if (type.equals("area")) {
                    this.reca = new ReconstructArea();
                    if (null != this.last_area_list) {
                        this.last_area_list_layer_id = Long.parseLong(ht_attributes.get("layer_id"));
                    }
                    return null;
                }
                if (type.equals("area_list")) {
                    AreaList area = new AreaList(this.project, oid, ht_attributes, this.ht_links);
                    area.addToDatabase();
                    this.last_area_list = area;
                    this.last_displayable = area;
                    this.ht_displayables.put(new Long(oid), area);
                    this.ht_zdispl.put(new Long(oid), area);
                    this.addToLastOpenLayerSet(area);
                    return null;
                }
                if (type.equals("tag")) {
                    Taggable t = this.taggables.getLast();
                    if (null != t) {
                        Tag tag;
                        String ob = ht_attributes.get("key");
                        int keyCode = 84;
                        if (null != ob) {
                            keyCode = ob.toUpperCase().charAt(0);
                        }
                        if (null != (tag = this.al_layer_sets.get(this.al_layer_sets.size() - 1).putTag(ht_attributes.get("name"), keyCode))) {
                            t.addTag(tag);
                        }
                    }
                } else {
                    if (type.equals("ball_ob")) {
                        if (null != this.last_ball) {
                            this.last_ball.addBall(Double.parseDouble(ht_attributes.get("x")), Double.parseDouble(ht_attributes.get("y")), Double.parseDouble(ht_attributes.get("r")), Long.parseLong(ht_attributes.get("layer_id")));
                        }
                        return null;
                    }
                    if (type.equals("ball")) {
                        Ball ball = new Ball(this.project, oid, ht_attributes, this.ht_links);
                        ball.addToDatabase();
                        this.last_ball = ball;
                        this.last_displayable = ball;
                        this.ht_displayables.put(new Long(oid), ball);
                        this.ht_zdispl.put(new Long(oid), ball);
                        this.addToLastOpenLayerSet(ball);
                        return null;
                    }
                    if (type.equals("stack")) {
                        Stack stack = new Stack(this.project, oid, ht_attributes, this.ht_links);
                        stack.addToDatabase();
                        this.last_stack = stack;
                        this.last_displayable = stack;
                        this.ht_displayables.put(new Long(oid), stack);
                        this.ht_zdispl.put(new Long(oid), stack);
                        this.addToLastOpenLayerSet(stack);
                    } else if (type.equals("treeline")) {
                        Treeline tline = new Treeline(this.project, oid, ht_attributes, this.ht_links);
                        tline.addToDatabase();
                        this.last_treeline = tline;
                        this.last_tree = tline;
                        this.last_treeline_data = new StringBuilder();
                        this.last_displayable = tline;
                        this.ht_displayables.put(oid, tline);
                        this.ht_zdispl.put(oid, tline);
                        this.addToLastOpenLayerSet(tline);
                    } else if (type.equals("areatree")) {
                        AreaTree art = new AreaTree(this.project, oid, ht_attributes, this.ht_links);
                        art.addToDatabase();
                        this.last_areatree = art;
                        this.last_tree = art;
                        this.last_displayable = art;
                        this.ht_displayables.put(oid, art);
                        this.ht_zdispl.put(oid, art);
                        this.addToLastOpenLayerSet(art);
                    } else if (type.equals("dd_item")) {
                        if (null != this.last_dissector) {
                            this.last_dissector.addItem(Integer.parseInt(ht_attributes.get("tag")), Integer.parseInt(ht_attributes.get("radius")), ht_attributes.get("points"));
                        }
                    } else {
                        if (type.equals("label")) {
                            DLabel label = new DLabel(this.project, oid, ht_attributes, this.ht_links);
                            label.addToDatabase();
                            this.ht_displayables.put(new Long(oid), label);
                            this.addToLastOpenLayer(label);
                            this.last_displayable = label;
                            return null;
                        }
                        if (type.equals("annot")) {
                            this.last_annotation = new StringBuilder();
                            return null;
                        }
                        if (type.equals("patch")) {
                            Patch patch = new Patch(this.project, oid, ht_attributes, this.ht_links);
                            patch.addToDatabase();
                            this.ht_displayables.put(new Long(oid), patch);
                            this.addToLastOpenLayer(patch);
                            this.last_patch = patch;
                            this.last_displayable = patch;
                            this.checkAlphaMasks(patch);
                            return null;
                        }
                        if (type.equals("filter")) {
                            this.last_patch_filters.add(this.newFilter(ht_attributes));
                        } else if (type.equals("dissector")) {
                            Dissector dissector = new Dissector(this.project, oid, ht_attributes, this.ht_links);
                            dissector.addToDatabase();
                            this.last_dissector = dissector;
                            this.last_displayable = dissector;
                            this.ht_displayables.put(new Long(oid), dissector);
                            this.ht_zdispl.put(new Long(oid), dissector);
                            this.addToLastOpenLayerSet(dissector);
                        } else if (type.equals("layer")) {
                            int i = this.al_layer_sets.size() - 1;
                            if (i > -1) {
                                LayerSet set = this.al_layer_sets.get(i);
                                Layer layer = new Layer(this.project, oid, ht_attributes);
                                layer.addToDatabase();
                                set.addSilently(layer);
                                this.al_layers.add(layer);
                                String ot = ht_attributes.get("title");
                                return new LayerThing(this.template_layer_thing, this.project, -1L, null == ot ? null : ot, layer, null);
                            }
                        } else {
                            if (type.equals("layer_set")) {
                                LayerSet set = new LayerSet(this.project, oid, ht_attributes, this.ht_links);
                                this.last_displayable = set;
                                set.addToDatabase();
                                this.ht_displayables.put(new Long(oid), set);
                                this.al_layer_sets.add(set);
                                this.addToLastOpenLayer(set);
                                String ot = ht_attributes.get("title");
                                return new LayerThing(this.template_layer_set_thing, this.project, -1L, null == ot ? null : ot, set, null);
                            }
                            if (type.equals("calibration")) {
                                int i = this.al_layer_sets.size() - 1;
                                if (i > -1) {
                                    LayerSet set = this.al_layer_sets.get(i);
                                    set.restoreCalibration(ht_attributes);
                                    return null;
                                }
                            } else if (type.equals("prop")) {
                                if (null != this.last_displayable) {
                                    this.last_displayable.setProperty(ht_attributes.get("key"), ht_attributes.get("value"));
                                }
                            } else if (type.equals("linked_prop")) {
                                if (null != this.last_displayable) {
                                    this.putLinkedProperty(this.last_displayable, ht_attributes);
                                }
                            } else {
                                Utils.log2("TMLHandler Unknown type: " + type);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
        return null;
    }

    private void checkAlphaMasks(Patch patch) {
        if (0L == patch.getAlphaMaskId()) {
            File f = new File(patch.getImageFilePath());
            String path = this.loader.getMasksFolder() + FSLoader.createIdPath(Long.toString(patch.getId()), f.getName(), ".zip");
            if (new File(path).exists()) {
                try {
                    if (patch.setAlphaMask((ByteProcessor)this.loader.openImagePlus(path).getProcessor().convertToByte(false))) {
                        this.loader.markStaleFileForDeletionUponSaving(path);
                        Utils.log("Upgraded alpha mask for patch #" + patch.getId());
                    } else {
                        Utils.log("ERROR: failed to upgrade alpha mask for patch #" + patch.getId());
                    }
                }
                catch (Exception e) {
                    Utils.log("FAILED to restore alpha mask for patch #" + patch.getId() + ":");
                    IJError.print(e);
                }
            }
        }
    }

    private final IFilter newFilter(HashMap<String, String> ht_attributes) {
        try {
            return (IFilter)Class.forName(ht_attributes.remove("class")).getConstructor(Map.class).newInstance(ht_attributes);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create filter for Patch #" + this.last_patch.getId(), e);
        }
    }

    private final void makeCoordinateTransform(String type, HashMap<String, String> ht_attributes) {
        try {
            type = type.toLowerCase();
            if (type.equals("ict_transform")) {
                CoordinateTransform ct = (CoordinateTransform)Class.forName(ht_attributes.get("class")).newInstance();
                ct.init(ht_attributes.get("data"));
                if (this.ct_list_stack.isEmpty()) {
                    if (this.last_patch != null) {
                        this.last_ct = ct;
                    }
                } else {
                    this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ct);
                }
            } else if (type.equals("iict_transform")) {
                InvertibleCoordinateTransform ict = (InvertibleCoordinateTransform)Class.forName(ht_attributes.get("class")).newInstance();
                ict.init(ht_attributes.get("data"));
                if (this.ct_list_stack.isEmpty()) {
                    if (this.last_patch != null) {
                        this.last_ct = ict;
                    } else if (this.last_stack != null) {
                        this.last_ict = ict;
                    }
                } else {
                    this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ict);
                }
            } else if (type.equals("ict_transform_list")) {
                CoordinateTransformList ctl = new CoordinateTransformList();
                if (this.ct_list_stack.isEmpty()) {
                    if (this.last_patch != null) {
                        this.last_ct = ctl;
                    }
                } else {
                    this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ctl);
                }
                this.ct_list_stack.add((TransformList<Object>)ctl);
            } else if (type.equals("iict_transform_list")) {
                InvertibleCoordinateTransformList ictl = new InvertibleCoordinateTransformList();
                if (this.ct_list_stack.isEmpty()) {
                    if (this.last_patch != null) {
                        this.last_ct = ictl;
                    } else if (this.last_stack != null) {
                        this.last_ict = ictl;
                    }
                } else {
                    this.ct_list_stack.get(this.ct_list_stack.size() - 1).add((Object)ictl);
                }
                this.ct_list_stack.add((TransformList<Object>)ictl);
            }
        }
        catch (Exception e) {
            IJError.print(e);
        }
    }

    private final Node<Float> parseBranch(String s) {
        int first = s.indexOf(40);
        int last = s.indexOf(41, first + 1);
        String[] coords = s.substring(first + 1, last).split(" ");
        Treeline.RadiusNode prev = null;
        ArrayList<Treeline.RadiusNode> nodes = new ArrayList<Treeline.RadiusNode>();
        for (int i = 0; i < coords.length; i += 3) {
            long lid = Long.parseLong(coords[i + 2]);
            Treeline.RadiusNode nd = new Treeline.RadiusNode(Float.parseFloat(coords[i]), Float.parseFloat(coords[i + 1]), null);
            ((Node)nd).setData(Float.valueOf(0.0f));
            nodes.add(nd);
            List<Node<?>> list = this.node_layer_table.get(lid);
            if (null == list) {
                list = new ArrayList();
                this.node_layer_table.put(lid, list);
            }
            list.add(nd);
            if (null == prev) {
                prev = nd;
                continue;
            }
            prev.add(nd, (byte)5);
            prev = nd;
        }
        int ibranches = s.indexOf(":branches", last + 1);
        if (-1 != ibranches) {
            int len = s.length();
            int open = s.indexOf(123, ibranches + 9);
            while (-1 != open) {
                int end;
                int level = 1;
                for (end = open + 1; end < len; ++end) {
                    switch (s.charAt(end)) {
                        case '{': {
                            ++level;
                            break;
                        }
                        case '}': {
                            --level;
                        }
                    }
                    if (0 == level) break;
                }
                int openbranch = s.indexOf(123, open + 1);
                int branchindex = Integer.parseInt(s.substring(open + 1, openbranch - 1));
                ((Node)nodes.get(branchindex)).add(this.parseBranch(s.substring(open, end)), (byte)5);
                open = s.indexOf(123, end + 1);
            }
        }
        return (Node)nodes.get(0);
    }
}

